<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Migrations
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('individuals');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('individuals', function (Blueprint $Table) {
            $Table->id();
            $Table->uuid('uuid');
            $Table->boolean('active')->default(1);

            $Table->timestamp('created_at');
            $Table->softDeletes('deleted_at');
            $Table->timestamp('updated_at');

            $Table->string('company', 30)->nullable();
            $Table->boolean('contact')->default(0)->nullable();
            $Table->string('contact_group', 30)->nullable();
            $Table->string('cost_center', 30)->nullable()->comment('Kostenstelle');
            $Table->date('date_of_birth')->nullable();
            $Table->date('date_of_entry')->nullable();
            $Table->string('department', 50)->nullable()->comment('Abteilung');
            $Table->string('email', 255)->nullable();
            $Table->boolean('emergency_contact')->default(0);
            $Table->foreignId('entity_type_id')->constrained(table: 'entity_types', indexName: 'individuals_FK_entity_type_id');
            $Table->string('first_name', 50)->nullable();
            $Table->string('form_of_address', 10)->nullable();
            $Table->string('function', 50)->nullable();
            $Table->string('gender', 30)->nullable();
            $Table->boolean('global_contact')->default(0);
            $Table->string('id_number', 36)->nullable();
            $Table->string('job_title', 30)->nullable()->comment('Berufsbezeichnung');
            $Table->string('last_name', 50)->nullable();
            $Table->string('mobile_phone_number', 20)->nullable();
            $Table->string('mobile_phone_number_country_code', 4)->nullable();
            $Table->string('mobile_phone_number_full', 25)->nullable();
            $Table->string('organizational_unit', 30)->nullable()->comment('Dienstgruppe');
            $Table->string('personnel_number', 30)->nullable()->comment('Personalnummer');
            $Table->string('phone_number', 20)->nullable();
            $Table->string('phone_number_country_code', 4)->nullable();
            $Table->string('phone_number_full', 25)->nullable();
            $Table->foreignId('user_id')->nullable()->constrained(table: 'users', indexName: 'individuals_FK_user_id');

            $Table->index('entity_type_id', 'individuals_FKI_entity_type_id');
            $Table->index('user_id',        'individuals_FKI_user_id');

            new CodeGenerator($Table, [
                'columns' => [
                    'uuid' => [
                        'guarded' => true,
                    ],
                    'active' => [
                        'sortable' => true,
                    ],
                    'contact' => [
                        'sortable' => true,
                    ],
                    'department' => [
                        'sortable' => true,
                    ],
                    'email' => [
                        'ruleType' => 'email',
                        'sortable' => true,
                    ],
                    'emergency_contact' => [
                        'sortable' => true,
                    ],
                    'first_name' => [
                        'sortable' => true,
                    ],
                    'function' => [
                        'sortable' => true,
                    ],
                    'global_contact' => [
                        'sortable' => true,
                    ],
                    'last_name' => [
                        'sortable' => true,
                    ],
                    'personnel_number' => [
                        'ruleType' => 'numeric',
                        'sortable' => true,
                    ],
                    'user_id' => [
                        'guarded' => true,
                        'reverseRelationType' => 'hasOne',
                    ]
                ],
                'entity-type' => true,
                'indexQueries' => [
                    'terminal' => '$Query->where(\'active\', \'=\', 1)',
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],
                'traits' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\Traits\\HasActiveScope',
                        'BplanBase\\Globals\Traits\\HasOrderedScope',
                    ],
                ],
            ]);

        });

    } // up()
};
