<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base\globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders\Demo;


use BplanBase\Globals\Models\UserRecord;
use BplanBase\Globals\Repositories\UserRepository;
use Illuminate\Database\Seeder;


/**
 * Seeder Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UserRecordSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        UserRecord::insert([
            [
                'id' => UserRepository::getByEmail('demo.admin@bplan-solutions.de')->id,
                'uuid' => UserRepository::getByEmail('demo.admin@bplan-solutions.de')->uuid,
                'created_at' => $date,
                'updated_at' => $date,
                'email' => 'demo.admin@bplan-solutions.de',
                'first_name' => 'Demo',
                'last_name' => 'Admin',
            ],
            [
                'id' => UserRepository::getByEmail('demo.user@bplan-solutions.de')->id,
                'uuid' => UserRepository::getByEmail('demo.user@bplan-solutions.de')->uuid,
                'created_at' => $date,
                'updated_at' => $date,
                'email' => 'demo.user@bplan-solutions.de',
                'first_name' => 'Demo',
                'last_name' => 'User',
            ],
        ]);
    } // run()


} // class UserRecordSeeder extends Seeder {}
