<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders;


use BplanBase\Globals\Models\EntityType;
use BplanBase\Globals\Models\EntityTypeField;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class RegisterEntityTypeFieldEmployeeSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return      void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        $EntityType = EntityType::where('identifier', '=', 'Individual.Employee')->first();

        EntityTypeField::insert([
            /*
                Technical Fields:
                - uuid
                - created_at
                - deleted_at
                - updated_at
                - entity_type_id
            */
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'company',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'Company',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'contact',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'Contact',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'contact_group',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'ContactGroup',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'cost_center',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'CostCenter',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'date_of_birth',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'DateOfBirth',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'date_of_entry',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'DateOfEntry',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'department',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'Department',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'email',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'Email',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'emergency_contact',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'EmergencyContact',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'first_name',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'FirstName',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'form_of_address',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'FormOfAddress',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'function',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'Function',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'gender',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'Gender',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'global_contact',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'GlobalContact',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'id_number',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'IdNumber',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'job_title',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'JobTitle',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'last_name',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'LastName',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'license_plate',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'LicensePlate',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'mobile_phone_number',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'MobilePhoneNumber',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'mobile_phone_number_country_code',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'MobilePhoneNumberCountryCode',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'organizational_unit',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'OrganizationalUnit',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'personnel_number',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'PersonnelNumber',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'phone_number',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'PhoneNumber',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'phone_number_country_code',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'PhoneNumberCountryCode',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'user_id',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'UserId',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'var_001',
                'entity_type_id' => $EntityType->id,
                'identifier' => 'Var001',
            ],

        ]);

    } // run()

} // class RegisterEntityTypeFieldEmployeeSeeder extends Seeder {}
