<?php
/**
 * Base Repository Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Repositories
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Foundation\Repositories;


use Illuminate\Database\Eloquent\Builder;


/**
 * Base Repository Class
 *
 * @version     1.0.0 / 2025-06-04
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class BaseRepository
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     null|string $_derivedModelClass
     */
    protected static $_derivedModelClass;


    /**
     * @var     string $_modelClass
     */
    protected static $_modelClass;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      Builder
     *
     * @version     1.0.0 / 2025-06-04
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected static function _newBaseQuery(): Builder
    {
        return static::$_modelClass::query();

    } // _newBaseQuery()


    /**
     *
     * @return      Builder
     *
     * @version     1.0.0 / 2025-06-04
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected static function _prepareGetQuery(Builder|null $Query): Builder
    {
        $Query ??= self::_newBaseQuery();

        return self::_validateQueryModel($Query);

    } // _prepareGetQuery()


    /**
     *
     * @param       Builder $Query
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-06-04
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected static function _validateQueryModel(Builder $Query): void
    {
        $QueryModel = $Query->getModel();

        if (!($QueryModel instanceof static::$_modelClass) && (static::$_derivedModelClass !== null && !($QueryModel instanceof static::$_derivedModelClass))) {
            throw new \InvalidArgumentException('Expected builder for ['.static::$_modelClass.' || '.static::$_derivedModelClass.'], got ['.get_class($QueryModel).'].');
        }
    } // _validateQueryModel()


} // class BaseRepository {}
