<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

use Illuminate\Support\Facades\Route;


use BplanBase\Globals\Http\Controllers\Core\EntityTypeController;
use BplanBase\Globals\Http\Controllers\Core\EntityTypeFieldController;
use BplanBase\Globals\Http\Controllers\Core\ExternalSystemController;
use BplanBase\Globals\Http\Controllers\Core\ModuleController;
use BplanBase\Globals\Http\Controllers\Core\ModuleTenantController;
use BplanBase\Globals\Http\Controllers\Core\RoleController;
use BplanBase\Globals\Http\Controllers\Core\SystemFieldController;
use BplanBase\Globals\Http\Controllers\Core\SystemInfoController;
use BplanBase\Globals\Http\Controllers\Core\TenantExternalSystemController;
use BplanBase\Globals\Http\Controllers\Core\TenantRecordController;
use BplanBase\Globals\Http\Controllers\Core\TenantController;
use BplanBase\Globals\Http\Controllers\Core\UserRecordController;
use BplanBase\Globals\Http\Controllers\Core\UserController;


Route::middleware([
        'web',
        'auth:sanctum',
        config('jetstream.auth_session'),
        'verified',
        'access-level.or.roles:SystemManager',

    ])->prefix('core')->group(function () {

        Route::delete('/entity-types/{id}/delete',            [EntityTypeController::class,           'destroy'])->name('delete.entity-type');
        Route::get('/entity-types',                           [EntityTypeController::class,           'index'])->name('entity-types');
        Route::get('/entity-types/create',                    [EntityTypeController::class,           'create'])->name('create.entity-type');
        Route::get('/entity-types/{id}',                      [EntityTypeController::class,           'edit'])->name('entity-type');

        Route::delete('/entity-type-fields/{id}/delete',      [EntityTypeFieldController::class,      'destroy'])->name('delete.entity-type-field');
        Route::get('/entity-type-fields',                     [EntityTypeFieldController::class,      'index'])->name('entity-type-fields');
        Route::get('/entity-type-fields/create',              [EntityTypeFieldController::class,      'create'])->name('create.entity-type-field');
        Route::get('/entity-type-fields/{id}',                [EntityTypeFieldController::class,      'edit'])->name('entity-type-field');

        Route::delete('/external-systems/{id}/delete',        [ExternalSystemController::class,       'destroy'])->name('delete.external-system');
        Route::get('/external-systems',                       [ExternalSystemController::class,       'index'])->name('external-systems');
        Route::get('/external-systems/create',                [ExternalSystemController::class,       'create'])->name('create.external-system');
        Route::get('/external-systems/{id}',                  [ExternalSystemController::class,       'edit'])->name('external-system');

        Route::delete('/entity-type-fields/{id}/delete',      [EntityTypeFieldController::class,      'destroy'])->name('delete.entity-type-field');
        Route::get('/entity-type-fields',                     [EntityTypeFieldController::class,      'index'])->name('entity-type-fields');
        Route::get('/entity-type-fields/create',              [EntityTypeFieldController::class,      'create'])->name('create.entity-type-field');
        Route::get('/entity-type-fields/{id}',                [EntityTypeFieldController::class,      'edit'])->name('entity-type-field');

        Route::delete('/modules/{id}/delete',                 [ModuleController::class,               'destroy'])->name('delete.module');
        Route::get('/modules',                                [ModuleController::class,               'index'])->name('modules');
        Route::get('/modules/create',                         [ModuleController::class,               'create'])->name('create.module');
        Route::get('/modules/{id}',                           [ModuleController::class,               'edit'])->name('module');

        // Route::delete('/tenant-modules/{id}/delete',          [ModuleTenantController::class,         'destroy'])->name('delete.tenant-module');
        // Route::get('/tenant-modules',                         [ModuleTenantController::class,         'index'])->name('tenant-modules');
        // Route::get('/tenant-modules/create',                  [ModuleTenantController::class,         'create'])->name('create.tenant-module');
        // Route::get('/tenant-modules/{id}',                    [ModuleTenantController::class,         'edit'])->name('tenant-module');

        Route::delete('/roles/{id}/delete',                   [RoleController::class,                 'destroy'])->name('delete.role');
        Route::get('/roles',                                  [RoleController::class,                 'index'])->name('roles');
        Route::get('/roles/create',                           [RoleController::class,                 'create'])->name('create.role');
        Route::get('/roles/{id}',                             [RoleController::class,                 'edit'])->name('role');

        // Route::delete('/system-fields/{id}/delete',           [SystemFieldController::class,          'destroy'])->name('delete.system-field');
        // Route::get('/system-fields',                          [SystemFieldController::class,          'index'])->name('system-fields');
        // Route::get('/system-fields/create',                   [SystemFieldController::class,          'create'])->name('create.system-field');
        // Route::get('/system-fields/{id}',                     [SystemFieldController::class,          'edit'])->name('system-field')
        // Route::get('/systeminfos',                            [SystemInfoController::class,           'index'])->name('systeminfos')

        Route::delete('/tenants/{id}/delete',                 [TenantController::class,               'destroy'])->name('delete.tenant');
        Route::get('/tenants',                                [TenantController::class,               'index'])->name('tenants');
        Route::get('/tenants/create',                         [TenantController::class,               'create'])->name('create.tenant');
        Route::get('/tenants/{id}',                           [TenantController::class,               'edit'])->name('tenant');

        Route::get('/tenant-records',                         [TenantRecordController::class,         'index'])->name('tenant-records') ;
        Route::get('/tenant-records/create',                  [TenantRecordController::class,         'create'])->name('create.tenant-record');
        Route::get('/tenant-records/{id}',                    [TenantRecordController::class,         'edit'])->name('tenant-record');

        Route::delete('/tenant-external-systems/{id}/delete', [TenantExternalSystemController::class, 'destroy'])->name('delete.tenant-external-system');
        Route::get('/tenant-external-systems',                [TenantExternalSystemController::class, 'index'])->name('tenant-external-systems');
        Route::get('/tenant-external-systems/create',         [TenantExternalSystemController::class, 'create'])->name('create.tenant-external-system');
        Route::get('/tenant-external-systems/{id}',           [TenantExternalSystemController::class, 'edit'])->name('tenant-external-system');

        Route::delete('/users/{id}/delete',                   [UserController::class,                 'destroy'])->name('delete.user');
        Route::get('/users',                                  [UserController::class,                 'index'])->name('users');
        Route::get('/users/create',                           [UserController::class,                 'create'])->name('create.user');
        Route::get('/users/{id}',                             [UserController::class,                 'edit'])->name('user');

        Route::delete('/user-records/{id}/delete',            [UserRecordController::class,           'destroy'])->name('delete.user-record');
        Route::get('/user-records',                           [UserRecordController::class,           'index'])->name('user-records');
        Route::get('/user-records/create',                    [UserRecordController::class,           'create'])->name('create.user-record');
        Route::get('/user-records/{id}',                      [UserRecordController::class,           'edit'])->name('user-record');

    }
);
