<?php
/**
 * Copy Action Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Actions
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Actions\EntityTypeFields;


use BplanBase\Globals\Foundation\Actions\BaseAction;
use BplanBase\Globals\Models\EntityType;
use BplanBase\Globals\Models\EntityTypeField;
use Illuminate\Support\Str;


/**
 * Copy Action Class
 *
 * @version     1.0.0 / 2025-05-29
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Copy extends BaseAction
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected string $_modelClass = EntityTypeField;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       int|string|EntityTypeField $field
     *
     * @param       int|string|EntityType $entityType
     *
     * @return      EntityTypeField
     *
     * @version     1.0.0 / 2025-05-29
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function execute(int|string|Model $field, int|string|Model $entityType): Model
    {
        $Model = $this->_resolveModel($entityType);

        if ($entityType instanceof EntityType) {
            $entityTypeId = $entityType->id;
        } else {
            $entityTypeId = $entityType;
        }
        $Model = $Source->replicate(['deleted', 'entity_type_id']);

        $Model->active = true;
        $Model->entity_type_id = $entityTypeId;

        $Model->save();

        return $Model;

    } // execute()


} // Copy extends BaseAction {}
