<?php
/**
 * Base Repository Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Repositories
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Foundation\Repositories;


use Illuminate\Database\Eloquent\Builder;


/**
 * Base Repository Class
 *
 * @version     2.0.0 / 2025-06-15
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class BaseRepository
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     null|string $_derivedModelClass
     */
    protected static $_derivedModelClass;


    /**
     * @var     string $_modelClass
     */
    protected static $_modelClass;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      Builder
     *
     * @version     1.0.0 / 2025-06-15
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected static function _resolveQuery(Builder|null $Query): Builder
    {
        $Query ??= static::$_modelClass::query();

        $QueryModel = $Query->getModel();

        if (!($QueryModel instanceof static::$_modelClass) && (static::$_derivedModelClass !== null && !($QueryModel instanceof static::$_derivedModelClass))) {
            throw new \InvalidArgumentException('Expected builder for ['.static::$_modelClass.' || '.static::$_derivedModelClass.'], got ['.get_class($QueryModel).'].');
        }
        return $Query;

    } // _resolveQuery()


} // class BaseRepository {}
