<?php
/**
 * Query Helper Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Helpers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Helpers;


use Illuminate\Database\Eloquent\Builder;


/**
 * Query Helper Class
 *
 * @version     1.0.0 / 2025-05-25
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class QueryHelper
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Applies flexible orderBy instructions to the query.
     *
     * @param       Builder $Query
     *              The Eloquent query builder instance.
     *
     * @param       array|string|null $orderBy
     *              The ordering instructions.
     *              The $orderBy parameter can take several formats:
     *
     *              1. A single column name as a string:
     *                  'name'
     *
     *              2. An array of column names as strings (default direction: asc):
     *                  ['name', 'created_at']
     *
     *              3. An array of arrays with 'column' and optional 'direction':
     *                  [
     *                      ['column' => 'name'],
     *                      ['column' => 'created_at', 'direction' => 'desc']
     *                  ]
     *
     *              Mixed format is also supported:
     *                  [
     *                      'priority',
     *                      ['column' => 'created_at', 'direction' => 'desc']
     *                  ]
     *
     * @return      Builder
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function applyOrderBy(Builder $Query, array|string|null $orderBy): Builder
    {
        if ($orderBy === null) {
            return $Query;
        }
        if (is_string($orderBy)) {
            return $Query->orderBy($orderBy);

        } elseif (is_array($orderBy)) {
            foreach ($orderBy as $item) {
                if (is_string($item)) {
                    $Query->orderBy($item);

                } elseif (is_array($item)) {
                    $column = $item['column'] ?? null;
                    $direction = strtolower($item['direction'] ?? 'asc');

                    if ($column !== null) {
                        $Query->orderBy($column, $direction);
                    }
                }
            }
        }
        return $Query;

    } // applyOrderBy()


} // class QueryHelper {}
