<?php
/**
 * Form Request Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-05-25 10:15:03
 * @package     bplan-base/globals
 * @subpackage  FormRequests
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Http\Requests\EntityTypes;


use BplanBase\Globals\Traits\FormRequestKeyPrefix;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;


/**
 * Form Request Class
 *
 * @version     1.0.0 / 2025-05-30
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UpdateRequest extends FormRequest
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use FormRequestKeyPrefix;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var         null|string $_prefix
     */
    protected null|string $_prefix;


    /**
     * @var         int|string|null $_recordId
     */
    protected int|string|null $_recordId;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Get the ID
     *
     * @return      int|string|null
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _resolveRecordId(): int|string|null
    {
        if ($this->_recordId !== null) {
            return $this->_recordId;
        }
        /*
            Implement the logic to get the ID out of the request.
        return $this->route('user') ?? $this->input('id');
        */
        return null;

    } // _resolveRecordId()


    /**
     * Determine if the user is authorized to make this request
     *
     * @return      bool
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function authorize(): bool
    {
        return true;

    } // authorize()


    /**
     * Get the validation rules that apply to the request
     *
     * @return      array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     *
     * @version     1.0.0 / 2025-05-30
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function rules(): array
    {
        $recordId = $this->_resolveRecordId();
        $tenantId = Registry::get('tenantId');

        $rules = [
            'abstract'        => ['sometimes', 'required', 'boolean'],
            'active'          => ['sometimes', 'required', 'boolean'],
            'creatable'       => ['sometimes', 'required', 'boolean'],
            'delete_mode'     => ['sometimes', 'required', 'string'],
            'edit_type'       => ['sometimes', 'required', 'string', 'max:3'],
            'editable'        => ['sometimes', 'required', 'boolean'],
            'historize'       => ['sometimes', 'required', 'boolean'],
            'html_mask'       => ['nullable', 'string', 'max:500'],
            'identifier'      => ['sometimes', 'required', 'string', 'max:65', Rule::unique('entity_types', 'identifier')->ignore($recordId)->where('tenant_id', $tenantId)],
            'internal'        => ['sometimes', 'required', 'boolean'],
            'journalize'      => ['sometimes', 'required', 'boolean'],
            'labels'          => [],
            'main_type'       => ['sometimes', 'required', 'string', 'max:32'],
            'master_id'       => ['nullable', 'integer'],
            'model_id'        => ['sometimes', 'required', 'integer'],
            'module_id'       => ['sometimes', 'required', 'integer'],
            'private'         => ['sometimes', 'required', 'boolean'],
            'require_release' => ['sometimes', 'required', 'boolean'],
            'resource_name'   => ['sometimes', 'required', 'string', 'max:50'],
            'source_id'       => ['nullable', 'integer'],
            'sub_type'        => ['nullable', 'string', 'max:32'],
            'text_mask'       => ['nullable', 'string', 'max:255'],
            'visible'         => ['sometimes', 'required', 'boolean'],

        ];
        if ($this->_prefix === null) {
            return $rules;
        }
        return $this->_prependValidationRuleKeys($rules, $this->_prefix);

    } // rules()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Set the ID and get the validation rules that apply to the request
     *
     * @param       int|string $recordId
     *
     * @param       null|string $prefix
     *
     * @return      array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getRules(int|string $recordId, null|string $prefix = null): array
    {
        $Instance = new static();

        $Instance->_recordId = $recordId;
        $Instance->_prefix = $prefix;

        return $Instance->rules();

    } // getRules()


} // class UpdateRequest extends FormRequest {}
