<?php

namespace BplanBase\Globals\Livewire\Forms;

use App\Models\EntityType;
use App\Repositories\EntityTypeRepository;
use App\Services\IndividualService;
use BplanBase\Globals\Http\Requests\Individuals\StoreRequest;
use BplanBase\Globals\Http\Requests\Individuals\UpdateRequest;
use BplanBase\Globals\Models\Individual;
use Livewire\Form;

class IndividualForm extends Form
{
    public ?Individual $individual;

    public bool $active = true;
    public ?string $company = null;
    public bool $contact = false;
    public ?string $contact_group = null;
    public ?string $cost_center = null;
    public ?string $date_of_birth = null;
    public ?string $date_of_entry = null;
    public ?string $department = null;
    public ?string $email = null;
    public bool $emergency_contact = false;
    public ?string $entity_type_id = null;
    public ?string $first_name = null;
    public ?string $form_of_address = null;
    public ?string $function = null;
    public ?string $gender = null;
    public bool $global_contact = false;
    public ?string $id_number = null;
    public ?string $job_title = null;
    public ?string $last_name = null;
    public ?string $mobile_phone_number = null;
    public ?string $mobile_phone_number_country_code = null;
    public ?string $mobile_phone_number_full = null;
    public ?string $organizational_unit = null;
    public ?string $personnel_number = null;
    public ?string $phone_number = null;
    public ?string $phone_number_country_code = null;
    public ?string $phone_number_full = null;
    public ?string $user_id = null;


    protected IndividualService $individualService;

    public function boot(IndividualService $individualService)
    {
        $this->individualService = $individualService;
        $this->entity_type_id = EntityType::where('identifier', 'Individual.Employee')->first()->id;
    }

    public function rules()
    {
        $id = $this->individual?->id ?? null;
        $rules = [];

        if(!empty($id))
        {
            $rules = UpdateRequest::getRules($id);
        }
        else
        {
            $rules = StoreRequest::getRules();
        }

        return $rules;
    }

    public function setIndividual(Individual $individual)
    {
        $this->individual = $individual;

        $this->active = $individual->active;
        $this->company = $individual->company;
        $this->contact = $individual->contact ?? false;
        $this->contact_group = $individual->contact_group;
        $this->cost_center = $individual->cost_center;
        $this->date_of_birth = $individual->date_of_birth;
        $this->date_of_entry = $individual->date_of_entry;
        $this->department = $individual->department;
        $this->email = $individual->email;
        $this->emergency_contact = $individual->emergency_contact ?? false;
        $this->entity_type_id = $individual->entity_type_id;
        $this->first_name = $individual->first_name;
        $this->form_of_address = $individual->form_of_address;
        $this->function = $individual->function;
        $this->gender = $individual->gender;
        $this->global_contact = $individual->global_contact ?? false;
        $this->id_number = $individual->id_number;
        $this->job_title = $individual->job_title;
        $this->last_name = $individual->last_name;
        $this->mobile_phone_number = $individual->mobile_phone_number;
        $this->mobile_phone_number_country_code = $individual->mobile_phone_number_country_code;
        $this->mobile_phone_number_full = $individual->mobile_phone_number_full;
        $this->organizational_unit = $individual->organizational_unit;
        $this->personnel_number = $individual->personnel_number;
        $this->phone_number = $individual->phone_number;
        $this->phone_number_country_code = $individual->phone_number_country_code;
        $this->phone_number_full = $individual->phone_number_full;
        $this->user_id = $individual->user_id;

    }

    public function create(): Individual
    {
        $this->validate();

        $individual = $this->individualService->create([
            'active' => $this->active,
            'company' => $this->company,
            'contact' => $this->contact,
            'contact_group' => $this->contact_group,
            'cost_center' => $this->cost_center,
            'date_of_birth' => $this->date_of_birth,
            'date_of_entry' => $this->date_of_entry,
            'department' => $this->department,
            'email' => $this->email,
            'emergency_contact' => $this->emergency_contact,
            'entity_type_id' => $this->entity_type_id,
            'first_name' => $this->first_name,
            'form_of_address' => $this->form_of_address,
            'function' => $this->function,
            'gender' => $this->gender,
            'global_contact' => $this->global_contact,
            'id_number' => $this->id_number,
            'job_title' => $this->job_title,
            'last_name' => $this->last_name,
            'mobile_phone_number' => $this->mobile_phone_number,
            'mobile_phone_number_country_code' => $this->mobile_phone_number_country_code,
            'mobile_phone_number_full' => $this->mobile_phone_number_full,
            'organizational_unit' => $this->organizational_unit,
            'personnel_number' => $this->personnel_number,
            'phone_number' => $this->phone_number,
            'phone_number_country_code' => $this->phone_number_country_code,
            'phone_number_full' => $this->phone_number_full,
            'user_id' => $this->user_id,
        ]);

        return $individual;
    }

    public function update(): bool
    {
        $this->validate();

        $this->individualService->update($this->individual, [
            'active' => $this->active,
            'company' => $this->company,
            'contact' => $this->contact,
            'contact_group' => $this->contact_group,
            'cost_center' => $this->cost_center,
            'date_of_birth' => $this->date_of_birth,
            'date_of_entry' => $this->date_of_entry,
            'department' => $this->department,
            'email' => $this->email,
            'emergency_contact' => $this->emergency_contact,
            'entity_type_id' => $this->entity_type_id,
            'first_name' => $this->first_name,
            'form_of_address' => $this->form_of_address,
            'function' => $this->function,
            'gender' => $this->gender,
            'global_contact' => $this->global_contact,
            'id_number' => $this->id_number,
            'job_title' => $this->job_title,
            'last_name' => $this->last_name,
            'mobile_phone_number' => $this->mobile_phone_number,
            'mobile_phone_number_country_code' => $this->mobile_phone_number_country_code,
            'mobile_phone_number_full' => $this->mobile_phone_number_full,
            'organizational_unit' => $this->organizational_unit,
            'personnel_number' => $this->personnel_number,
            'phone_number' => $this->phone_number,
            'phone_number_country_code' => $this->phone_number_country_code,
            'phone_number_full' => $this->phone_number_full,
            'user_id' => $this->user_id,
        ]);

        return true;
    }

    public function delete()
    {
        $this->individualService->delete($this->individual);
    }
}
