<?php

/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-06-11 08:58:13
 * @package     bplan-base/globals
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Livewire\Individuals;

use App\Repositories\IndividualRepository;
use BplanBase\Globals\Models\Individual;
use Livewire\Attributes\Computed;
use Livewire\Attributes\On;
use Livewire\Component;
use Livewire\WithPagination;

/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-06-11
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Index extends Component
{

    /* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */

    use WithPagination;

    /* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */

    /**
     * @var         string $search
     */
    public string $search;

    /* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2025-06-11
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('individual-created'), On('individual-updated'), On('individual-deleted')]
    public function render()
    {
        return view('globals::livewire.individuals.index');
    } // render()

    /**
     *
     * @version     1.0.0 / 2025-06-11
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[Computed()]
    public function individuals()
    {
        $query = Individual::query();

        if (!empty($this->search)) {
            $query->where('first_name', 'like', "%$this->search%")
                ->orWhere('last_name', 'like', "%$this->search%")
                ->orWhere('email', 'like', "%$this->search%");
        }

        return IndividualRepository::getAll(ignoreCache: false, orderBy: null, paginate: true, Query: $query);

    } // individuals()

    /* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */
} // class Index extends Component {}
