<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base\globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders\Dev;


use BplanBase\Globals\Models\UserRecord;
use BplanBase\Globals\Repositories\UserRepository;
use Illuminate\Database\Seeder;


/**
 * Seeder Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UserRecordSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        UserRecord::insert([
            [
                'id' => UserRepository::getByEmail('wassilios.meletiadis@bplan-solutions.de')->id,
                'uuid' => UserRepository::getByEmail('wassilios.meletiadis@bplan-solutions.de')->uuid,
                'created_at' => $date,
                'updated_at' => $date,
                'email' => 'wassilios.meletiadis@bplan-solutions.de',
				'first_name' => 'Wassilios',
				'last_name' => 'Meletiadis',
            ], [
                'id' => UserRepository::getByEmail('emilio.cannarozzo@bplan-solutions.de')->id,
                'uuid' => UserRepository::getByEmail('emilio.cannarozzo@bplan-solutions.de')->uuid,
                'created_at' => $date,
                'updated_at' => $date,
                'email' => 'emilio.cannarozzo@bplan-solutions.de',
				'first_name' => 'Emilio',
				'last_name' => 'Cannarozzo',
            ],
        ]);

    } // run()


} // class UserRecordSeeder extends Seeder {}
