<!DOCTYPE html>
<html lang="de">
  <head>
    <meta charset="UTF-8">
    <title>@lang('globals::demo.page.title')</title>
  </head>
  <body style="background-color:black; color:gray;">

    <h1>@lang('globals::demo.page.heading')</h1>

    <div id="terminal" style="background-color:black; color:lime; font-family: monospace; height:100%; margin-top:20px; overflow-y:scroll; padding: 1rem; white-space:pre;">
        @lang('globals::demo.info.starting')
    </div>

    <script>
        const terminal = document.getElementById('terminal');
        const eventSource = new EventSource('/demo-reset-stream');

        eventSource.onmessage = function(event) {
            terminal.innerHTML += event.data + "<br />";
            terminal.scrollTop = terminal.scrollHeight;
        };

        eventSource.onerror = function(event) {
            terminal.innerHTML += '<br /><strong>{{ __('globals::demo.info.done') }}</strong><br />'
                + '<br /><a href="/" style="color:white; font-size:1.2em; text-decoration:none;">&laquo; {{ __('globals::global.action.back') }}</a><br />';

            eventSource.close();
        };
    </script>

  </body>
</html>
