<?php
/**
 * Update Action Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Actions
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Actions\Users;


use BplanBase\Globals\Foundation\Actions\BaseAction;
use BplanBase\Globals\Models\User;
use BplanBase\Globals\Notifications\PasswordReset;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;


/**
 * Update Action Class
 *
 * @version     1.0.0 / 2025-01-08
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ResetPassword
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected string $_modelClass = User::class;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       int|string|User $user
     *
     * @return      User
     *
     * @version     1.0.0 / 2025-01-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function execute(int|string|Model $user): Model
    {
        $Model = $this->_resolveModel($user);
        
        $randomPassword = Str::random(12);

        $Model->password = Hash::make($randomPassword);

        $Model->save();
        /*
        **  Notification an den User senden. */
        $Model->notify(new PasswordReset($randomPassword));

        $AuthUser = auth()->user();

        if ($AuthUser !== null) {
            Log::info('New Password sent for user '.$Model->name.' '.$Model->email.' by '.$AuthUser->name.' ('.$AuthUser->email.')');
        }
        return $Model;

    } // execute()


} // class ResetPassword {}
