<?php
/**
 * Admin Controller Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Controllers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Http\Controllers\Core;


use BplanBase\Globals\Foundation\Http\Controllers\CoreController;
use BplanBase\Globals\Livewire\Core\ExternalSystems\Form as ExternalSystemFieldForm;
use BplanBase\Globals\Livewire\Core\ExternalSystems\Grid as ExternalSystemFieldGrid;
use BplanBase\Globals\Models\ExternalSystem;
use BplanBase\Globals\Repositories\ExternalSystemRepository;
use BplanBase\Globals\Services\ExternalSystemService;
use Illuminate\Http\Request;


/**
 * Admin Controller Class
 *
 * @version     2.0.0 / 2025-06-03
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ExternalSystemController extends CoreController
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected string $_formClass = ExternalSystemForm::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_gridClass = ExternalSystemGrid::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_modelClass = ExternalSystem::class;


    /**
     * @var     string $_repositoryClass
     */
    protected string $_repositoryClass = ExternalSystemRepository::class;


    /**
     * @var     string $_resourceName
     */
    protected string $_resourceName = 'system-fields';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Request $Request
     *
     * @param       ExternalSystemService $Service
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Request $Request, ExternalSystemService $Service)
    {
        parent::__construct($Request, $Service);

    } // __construct()


    /**
     * Show the form for editing the specified resource.
     *
     * @return      \Illuminate\Http\Response
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function index()
    {
        return view('livewire.grid-container', [
            'Collection' => $this->_Repository->getCollection(),
            'modelClass' => $this->_modelClass,
            'resourceName' => $this->_resourceName,
            'serviceClass' => $this->_Service::class,
        ]);
    } // index()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class ExternalSystemController extends CoreController {}
