<?php
/**
 * Livewire Notification Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  LivewireComponents
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Livewire\Core\Global;


use Livewire\Component;


/**
 * Livewire Notification Component
 *
 * @version     1.0.0 / 2025-05-25
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Notification extends Component
{

    /**
     *  @var    string
     */
    const TYPE__ERROR   = 'ERROR';


    /**
     *  @var    string
     */
    const TYPE__NOTICE  = 'NOTICE';


    /**
     *  @var    string
     */
    const TYPE__SUCCESS = 'SUCCESS';


    /**
     *  @var    string
     */
    const TYPE__WARNING = 'WARNING';


//  *** ************************************************************************


    /**
     *  @var    string  $class
     */
    public $class;


    /**
     *  @var    string  $classes
     */
    private $classes = array(
        self::TYPE__ERROR   => 'text-red-500',
        self::TYPE__NOTICE  => 'text-amber-400',
        self::TYPE__SUCCESS => 'text-green-400',
        self::TYPE__WARNING => 'text-orange-500',
    );


    /**
     *  @var    string  $icon
     */
    public $icon;


    /**
     *  @var    array   $icons
     */
    private $icons = array(
        self::TYPE__ERROR   => 'M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z',
        self::TYPE__NOTICE  => 'M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z',
        self::TYPE__SUCCESS => 'M20.618 5.984A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016zM12 9v2m0 4h.01',
        self::TYPE__WARNING => 'M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z',
    );


    /**
     *  @var    boolean $firstname
     */
    public $status;


    /**
     *  @var    array|string  $message
     */
    public $messages = array();


    /**
     *  @var    boolean  $isError
     */
    public $isError;


    /**
     *  @var    array   $listeners
     */
    protected $listeners = [
        'hideNotification',
        'showNotification',
    ];


    /**
     *  @var    string  $title
     */
    public $title;


    /**
     *  @var    string  $type
     */
    public $type;


//  *** ************************************************************************


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function hideNotification()
    {
        $this->status = false;

    } // hideNotification()


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function notify(string $message): void
    {
        $this->message = $message;

        $this->key = uniqid(); // Neuer eindeutiger Schlüssel bei jedem Aufruf

    } // notify()


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render()
    {
        return view('globals::livewire.core.global.notification');

    } // render()


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    #[On('showNotification')]
    public function showNotification($type, $messages, $title = null)
    {
        $this->class = $this->classes[$type];
        $this->icon = $this->icons[$type];
        $this->title = is_null($title) ? __('globals::core-notification.type.'.$type) : $title;
        $this->type = $type;

        if (!is_array($messages)) {
            $messages = (array) $messages;
        }
        $this->messages = $messages;

        $this->status = true;

    } // showNotification()


} // class Notification extends Component {}
