<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  ViewComponents
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\View\Components\FormElements;


use Closure;


use Illuminate\Support\Collection;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;


/**
 * HTML-Toggle (Checkbox-Replacement)
 *
 * @version     1.0.0 / 2025-05-25
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Toggle extends Component
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     array $_attributeStrings
     */
    protected $_attributeStrings = [];


    /**
     * @var     string $attributeString
     */
    public $attributeString;


    /**
     * @var     string $classAddition
     */
    public $classAddition = '';


    /**
     * @var     string $entangle
     */
    public $entangle;


    /**
     * @var     string $id
     */
    public $id;


    /**
     * @var     string $mandatoryMarker
     */
    public $mandatoryMarker;


    /**
     * @var     string $name
     */
    public $name;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Create a new component instance.
     *
     * @param       string $name
     *
     * @param       array $attributes
     *
     * @param       bool|null|string $group
     *
     * @param       null|string $label
     *
     * @param       bool $mandatory
     *
     * @param       string $modifier
     *
     * @param       bool $readOnly
     *
     * @param       int $width
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(string $name, array $attributes = [],
        public bool|null|string $group = null,
        public null|string $label = '',
        public bool $mandatory = false,
        public string $modifier = '',
        public bool $readOnly = false,
        public int $width = 1
    ) {
        $this->_init($name);
        $this->_processAttributes($attributes);

    } // __construct()


    /**
     *
     * @param       string $name
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(string $name): void
    {
        $this->id = $name;
        $this->name = $name;

        if ($this->group === null || $this->group === true) {
            $this->group = 'main.';

        } elseif ($this->group !== false) {
            if ($this->group[strlen($this->group) - 1] !== '.') {
                $this->group .= '.';
            }
        }
        if (!empty($this->mandatory)) {
            $this->mandatoryMarker = __('globals::global.required-marker');
        }
        if (is_numeric($this->name)) {
            $this->entangle = $this->group.$this->name;
        } else {
            $this->entangle = $this->group.$this->name;
        }
        if ($this->modifier !== '') {
            if ($this->modifier[0] !== '.') {
                $this->modifier = '.'.$this->modifier;
            }
        }
    } // _init()


    /**
     *
     * @param       array $attributes
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processAttributes(array $attributes): void
    {
        if (!empty($attributes)) {
            foreach ($attributes as $attribute => $value) {
                $attribute = strtolower($attribute);

                if ($attribute === 'class' || $attribute === 'id' || $attribute === 'name' || $attribute === 'type' || $attribute === 'wire') {
                    continue;
                }
                $this->_attributeStrings[$attribute] = $attribute.'="'.$value.'"';
            }
            if (isset($attributes['id'])) {
                $this->id = $attributes['id'];
            }
        }
        if ($this->readOnly === false) {
            $this->_attributeStrings['x-bind:class'] = 'x-bind:class="enabled ? \'bg-indigo-600\' : \'bg-gray-200\'"';
            $this->_attributeStrings['x-on:click'] = 'x-on:click="enabled = !enabled;"';
            $this->classAddition .= ' xxx focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500';
        }
    } // _processAttributes()


    /**
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _prepareAttributeString()
    {
        ksort($this->_attributeStrings);

        $this->attributeString = ' '.implode(' ', $this->_attributeStrings);

    } // _prepareAttributeString()


    /**
     * Get the view / contents that represent the component.
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function render(): View|Closure|string
    {
        $this->_prepareAttributeString();

        return view('globals::components.form-elements.toggle');

    } // render()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Toggle extends Component {}
