<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision: 3070 $
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders;


use BplanBase\Globals\Models\Country;
use Illuminate\Database\Seeder;


/**
 * Seeder Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class CountrySeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        Country::insert([
            [
                'id' => 1,
                'active' => 1,
                'area' => 10887,
                'capital_names' => '{"de": "Priština"}',
                'comments' => null,
                'fips10' => 'KV',
                'ioc' => 'KOS',
                'iso3166_alpha_2' => null,
                'iso3166_alpha_3' => 'RKS',
                'iso3166_numeric' => null,
                'local_name' => 'Kosova (Albanisch), Kosovo (Serbisch)',
                'locales' => null,
                'long_names' => '{"de": "Republik Kosovo", "en": "Republic Of Kosovo"}',
                'nationality_names' => '{"de": "kosovorisch"}',
                'nato_country_code_2' => null,
                'nato_country_code_3' => null,
                'short_names' => '{"de": "Kosovo", "en": "Kosovo"}',
                'telephone_country_code' => '+383',
                'telephone_country_code_extended' => '+383',
                'tld' => null,
                'vehicle_registration_code' => 'RKS',
            ],
            [
                'id' => 2,
                'active' => 1,
                'area' => 468,
                'capital_names' => '{"de": "Andorra la Vella"}',
                'comments' => null,
                'fips10' => 'AN',
                'ioc' => 'AND',
                'iso3166_alpha_2' => 'AD',
                'iso3166_alpha_3' => 'AND',
                'iso3166_numeric' => '020',
                'local_name' => 'Andorra',
                'locales' => null,
                'long_names' => '{"de": "Fürstentum Andorra", "en": "Principality Of Andorra"}',
                'nationality_names' => '{"de": "andorranisch"}',
                'nato_country_code_2' => 'AN',
                'nato_country_code_3' => 'AND',
                'short_names' => '{"de": "Andorra", "en": "Andorra"}',
                'telephone_country_code' => '+376',
                'telephone_country_code_extended' => '+376',
                'tld' => '.ad',
                'vehicle_registration_code' => 'AND',
            ],
            [
                'id' => 3,
                'active' => 0,
                'area' => 83600,
                'capital_names' => '{"de": "Abu Dhabi"}',
                'comments' => null,
                'fips10' => 'AE',
                'ioc' => 'UAE',
                'iso3166_alpha_2' => 'AE',
                'iso3166_alpha_3' => 'ARE',
                'iso3166_numeric' => '784',
                'local_name' => 'al-Imārāt al-ʿArabīya al-Muttahida',
                'locales' => null,
                'long_names' => '{"de": "Vereinigte Arabische Emirate", "en": "United Arab Emirates"}',
                'nationality_names' => '{"de": "emiratisch"}',
                'nato_country_code_2' => 'TC',
                'nato_country_code_3' => 'ARE',
                'short_names' => '{"de": "Arabische Emirate", "en": "Arab Emirates"}',
                'telephone_country_code' => '+971',
                'telephone_country_code_extended' => '+971',
                'tld' => '.ae',
                'vehicle_registration_code' => 'UAE',
            ],
            [
                'id' => 4,
                'active' => 0,
                'area' => 652230,
                'capital_names' => '{"de": "Kabul"}',
                'comments' => null,
                'fips10' => 'AF',
                'ioc' => 'AFG',
                'iso3166_alpha_2' => 'AF',
                'iso3166_alpha_3' => 'AFG',
                'iso3166_numeric' => '004',
                'local_name' => 'Afghānestān',
                'locales' => null,
                'long_names' => '{"de": "Islamische Republik Afghanistan", "en": "Islamic Republic Of Afghanistan"}',
                'nationality_names' => '{"de": "afghanisch"}',
                'nato_country_code_2' => 'AF',
                'nato_country_code_3' => 'AFG',
                'short_names' => '{"de": "Afghanistan", "en": "Afghanistan"}',
                'telephone_country_code' => '+93',
                'telephone_country_code_extended' => '+93',
                'tld' => '.af',
                'vehicle_registration_code' => 'AFG',
            ],
            [
                'id' => 5,
                'active' => 0,
                'area' => 443,
                'capital_names' => '{"de": "Saint John’s"}',
                'comments' => null,
                'fips10' => 'AC',
                'ioc' => 'ANT',
                'iso3166_alpha_2' => 'AG',
                'iso3166_alpha_3' => 'ATG',
                'iso3166_numeric' => '028',
                'local_name' => 'Antigua and Barbuda',
                'locales' => null,
                'long_names' => '{"de": "Antigua und Barbuda", "en": "Antigua And Barbuda"}',
                'nationality_names' => '{"de": "antiguanisch"}',
                'nato_country_code_2' => 'AC',
                'nato_country_code_3' => 'ATG',
                'short_names' => '{"de": "Antigua und Barbuda", "en": "Antigua And Barbuda"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1268',
                'tld' => '.ag',
                'vehicle_registration_code' => 'AG',
            ],
            [
                'id' => 6,
                'active' => 0,
                'area' => 96,
                'capital_names' => '{"de": "The Valley", "en": "The Valley"}',
                'comments' => null,
                'fips10' => 'AV',
                'ioc' => null,
                'iso3166_alpha_2' => 'AI',
                'iso3166_alpha_3' => 'AIA',
                'iso3166_numeric' => '660',
                'local_name' => 'Anguilla',
                'locales' => '["en_GB"]',
                'long_names' => '{"de": "Anguilla", "en": "British Overseas Territory Anguilla"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'AV',
                'nato_country_code_3' => 'AIA',
                'short_names' => '{"de": "Anguilla", "en": "Anguilla"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1264',
                'tld' => '.ai',
                'vehicle_registration_code' => 'AXA',
            ],
            [
                'id' => 7,
                'active' => 1,
                'area' => 28748,
                'capital_names' => '{"de": "Tirana"}',
                'comments' => null,
                'fips10' => 'AL',
                'ioc' => 'ALB',
                'iso3166_alpha_2' => 'AL',
                'iso3166_alpha_3' => 'ALB',
                'iso3166_numeric' => '008',
                'local_name' => 'Shqipëria',
                'locales' => null,
                'long_names' => '{"de": "Republik Albanien", "en": "Republic Of Albania"}',
                'nationality_names' => '{"de": "albanisch"}',
                'nato_country_code_2' => 'AL',
                'nato_country_code_3' => 'ALB',
                'short_names' => '{"de": "Albanien", "en": "Albania"}',
                'telephone_country_code' => '+355',
                'telephone_country_code_extended' => '+355',
                'tld' => '.al',
                'vehicle_registration_code' => 'AL',
            ],
            [
                'id' => 8,
                'active' => 1,
                'area' => 29743,
                'capital_names' => '{"de": "Jerewan"}',
                'comments' => null,
                'fips10' => 'AM',
                'ioc' => 'ARM',
                'iso3166_alpha_2' => 'AM',
                'iso3166_alpha_3' => 'ARM',
                'iso3166_numeric' => '051',
                'local_name' => 'Hayastan',
                'locales' => null,
                'long_names' => '{"de": "Republik Armenien", "en": "Republic Of Armenia"}',
                'nationality_names' => '{"de": "armenisch"}',
                'nato_country_code_2' => 'AM',
                'nato_country_code_3' => 'ARM',
                'short_names' => '{"de": "Armenien", "en": "Armenia"}',
                'telephone_country_code' => '+374',
                'telephone_country_code_extended' => '+374',
                'tld' => '.am',
                'vehicle_registration_code' => 'AM',
            ],
            [
                'id' => 9,
                'active' => 0,
                'area' => 1246700,
                'capital_names' => '{"de": "Luanda"}',
                'comments' => null,
                'fips10' => 'AO',
                'ioc' => 'ANG',
                'iso3166_alpha_2' => 'AO',
                'iso3166_alpha_3' => 'AGO',
                'iso3166_numeric' => '024',
                'local_name' => 'Angola',
                'locales' => null,
                'long_names' => '{"de": "Republik Angola", "en": "Republic Of Angola"}',
                'nationality_names' => '{"de": "angolanisch"}',
                'nato_country_code_2' => 'AO',
                'nato_country_code_3' => 'AGO',
                'short_names' => '{"de": "Angola", "en": "Angola"}',
                'telephone_country_code' => '+244',
                'telephone_country_code_extended' => '+244',
                'tld' => '.ao',
                'vehicle_registration_code' => 'ANG',
            ],
            [
                'id' => 10,
                'active' => 0,
                'area' => null,
                'capital_names' => '{"de": ""}',
                'comments' => null,
                'fips10' => 'AY',
                'ioc' => null,
                'iso3166_alpha_2' => 'AQ',
                'iso3166_alpha_3' => 'ATA',
                'iso3166_numeric' => '010',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Antarktis", "en": "Antarctica"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'AY',
                'nato_country_code_3' => 'ATA',
                'short_names' => '{"de": "Antarktis", "en": "Antarctica"}',
                'telephone_country_code' => null,
                'telephone_country_code_extended' => null,
                'tld' => '.aq',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 11,
                'active' => 0,
                'area' => 2780400,
                'capital_names' => '{"de": "Buenos Aires"}',
                'comments' => null,
                'fips10' => 'AR',
                'ioc' => 'ARG',
                'iso3166_alpha_2' => 'AR',
                'iso3166_alpha_3' => 'ARG',
                'iso3166_numeric' => '032',
                'local_name' => 'Argentina',
                'locales' => null,
                'long_names' => '{"de": "Argentinische Republik", "en": "Argentine Republic"}',
                'nationality_names' => '{"de": "argentinisch"}',
                'nato_country_code_2' => 'AR',
                'nato_country_code_3' => 'ARG',
                'short_names' => '{"de": "Argentinien", "en": "Argentina"}',
                'telephone_country_code' => '+54',
                'telephone_country_code_extended' => '+54',
                'tld' => '.ar',
                'vehicle_registration_code' => 'RA',
            ],
            [
                'id' => 12,
                'active' => 0,
                'area' => 199000,
                'capital_names' => '{"de": "Pago Pago", "en": "Pago Pago"}',
                'comments' => null,
                'fips10' => 'AQ',
                'ioc' => 'ASA',
                'iso3166_alpha_2' => 'AS',
                'iso3166_alpha_3' => 'ASM',
                'iso3166_numeric' => '016',
                'local_name' => 'American Samoa',
                'locales' => null,
                'long_names' => '{"de": "Amerikanisch-Samoa", "en": "American Samoa"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'SS',
                'nato_country_code_3' => 'WSM',
                'short_names' => '{"de": "Amerikanisch-Samoa", "en": "American Samoa"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1684',
                'tld' => '.as',
                'vehicle_registration_code' => 'USA',
            ],
            [
                'id' => 13,
                'active' => 1,
                'area' => 83871,
                'capital_names' => '{"de": "Wien"}',
                'comments' => null,
                'fips10' => 'AU',
                'ioc' => 'AUT',
                'iso3166_alpha_2' => 'AT',
                'iso3166_alpha_3' => 'AUT',
                'iso3166_numeric' => '040',
                'local_name' => 'Österreich',
                'locales' => '["de_AT"]',
                'long_names' => '{"de": "Republik Österreich", "en": "Republic Of Austria"}',
                'nationality_names' => '{"de": "österreichisch"}',
                'nato_country_code_2' => 'AU',
                'nato_country_code_3' => 'AUT',
                'short_names' => '{"de": "Österreich", "en": "Austria"}',
                'telephone_country_code' => '+43',
                'telephone_country_code_extended' => '+43',
                'tld' => '.at',
                'vehicle_registration_code' => 'A',
            ],
            [
                'id' => 14,
                'active' => 0,
                'area' => 7741220,
                'capital_names' => '{"de": "Canberra"}',
                'comments' => null,
                'fips10' => 'AS',
                'ioc' => 'AUS',
                'iso3166_alpha_2' => 'AU',
                'iso3166_alpha_3' => 'AUS',
                'iso3166_numeric' => '036',
                'local_name' => 'Australia',
                'locales' => null,
                'long_names' => '{"de": "Australien", "en": "Commonwealth Of Australia"}',
                'nationality_names' => '{"de": "australisch"}',
                'nato_country_code_2' => 'AS',
                'nato_country_code_3' => 'AUS',
                'short_names' => '{"de": "Australien", "en": "Australia"}',
                'telephone_country_code' => '+61',
                'telephone_country_code_extended' => '+61',
                'tld' => '.au',
                'vehicle_registration_code' => 'AUS',
            ],
            [
                'id' => 15,
                'active' => 0,
                'area' => 178000,
                'capital_names' => '{"de": "Oranjestad", "en": "Oranjestad"}',
                'comments' => null,
                'fips10' => 'AA',
                'ioc' => 'ARU',
                'iso3166_alpha_2' => 'AW',
                'iso3166_alpha_3' => 'ABW',
                'iso3166_numeric' => '533',
                'local_name' => 'Aruba',
                'locales' => null,
                'long_names' => '{"de": "Aruba", "en": "Aruba"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'AA',
                'nato_country_code_3' => 'ABW',
                'short_names' => '{"de": "Aruba", "en": "Aruba"}',
                'telephone_country_code' => '+297',
                'telephone_country_code_extended' => '+297',
                'tld' => '.aw',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 16,
                'active' => 0,
                'area' => null,
                'capital_names' => '{"de": "Mariehamn", "en": "Mariehamn"}',
                'comments' => null,
                'fips10' => null,
                'ioc' => null,
                'iso3166_alpha_2' => 'AX',
                'iso3166_alpha_3' => 'ALA',
                'iso3166_numeric' => '248',
                'local_name' => 'Aland Islands',
                'locales' => null,
                'long_names' => '{"de": "Åland", "en": "Åland"}',
                'nationality_names' => null,
                'nato_country_code_2' => null,
                'nato_country_code_3' => null,
                'short_names' => '{"de": "Åland", "en": "Åland"}',
                'telephone_country_code' => '+358',
                'telephone_country_code_extended' => '+358',
                'tld' => '.ax',
                'vehicle_registration_code' => 'AX',
            ],
            [
                'id' => 17,
                'active' => 0,
                'area' => 86600,
                'capital_names' => '{"de": "Baku"}',
                'comments' => null,
                'fips10' => 'AJ',
                'ioc' => 'AZE',
                'iso3166_alpha_2' => 'AZ',
                'iso3166_alpha_3' => 'AZE',
                'iso3166_numeric' => '031',
                'local_name' => 'Azǝrbaycan',
                'locales' => null,
                'long_names' => '{"de": "Republik Aserbaidschan", "en": "Republic Of Azerbaijan"}',
                'nationality_names' => '{"de": "aserbaidschanisch"}',
                'nato_country_code_2' => 'AJ',
                'nato_country_code_3' => 'AZE',
                'short_names' => '{"de": "Aserbaidschan", "en": "Azerbaijan"}',
                'telephone_country_code' => '+994',
                'telephone_country_code_extended' => '+994',
                'tld' => '.az',
                'vehicle_registration_code' => 'AZ',
            ],
            [
                'id' => 18,
                'active' => 1,
                'area' => 51197,
                'capital_names' => '{"de": "Sarajevo"}',
                'comments' => null,
                'fips10' => 'BK',
                'ioc' => 'BIH',
                'iso3166_alpha_2' => 'BA',
                'iso3166_alpha_3' => 'BIH',
                'iso3166_numeric' => '070',
                'local_name' => 'Bosna i Hercegovina',
                'locales' => null,
                'long_names' => '{"de": "Bosnien und Herzegowina", "en": "Bosnia And Herzegovina"}',
                'nationality_names' => '{"de": "bosnisch"}',
                'nato_country_code_2' => 'BK',
                'nato_country_code_3' => 'BIH',
                'short_names' => '{"de": "Bosnien und Herzegowina", "en": "Bosnia And Herzegovina"}',
                'telephone_country_code' => '+387',
                'telephone_country_code_extended' => '+387',
                'tld' => '.ba',
                'vehicle_registration_code' => 'BIH',
            ],
            [
                'id' => 19,
                'active' => 0,
                'area' => 430,
                'capital_names' => '{"de": "Bridgetown"}',
                'comments' => null,
                'fips10' => 'BB',
                'ioc' => 'BAR',
                'iso3166_alpha_2' => 'BB',
                'iso3166_alpha_3' => 'BRB',
                'iso3166_numeric' => '052',
                'local_name' => 'Barbados',
                'locales' => null,
                'long_names' => '{"de": "Barbados", "en": "Barbados"}',
                'nationality_names' => '{"de": "barbadisch"}',
                'nato_country_code_2' => 'BB',
                'nato_country_code_3' => 'BRB',
                'short_names' => '{"de": "Barbados", "en": "Barbados"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1246',
                'tld' => '.bb',
                'vehicle_registration_code' => 'BDS',
            ],
            [
                'id' => 20,
                'active' => 0,
                'area' => 143998,
                'capital_names' => '{"de": "Dhaka"}',
                'comments' => null,
                'fips10' => 'BG',
                'ioc' => 'BAN',
                'iso3166_alpha_2' => 'BD',
                'iso3166_alpha_3' => 'BGD',
                'iso3166_numeric' => '050',
                'local_name' => 'Bāṃlādeś',
                'locales' => null,
                'long_names' => '{"de": "Volksrepublik Bangladesch", "en": "People\'s Republic Of Bangladesh"}',
                'nationality_names' => '{"de": "bengalisch"}',
                'nato_country_code_2' => 'BG',
                'nato_country_code_3' => 'BGD',
                'short_names' => '{"de": "Bangladesch", "en": "Bangladesh"}',
                'telephone_country_code' => '+880',
                'telephone_country_code_extended' => '+880',
                'tld' => '.bd',
                'vehicle_registration_code' => 'BD',
            ],
            [
                'id' => 21,
                'active' => 1,
                'area' => 30528,
                'capital_names' => '{"de": "Brüssel"}',
                'comments' => null,
                'fips10' => 'BE',
                'ioc' => 'BEL',
                'iso3166_alpha_2' => 'BE',
                'iso3166_alpha_3' => 'BEL',
                'iso3166_numeric' => '056',
                'local_name' => 'België (Niederländisch), Belgique (Französisch), Belgien (Deutsch)',
                'locales' => '["fr_BE", "nl_BE"]',
                'long_names' => '{"de": "Königreich Belgien", "en": "Kingdom Of Belgium"}',
                'nationality_names' => '{"de": "belgisch"}',
                'nato_country_code_2' => 'BE',
                'nato_country_code_3' => 'BEL',
                'short_names' => '{"de": "Belgien", "en": "Belgium"}',
                'telephone_country_code' => '+32',
                'telephone_country_code_extended' => '+32',
                'tld' => '.be',
                'vehicle_registration_code' => 'B',
            ],
            [
                'id' => 22,
                'active' => 0,
                'area' => 274200,
                'capital_names' => '{"de": "Ouagadougou"}',
                'comments' => null,
                'fips10' => 'UV',
                'ioc' => 'BUR',
                'iso3166_alpha_2' => 'BF',
                'iso3166_alpha_3' => 'BFA',
                'iso3166_numeric' => '854',
                'local_name' => 'Burkina Faso',
                'locales' => null,
                'long_names' => '{"de": "Burkina Faso", "en": "Burkina Faso"}',
                'nationality_names' => '{"de": "burkina-fasisch"}',
                'nato_country_code_2' => 'UV',
                'nato_country_code_3' => 'BFA',
                'short_names' => '{"de": "Burkina Faso", "en": "Burkina Faso"}',
                'telephone_country_code' => '+226',
                'telephone_country_code_extended' => '+226',
                'tld' => '.bf',
                'vehicle_registration_code' => 'BF',
            ],
            [
                'id' => 23,
                'active' => 1,
                'area' => 110879,
                'capital_names' => '{"de": "Sofia"}',
                'comments' => null,
                'fips10' => 'BU',
                'ioc' => 'BUL',
                'iso3166_alpha_2' => 'BG',
                'iso3166_alpha_3' => 'BGR',
                'iso3166_numeric' => '100',
                'local_name' => 'Bălgarija',
                'locales' => null,
                'long_names' => '{"de": "Republik Bulgarien", "en": "Republic Of Bulgaria"}',
                'nationality_names' => '{"de": "bulgarisch"}',
                'nato_country_code_2' => 'BU',
                'nato_country_code_3' => 'BGR',
                'short_names' => '{"de": "Bulgarien", "en": "Bulgaria"}',
                'telephone_country_code' => '+359',
                'telephone_country_code_extended' => '+359',
                'tld' => '.bg',
                'vehicle_registration_code' => 'BG',
            ],
            [
                'id' => 24,
                'active' => 0,
                'area' => 760000,
                'capital_names' => '{"de": "Manama"}',
                'comments' => null,
                'fips10' => 'BA',
                'ioc' => 'BRN',
                'iso3166_alpha_2' => 'BH',
                'iso3166_alpha_3' => 'BHR',
                'iso3166_numeric' => '048',
                'local_name' => 'al-Bahrayn',
                'locales' => null,
                'long_names' => '{"de": "Königreich Bahrain", "en": "Kingdom Of Bahrain"}',
                'nationality_names' => '{"de": "bahrainisch"}',
                'nato_country_code_2' => 'BA',
                'nato_country_code_3' => 'BHR',
                'short_names' => '{"de": "Bahrain", "en": "Bahrain"}',
                'telephone_country_code' => '+973',
                'telephone_country_code_extended' => '+973',
                'tld' => '.bh',
                'vehicle_registration_code' => 'BRN',
            ],
            [
                'id' => 25,
                'active' => 0,
                'area' => 27830,
                'capital_names' => '{"de": "Bujumbura"}',
                'comments' => null,
                'fips10' => 'BY',
                'ioc' => 'BDI',
                'iso3166_alpha_2' => 'BI',
                'iso3166_alpha_3' => 'BDI',
                'iso3166_numeric' => '108',
                'local_name' => 'Burundi',
                'locales' => null,
                'long_names' => '{"de": "Republik Burundi", "en": "Republic Of Burundi"}',
                'nationality_names' => '{"de": "burundisch"}',
                'nato_country_code_2' => 'BY',
                'nato_country_code_3' => 'BDI',
                'short_names' => '{"de": "Burundi", "en": "Burundi"}',
                'telephone_country_code' => '+257',
                'telephone_country_code_extended' => '+257',
                'tld' => '.bi',
                'vehicle_registration_code' => 'RU',
            ],
            [
                'id' => 26,
                'active' => 0,
                'area' => 112622,
                'capital_names' => '{"de": "Porto-Novo"}',
                'comments' => null,
                'fips10' => 'BN',
                'ioc' => 'BEN',
                'iso3166_alpha_2' => 'BJ',
                'iso3166_alpha_3' => 'BEN',
                'iso3166_numeric' => '204',
                'local_name' => 'Bénin',
                'locales' => null,
                'long_names' => '{"de": "Republik Benin", "en": "Republic Of Benin"}',
                'nationality_names' => '{"de": "beninisch"}',
                'nato_country_code_2' => 'BN',
                'nato_country_code_3' => 'BEN',
                'short_names' => '{"de": "Benin", "en": "Benin"}',
                'telephone_country_code' => '+229',
                'telephone_country_code_extended' => '+229',
                'tld' => '.bj',
                'vehicle_registration_code' => 'BJ',
            ],
            [
                'id' => 27,
                'active' => 0,
                'area' => 21000,
                'capital_names' => '{"de": "Gustavia", "en": "Gustavia"}',
                'comments' => null,
                'fips10' => 'TB',
                'ioc' => null,
                'iso3166_alpha_2' => 'BL',
                'iso3166_alpha_3' => 'BLM',
                'iso3166_numeric' => null,
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Sankt Bartholomäus", "en": "Saint-Barthélemy"}',
                'nationality_names' => null,
                'nato_country_code_2' => null,
                'nato_country_code_3' => null,
                'short_names' => '{"de": "St. Barths", "en": "St. Barts", "fr": "St. Barth"}',
                'telephone_country_code' => '+590',
                'telephone_country_code_extended' => '+590',
                'tld' => '.bl',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 28,
                'active' => 0,
                'area' => 53570,
                'capital_names' => '{"de": "Hamilton", "en": "Hamilton"}',
                'comments' => null,
                'fips10' => 'BD',
                'ioc' => 'BER',
                'iso3166_alpha_2' => 'BM',
                'iso3166_alpha_3' => 'BMU',
                'iso3166_numeric' => null,
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Bermuda", "en": "Bermuda"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'BD',
                'nato_country_code_3' => 'BMU',
                'short_names' => '{"de": "Bermuda", "en": "Bermuda"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1441',
                'tld' => '.bm',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 29,
                'active' => 0,
                'area' => 5765,
                'capital_names' => '{"de": "Bandar Seri Begawan"}',
                'comments' => null,
                'fips10' => 'BX',
                'ioc' => 'BRU',
                'iso3166_alpha_2' => 'BN',
                'iso3166_alpha_3' => 'BRN',
                'iso3166_numeric' => '096',
                'local_name' => 'Negara Brunei Darussalam',
                'locales' => null,
                'long_names' => '{"de": "Brunei Darussalam", "en": "Brunei Darussalam"}',
                'nationality_names' => '{"de": "bruneiisch"}',
                'nato_country_code_2' => 'BX',
                'nato_country_code_3' => 'BRN',
                'short_names' => '{"de": "Brunei", "en": "Brunei"}',
                'telephone_country_code' => '+673',
                'telephone_country_code_extended' => '+673',
                'tld' => '.bn',
                'vehicle_registration_code' => 'BRU',
            ],
            [
                'id' => 30,
                'active' => 0,
                'area' => 1098581,
                'capital_names' => '{"de": "Sucre"}',
                'comments' => null,
                'fips10' => 'BL',
                'ioc' => 'BOL',
                'iso3166_alpha_2' => 'BO',
                'iso3166_alpha_3' => 'BOL',
                'iso3166_numeric' => '068',
                'local_name' => 'Bolivia',
                'locales' => null,
                'long_names' => '{"de": "Plurinationaler Staat Bolivien", "en": "Plurinational State Of Bolivia"}',
                'nationality_names' => '{"de": "bolivianisch"}',
                'nato_country_code_2' => 'BL',
                'nato_country_code_3' => 'BOL',
                'short_names' => '{"de": "Bolivien", "en": "Bolivia"}',
                'telephone_country_code' => '+591',
                'telephone_country_code_extended' => '+591',
                'tld' => '.bo',
                'vehicle_registration_code' => 'BOL',
            ],
            [
                'id' => 31,
                'active' => 0,
                'area' => 288000,
                'capital_names' => '{"de": "Kralendijk", "en": "Kralendijk"}',
                'comments' => null,
                'fips10' => null,
                'ioc' => null,
                'iso3166_alpha_2' => 'BQ',
                'iso3166_alpha_3' => 'BES',
                'iso3166_numeric' => null,
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Bonaire", "en": "Bonaire"}',
                'nationality_names' => null,
                'nato_country_code_2' => null,
                'nato_country_code_3' => null,
                'short_names' => '{"de": "Bonaire", "en": "Bonaire"}',
                'telephone_country_code' => '+599',
                'telephone_country_code_extended' => '+599',
                'tld' => 'bq',
                'vehicle_registration_code' => 'NL',
            ],
            [
                'id' => 32,
                'active' => 0,
                'area' => 8514877,
                'capital_names' => '{"de": "Brasília"}',
                'comments' => null,
                'fips10' => 'BR',
                'ioc' => 'BRA',
                'iso3166_alpha_2' => 'BR',
                'iso3166_alpha_3' => 'BRA',
                'iso3166_numeric' => '076',
                'local_name' => 'Brasil',
                'locales' => null,
                'long_names' => '{"de": "Föderative Republik Brasilien", "en": "Federative Republic Of Brazil"}',
                'nationality_names' => '{"de": "brasilianisch"}',
                'nato_country_code_2' => 'BR',
                'nato_country_code_3' => 'BRA',
                'short_names' => '{"de": "Brasilien", "en": "Brazil"}',
                'telephone_country_code' => '+55',
                'telephone_country_code_extended' => '+55',
                'tld' => '.br',
                'vehicle_registration_code' => 'BR',
            ],
            [
                'id' => 33,
                'active' => 0,
                'area' => 13880,
                'capital_names' => '{"de": "Nassau"}',
                'comments' => null,
                'fips10' => 'BF',
                'ioc' => 'BAH',
                'iso3166_alpha_2' => 'BS',
                'iso3166_alpha_3' => 'BHS',
                'iso3166_numeric' => '044',
                'local_name' => 'Bahamas',
                'locales' => null,
                'long_names' => '{"de": "Commonwealth der Bahamas", "en": "Commonwealth Of The Bahamas"}',
                'nationality_names' => '{"de": "bahamisch"}',
                'nato_country_code_2' => 'BF',
                'nato_country_code_3' => 'BHS',
                'short_names' => '{"de": "Bahamas", "en": "Bahamas"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1242',
                'tld' => '.bs',
                'vehicle_registration_code' => 'BS',
            ],
            [
                'id' => 34,
                'active' => 0,
                'area' => 38394,
                'capital_names' => '{"de": "Thimphu"}',
                'comments' => null,
                'fips10' => 'BT',
                'ioc' => 'BHU',
                'iso3166_alpha_2' => 'BT',
                'iso3166_alpha_3' => 'BTN',
                'iso3166_numeric' => '064',
                'local_name' => 'Bhutan',
                'locales' => null,
                'long_names' => '{"de": "Königreich Bhutan", "en": "Kingdom Of Bhutan"}',
                'nationality_names' => '{"de": "bhutanisch"}',
                'nato_country_code_2' => 'BT',
                'nato_country_code_3' => 'BTN',
                'short_names' => '{"de": "Bhutan", "en": "Bhutan"}',
                'telephone_country_code' => '+975',
                'telephone_country_code_extended' => '+975',
                'tld' => '.bt',
                'vehicle_registration_code' => 'BHT',
            ],
            [
                'id' => 35,
                'active' => 0,
                'area' => 49000,
                'capital_names' => '{"de": ""}',
                'comments' => null,
                'fips10' => 'BV',
                'ioc' => null,
                'iso3166_alpha_2' => 'BV',
                'iso3166_alpha_3' => 'BVT',
                'iso3166_numeric' => '074',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Bouvetinsel", "en": "Bouvet Island"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'BV',
                'nato_country_code_3' => 'BVT',
                'short_names' => '{"de": "Bouvetinsel", "en": "Bouvet Island"}',
                'telephone_country_code' => '+47',
                'telephone_country_code_extended' => '+47',
                'tld' => '.bv',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 36,
                'active' => 0,
                'area' => 581730,
                'capital_names' => '{"de": "Gaborone"}',
                'comments' => null,
                'fips10' => 'BC',
                'ioc' => 'BOT',
                'iso3166_alpha_2' => 'BW',
                'iso3166_alpha_3' => 'BWA',
                'iso3166_numeric' => '072',
                'local_name' => 'Botswana',
                'locales' => null,
                'long_names' => '{"de": "Republik Botsuana", "en": "Republic Of Botswana"}',
                'nationality_names' => '{"de": "botswanisch"}',
                'nato_country_code_2' => 'BC',
                'nato_country_code_3' => 'BWA',
                'short_names' => '{"de": "Botsuana", "en": "Botswana"}',
                'telephone_country_code' => '+267',
                'telephone_country_code_extended' => '+267',
                'tld' => '.bw',
                'vehicle_registration_code' => 'BW',
            ],
            [
                'id' => 37,
                'active' => 1,
                'area' => 207600,
                'capital_names' => '{"de": "Minsk"}',
                'comments' => null,
                'fips10' => 'BO',
                'ioc' => 'BLR',
                'iso3166_alpha_2' => 'BY',
                'iso3166_alpha_3' => 'BLR',
                'iso3166_numeric' => '112',
                'local_name' => 'Belarus',
                'locales' => null,
                'long_names' => '{"de": "Republik Belarus", "en": "Republic Of Belarus"}',
                'nationality_names' => '{"de": "weißrussisch"}',
                'nato_country_code_2' => 'BO',
                'nato_country_code_3' => 'BLR',
                'short_names' => '{"de": "Belarus", "en": "Belarus"}',
                'telephone_country_code' => '+375',
                'telephone_country_code_extended' => '+375',
                'tld' => '.by',
                'vehicle_registration_code' => 'BY',
            ],
            [
                'id' => 38,
                'active' => 0,
                'area' => 22966,
                'capital_names' => '{"de": "Belmopan"}',
                'comments' => null,
                'fips10' => 'BH',
                'ioc' => 'BIZ',
                'iso3166_alpha_2' => 'BZ',
                'iso3166_alpha_3' => 'BLZ',
                'iso3166_numeric' => '084',
                'local_name' => 'Belize',
                'locales' => null,
                'long_names' => '{"de": "Belize", "en": "Belize"}',
                'nationality_names' => '{"de": "belizisch"}',
                'nato_country_code_2' => 'BH',
                'nato_country_code_3' => 'BLZ',
                'short_names' => '{"de": "Belize", "en": "Belize"}',
                'telephone_country_code' => '+501',
                'telephone_country_code_extended' => '+501',
                'tld' => '.bz',
                'vehicle_registration_code' => 'BZ',
            ],
            [
                'id' => 39,
                'active' => 0,
                'area' => 9984670,
                'capital_names' => '{"de": "Ottawa"}',
                'comments' => null,
                'fips10' => 'CA',
                'ioc' => 'CAN',
                'iso3166_alpha_2' => 'CA',
                'iso3166_alpha_3' => 'CAN',
                'iso3166_numeric' => '124',
                'local_name' => 'Canada',
                'locales' => null,
                'long_names' => '{"de": "Kanada", "en": "Canada"}',
                'nationality_names' => '{"de": "kanadisch"}',
                'nato_country_code_2' => 'CA',
                'nato_country_code_3' => 'CAN',
                'short_names' => '{"de": "Kanada", "en": "Canada"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1',
                'tld' => '.ca',
                'vehicle_registration_code' => 'CDN',
            ],
            [
                'id' => 40,
                'active' => 0,
                'area' => 14200,
                'capital_names' => '{"de": "West Island", "en": "West Island"}',
                'comments' => null,
                'fips10' => 'CK',
                'ioc' => null,
                'iso3166_alpha_2' => 'CC',
                'iso3166_alpha_3' => 'CCK',
                'iso3166_numeric' => null,
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Kokosinseln", "en": "Keeling Islands"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'CK',
                'nato_country_code_3' => 'CCK',
                'short_names' => '{"de": "Kokosinseln", "en": "Keeling Islands"}',
                'telephone_country_code' => '+61',
                'telephone_country_code_extended' => '+61',
                'tld' => '.cc',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 41,
                'active' => 0,
                'area' => 2344858,
                'capital_names' => '{"de": "Kinshasa"}',
                'comments' => null,
                'fips10' => 'CG',
                'ioc' => 'COD',
                'iso3166_alpha_2' => 'CD',
                'iso3166_alpha_3' => 'COD',
                'iso3166_numeric' => '180',
                'local_name' => 'République Démocratique du Congo',
                'locales' => null,
                'long_names' => '{"de": "Demokratische Republik Kongo", "en": "Democratic Republic Of The Congo"}',
                'nationality_names' => '{"de": "kongolesisch"}',
                'nato_country_code_2' => 'CG',
                'nato_country_code_3' => 'COD',
                'short_names' => '{"de": "Demokratische Republik Kongo", "en": "Democratic Republic Of The Congo"}',
                'telephone_country_code' => '+243',
                'telephone_country_code_extended' => '+243',
                'tld' => '.cd',
                'vehicle_registration_code' => 'CGO',
            ],
            [
                'id' => 42,
                'active' => 0,
                'area' => 622984,
                'capital_names' => '{"de": "Bangui"}',
                'comments' => null,
                'fips10' => 'CT',
                'ioc' => 'CAF',
                'iso3166_alpha_2' => 'CF',
                'iso3166_alpha_3' => 'CAF',
                'iso3166_numeric' => '140',
                'local_name' => 'République Centrafricaine',
                'locales' => null,
                'long_names' => '{"de": "Zentralafrikanische Republik", "en": "Central African Republic"}',
                'nationality_names' => '{"de": "zentralafrikanisch"}',
                'nato_country_code_2' => 'CT',
                'nato_country_code_3' => 'CAF',
                'short_names' => '{"de": "Zentralafrikanische Republik", "en": "Central African Republic"}',
                'telephone_country_code' => '+236',
                'telephone_country_code_extended' => '+236',
                'tld' => '.cf',
                'vehicle_registration_code' => 'RCA',
            ],
            [
                'id' => 43,
                'active' => 0,
                'area' => 342000,
                'capital_names' => '{"de": "Brazzaville"}',
                'comments' => null,
                'fips10' => 'CF',
                'ioc' => 'CGO',
                'iso3166_alpha_2' => 'CG',
                'iso3166_alpha_3' => 'COG',
                'iso3166_numeric' => '178',
                'local_name' => 'République du Congo',
                'locales' => null,
                'long_names' => '{"de": "Republik Kongo", "en": "Republic Of The Congo"}',
                'nationality_names' => '{"de": "kongolesisch"}',
                'nato_country_code_2' => 'CF',
                'nato_country_code_3' => 'COG',
                'short_names' => '{"de": "Republik Kongo", "en": "Republic Of The Congo"}',
                'telephone_country_code' => '+242',
                'telephone_country_code_extended' => '+242',
                'tld' => '.cg',
                'vehicle_registration_code' => 'RCB',
            ],
            [
                'id' => 44,
                'active' => 1,
                'area' => 41277,
                'capital_names' => '{"de": "Bern"}',
                'comments' => null,
                'fips10' => 'SZ',
                'ioc' => 'SUI',
                'iso3166_alpha_2' => 'CH',
                'iso3166_alpha_3' => 'CHE',
                'iso3166_numeric' => '756',
                'local_name' => 'Schweiz (Deutsch), Suisse (Französisch), Svizzera (Italienisch), Svizra (Bündnerromanisch)',
                'locales' => '["de_CH", "fr_CH", "it_CH"]',
                'long_names' => '{"de": "Schweizerische Eidgenossenschaft", "en": "Swiss Confederation"}',
                'nationality_names' => '{"de": "schweizerisch"}',
                'nato_country_code_2' => 'SZ',
                'nato_country_code_3' => 'CHE',
                'short_names' => '{"de": "Schweiz", "en": "Swiss"}',
                'telephone_country_code' => '+41',
                'telephone_country_code_extended' => '+41',
                'tld' => '.ch',
                'vehicle_registration_code' => 'CH',
            ],
            [
                'id' => 45,
                'active' => 0,
                'area' => 322463,
                'capital_names' => '{"de": "Yamoussoukro"}',
                'comments' => null,
                'fips10' => 'IV',
                'ioc' => 'CIV',
                'iso3166_alpha_2' => 'CI',
                'iso3166_alpha_3' => 'CIV',
                'iso3166_numeric' => '384',
                'local_name' => 'Côte d’Ivoire',
                'locales' => null,
                'long_names' => '{"de": "Republik Côte d’Ivoire", "en": "Republic Of Côte D\'ivoire"}',
                'nationality_names' => '{"de": "ivorisch"}',
                'nato_country_code_2' => 'IV',
                'nato_country_code_3' => 'CIV',
                'short_names' => '{"de": "Elfenbeinküste", "en": "Ivory Coast"}',
                'telephone_country_code' => '+225',
                'telephone_country_code_extended' => '+225',
                'tld' => '.ci',
                'vehicle_registration_code' => 'CI',
            ],
            [
                'id' => 46,
                'active' => 0,
                'area' => 236,
                'capital_names' => '{"de": "Avarua"}',
                'comments' => null,
                'fips10' => 'CW',
                'ioc' => 'COK',
                'iso3166_alpha_2' => 'CK',
                'iso3166_alpha_3' => 'COK',
                'iso3166_numeric' => '184',
                'local_name' => 'Cook Islands',
                'locales' => null,
                'long_names' => '{"de": "Cookinseln", "en": "Cook Islands"}',
                'nationality_names' => '{"de": ""}',
                'nato_country_code_2' => 'CW',
                'nato_country_code_3' => 'COK',
                'short_names' => '{"de": "Cookinseln", "en": "Cook Islands"}',
                'telephone_country_code' => '+682',
                'telephone_country_code_extended' => '+682',
                'tld' => '.ck',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 47,
                'active' => 0,
                'area' => 756102,
                'capital_names' => '{"de": "Santiago de Chile"}',
                'comments' => null,
                'fips10' => 'CI',
                'ioc' => 'CHI',
                'iso3166_alpha_2' => 'CL',
                'iso3166_alpha_3' => 'CHL',
                'iso3166_numeric' => '152',
                'local_name' => 'Chile',
                'locales' => null,
                'long_names' => '{"de": "Republik Chile", "en": "Republic Of Chile"}',
                'nationality_names' => '{"de": "chilenisch"}',
                'nato_country_code_2' => 'CI',
                'nato_country_code_3' => 'CHL',
                'short_names' => '{"de": "Chile", "en": "Chile"}',
                'telephone_country_code' => '+56',
                'telephone_country_code_extended' => '+56',
                'tld' => '.cl',
                'vehicle_registration_code' => 'RCH',
            ],
            [
                'id' => 48,
                'active' => 0,
                'area' => 475440,
                'capital_names' => '{"de": "Yaoundé"}',
                'comments' => null,
                'fips10' => 'CM',
                'ioc' => 'CMR',
                'iso3166_alpha_2' => 'CM',
                'iso3166_alpha_3' => 'CMR',
                'iso3166_numeric' => '120',
                'local_name' => 'Cameroun (Französisch), Cameroon (Englisch)',
                'locales' => null,
                'long_names' => '{"de": "Republik Kamerun", "en": "Republic Of Cameroon"}',
                'nationality_names' => '{"de": "kamerunisch"}',
                'nato_country_code_2' => 'CM',
                'nato_country_code_3' => 'CMR',
                'short_names' => '{"de": "Kamerun", "en": "Cameroon"}',
                'telephone_country_code' => '+237',
                'telephone_country_code_extended' => '+237',
                'tld' => '.cm',
                'vehicle_registration_code' => 'RUC',
            ],
            [
                'id' => 49,
                'active' => 0,
                'area' => 9596961,
                'capital_names' => '{"de": "Peking"}',
                'comments' => null,
                'fips10' => 'CH',
                'ioc' => 'CHN',
                'iso3166_alpha_2' => 'CN',
                'iso3166_alpha_3' => 'CHN',
                'iso3166_numeric' => '156',
                'local_name' => '中华人民共和国 Zhonghua Renmin Gongheguo',
                'locales' => null,
                'long_names' => '{"de": "Volksrepublik China", "en": "People\'s Republic Of China"}',
                'nationality_names' => '{"de": "chinesich"}',
                'nato_country_code_2' => 'CH',
                'nato_country_code_3' => 'CHN',
                'short_names' => '{"de": "China", "en": "China"}',
                'telephone_country_code' => '+86',
                'telephone_country_code_extended' => '+86',
                'tld' => '.cn',
                'vehicle_registration_code' => 'RC',
            ],
            [
                'id' => 50,
                'active' => 0,
                'area' => 1138910,
                'capital_names' => '{"de": "Bogotá"}',
                'comments' => null,
                'fips10' => 'CO',
                'ioc' => 'COL',
                'iso3166_alpha_2' => 'CO',
                'iso3166_alpha_3' => 'COL',
                'iso3166_numeric' => '170',
                'local_name' => 'Colombia',
                'locales' => null,
                'long_names' => '{"de": "Republik Kolumbien", "en": "Republic Of Colombia"}',
                'nationality_names' => '{"de": "kolumbianisch"}',
                'nato_country_code_2' => 'CO',
                'nato_country_code_3' => 'COL',
                'short_names' => '{"de": "Kolumbien", "en": "Colombia"}',
                'telephone_country_code' => '+57',
                'telephone_country_code_extended' => '+57',
                'tld' => '.co',
                'vehicle_registration_code' => 'CO',
            ],
            [
                'id' => 51,
                'active' => 0,
                'area' => 51100,
                'capital_names' => '{"de": "San José"}',
                'comments' => null,
                'fips10' => 'CS',
                'ioc' => 'CRC',
                'iso3166_alpha_2' => 'CR',
                'iso3166_alpha_3' => 'CRI',
                'iso3166_numeric' => '188',
                'local_name' => 'Costa Rica',
                'locales' => null,
                'long_names' => '{"de": "Republik Costa Rica", "en": "Republic Of Costa Rica"}',
                'nationality_names' => '{"de": "costa-ricanisch"}',
                'nato_country_code_2' => 'CS',
                'nato_country_code_3' => 'CRI',
                'short_names' => '{"de": "Costa Rica", "en": "Costa Rica"}',
                'telephone_country_code' => '+506',
                'telephone_country_code_extended' => '+506',
                'tld' => '.cr',
                'vehicle_registration_code' => 'CR',
            ],
            [
                'id' => 52,
                'active' => 0,
                'area' => 110860,
                'capital_names' => '{"de": "Havanna"}',
                'comments' => null,
                'fips10' => 'CU',
                'ioc' => 'CUB',
                'iso3166_alpha_2' => 'CU',
                'iso3166_alpha_3' => 'CUB',
                'iso3166_numeric' => '192',
                'local_name' => 'Cuba',
                'locales' => null,
                'long_names' => '{"de": "Republik Kuba", "en": "Republic Of Cuba"}',
                'nationality_names' => '{"de": "kubanisch"}',
                'nato_country_code_2' => 'CU',
                'nato_country_code_3' => 'CUB',
                'short_names' => '{"de": "Kuba", "en": "Cuba"}',
                'telephone_country_code' => '+53',
                'telephone_country_code_extended' => '+53',
                'tld' => '.cu',
                'vehicle_registration_code' => 'C',
            ],
            [
                'id' => 53,
                'active' => 0,
                'area' => 444000,
                'capital_names' => '{"de": "Willemstad", "en": "Willemstad"}',
                'comments' => null,
                'fips10' => 'UC',
                'ioc' => 'IOA',
                'iso3166_alpha_2' => 'CW',
                'iso3166_alpha_3' => 'CUW',
                'iso3166_numeric' => '531',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Curaçao", "en": "Curaçao"}',
                'nationality_names' => null,
                'nato_country_code_2' => null,
                'nato_country_code_3' => null,
                'short_names' => '{"de": "Curaçao", "en": "Curaçao"}',
                'telephone_country_code' => '+599',
                'telephone_country_code_extended' => '+599',
                'tld' => '.cw',
                'vehicle_registration_code' => 'NA',
            ],
            [
                'id' => 54,
                'active' => 0,
                'area' => 135000,
                'capital_names' => '{"de": "Flying Fish Cove", "en": "Flying Fish Cove"}',
                'comments' => null,
                'fips10' => 'KT',
                'ioc' => null,
                'iso3166_alpha_2' => 'CX',
                'iso3166_alpha_3' => 'CXR',
                'iso3166_numeric' => '162',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Weihnachtsinsel", "en": "Territory of Christmas Island"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'KT',
                'nato_country_code_3' => 'CXR',
                'short_names' => '{"de": "Weihnachtsinsel", "en": "Christmas Island"}',
                'telephone_country_code' => '+61',
                'telephone_country_code_extended' => '+61',
                'tld' => '.cx',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 55,
                'active' => 0,
                'area' => 4033,
                'capital_names' => '{"de": "Praia"}',
                'comments' => null,
                'fips10' => 'CV',
                'ioc' => 'CPV',
                'iso3166_alpha_2' => 'CV',
                'iso3166_alpha_3' => 'CPV',
                'iso3166_numeric' => '132',
                'local_name' => 'Cabo Verde',
                'locales' => null,
                'long_names' => '{"de": "Republik Cabo Verde", "en": "Republic Of Cape Verde"}',
                'nationality_names' => '{"de": "kapverdisch"}',
                'nato_country_code_2' => 'CV',
                'nato_country_code_3' => 'CPV',
                'short_names' => '{"de": "Kap Verde", "en": "Cape Verde"}',
                'telephone_country_code' => '+238',
                'telephone_country_code_extended' => '+238',
                'tld' => '.cv',
                'vehicle_registration_code' => 'CV',
            ],
            [
                'id' => 56,
                'active' => 1,
                'area' => 9251,
                'capital_names' => '{"de": "Nikosia"}',
                'comments' => null,
                'fips10' => 'CY',
                'ioc' => 'CYP',
                'iso3166_alpha_2' => 'CY',
                'iso3166_alpha_3' => 'CYP',
                'iso3166_numeric' => '196',
                'local_name' => 'Kýpros (Griechisch), Kıbrıs (Türkisch)',
                'locales' => null,
                'long_names' => '{"de": "Republik Zypern", "en": "Republic Of Cyprus"}',
                'nationality_names' => '{"de": "zypriotisch"}',
                'nato_country_code_2' => 'CY',
                'nato_country_code_3' => 'CYP',
                'short_names' => '{"de": "Republik Zypern", "en": "Republic Of Cyprus"}',
                'telephone_country_code' => '+357',
                'telephone_country_code_extended' => '+357',
                'tld' => '.cy',
                'vehicle_registration_code' => 'CY',
            ],
            [
                'id' => 57,
                'active' => 1,
                'area' => 78867,
                'capital_names' => '{"de": "Prag"}',
                'comments' => null,
                'fips10' => 'EZ',
                'ioc' => 'CZE',
                'iso3166_alpha_2' => 'CZ',
                'iso3166_alpha_3' => 'CZE',
                'iso3166_numeric' => '203',
                'local_name' => 'Česká republika',
                'locales' => null,
                'long_names' => '{"de": "Tschechische Republik", "en": "Czech Republic"}',
                'nationality_names' => '{"de": "tschechisch"}',
                'nato_country_code_2' => 'CZ',
                'nato_country_code_3' => 'CZE',
                'short_names' => '{"de": "Tschechien", "en": "Czech Republic"}',
                'telephone_country_code' => '+420',
                'telephone_country_code_extended' => '+420',
                'tld' => '.cz',
                'vehicle_registration_code' => 'CZ',
            ],
            [
                'id' => 58,
                'active' => 1,
                'area' => 357121,
                'capital_names' => '{"de": "Berlin"}',
                'comments' => null,
                'fips10' => 'GM',
                'ioc' => 'GER',
                'iso3166_alpha_2' => 'DE',
                'iso3166_alpha_3' => 'DEU',
                'iso3166_numeric' => '276',
                'local_name' => 'Deutschland',
                'locales' => '["de_DE"]',
                'long_names' => '{"de": "Bundesrepublik Deutschland", "en": "Federal Republic Of Germany"}',
                'nationality_names' => '{"de": "deutsch"}',
                'nato_country_code_2' => 'GE',
                'nato_country_code_3' => 'DEU',
                'short_names' => '{"de": "Deutschland", "en": "Germany"}',
                'telephone_country_code' => '+49',
                'telephone_country_code_extended' => '+49',
                'tld' => '.de',
                'vehicle_registration_code' => 'D',
            ],
            [
                'id' => 59,
                'active' => 0,
                'area' => 23200,
                'capital_names' => '{"de": "Dschibuti-Stadt"}',
                'comments' => null,
                'fips10' => 'DJ',
                'ioc' => 'DJI',
                'iso3166_alpha_2' => 'DJ',
                'iso3166_alpha_3' => 'DJI',
                'iso3166_numeric' => '262',
                'local_name' => 'Djibouti',
                'locales' => null,
                'long_names' => '{"de": "Republik Dschibuti", "en": "Republic Of Djibouti"}',
                'nationality_names' => '{"de": "dschibutisch"}',
                'nato_country_code_2' => 'DJ',
                'nato_country_code_3' => 'DJI',
                'short_names' => '{"de": "Dschibuti", "en": "Djibouti"}',
                'telephone_country_code' => '+253',
                'telephone_country_code_extended' => '+253',
                'tld' => '.dj',
                'vehicle_registration_code' => 'DJI',
            ],
            [
                'id' => 60,
                'active' => 1,
                'area' => 43094,
                'capital_names' => '{"de": "Kopenhagen"}',
                'comments' => null,
                'fips10' => 'DA',
                'ioc' => 'DEN',
                'iso3166_alpha_2' => 'DK',
                'iso3166_alpha_3' => 'DNK',
                'iso3166_numeric' => '208',
                'local_name' => 'Danmark',
                'locales' => null,
                'long_names' => '{"de": "Königreich Dänemark", "en": "Kingdom Of Denmark"}',
                'nationality_names' => '{"de": "dänisch"}',
                'nato_country_code_2' => 'DA',
                'nato_country_code_3' => 'DNK',
                'short_names' => '{"de": "Dänemark", "en": "Denmark"}',
                'telephone_country_code' => '+45',
                'telephone_country_code_extended' => '+45',
                'tld' => '.dk',
                'vehicle_registration_code' => 'DK',
            ],
            [
                'id' => 61,
                'active' => 0,
                'area' => 751,
                'capital_names' => '{"de": "Roseau"}',
                'comments' => null,
                'fips10' => 'DO',
                'ioc' => 'DMA',
                'iso3166_alpha_2' => 'DM',
                'iso3166_alpha_3' => 'DMA',
                'iso3166_numeric' => '212',
                'local_name' => 'Dominica',
                'locales' => null,
                'long_names' => '{"de": "Commonwealth Dominica", "en": "Commonwealth Of Dominica"}',
                'nationality_names' => '{"de": "dominicanisch"}',
                'nato_country_code_2' => 'DO',
                'nato_country_code_3' => 'DMA',
                'short_names' => '{"de": "Dominica", "en": "Dominica"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1767',
                'tld' => '.dm',
                'vehicle_registration_code' => 'WD',
            ],
            [
                'id' => 62,
                'active' => 0,
                'area' => 48670,
                'capital_names' => '{"de": "Santo Domingo"}',
                'comments' => null,
                'fips10' => 'DR',
                'ioc' => 'DOM',
                'iso3166_alpha_2' => 'DO',
                'iso3166_alpha_3' => 'DOM',
                'iso3166_numeric' => '214',
                'local_name' => 'República Dominicana',
                'locales' => null,
                'long_names' => '{"de": "Dominikanische Republik", "en": "Dominican Republic"}',
                'nationality_names' => '{"de": "dominikanisch"}',
                'nato_country_code_2' => 'DR',
                'nato_country_code_3' => 'DOM',
                'short_names' => '{"de": "Dominikanische Republik", "en": "Dominican Republic"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1809;1829;1849',
                'tld' => '.do',
                'vehicle_registration_code' => 'DOM',
            ],
            [
                'id' => 63,
                'active' => 0,
                'area' => 2381741,
                'capital_names' => '{"de": "Algier"}',
                'comments' => null,
                'fips10' => 'AG',
                'ioc' => 'ALG',
                'iso3166_alpha_2' => 'DZ',
                'iso3166_alpha_3' => 'DZA',
                'iso3166_numeric' => '012',
                'local_name' => 'al-Dschazā\'ir',
                'locales' => null,
                'long_names' => '{"de": "Demokratische Volksrepublik Algerien", "en": "People\'s Democratic Republic Of Algeria"}',
                'nationality_names' => '{"de": "algerisch"}',
                'nato_country_code_2' => 'AG',
                'nato_country_code_3' => 'DZA',
                'short_names' => '{"de": "Algerien", "en": "Algeria"}',
                'telephone_country_code' => '+213',
                'telephone_country_code_extended' => '+213',
                'tld' => '.dz',
                'vehicle_registration_code' => 'DZ',
            ],
            [
                'id' => 64,
                'active' => 0,
                'area' => 283561,
                'capital_names' => '{"de": "Quito"}',
                'comments' => null,
                'fips10' => 'EC',
                'ioc' => 'ECU',
                'iso3166_alpha_2' => 'EC',
                'iso3166_alpha_3' => 'ECU',
                'iso3166_numeric' => '218',
                'local_name' => 'Ecuador',
                'locales' => null,
                'long_names' => '{"de": "Republik Ecuador", "en": "Republic Of Ecuador"}',
                'nationality_names' => '{"de": "ecuadorianisch"}',
                'nato_country_code_2' => 'EC',
                'nato_country_code_3' => 'ECU',
                'short_names' => '{"de": "Ecuador", "en": "Ecuador"}',
                'telephone_country_code' => '+593',
                'telephone_country_code_extended' => '+593',
                'tld' => '.ec',
                'vehicle_registration_code' => 'EQ',
            ],
            [
                'id' => 65,
                'active' => 1,
                'area' => 45228,
                'capital_names' => '{"de": "Tallinn"}',
                'comments' => null,
                'fips10' => 'EN',
                'ioc' => 'EST',
                'iso3166_alpha_2' => 'EE',
                'iso3166_alpha_3' => 'EST',
                'iso3166_numeric' => '233',
                'local_name' => 'Eesti',
                'locales' => null,
                'long_names' => '{"de": "Republik Estland", "en": "Republic Of Estonia"}',
                'nationality_names' => '{"de": "estnisch"}',
                'nato_country_code_2' => 'EN',
                'nato_country_code_3' => 'EST',
                'short_names' => '{"de": "Estland", "en": "Estonia"}',
                'telephone_country_code' => '+372',
                'telephone_country_code_extended' => '+372',
                'tld' => '.ee',
                'vehicle_registration_code' => 'EST',
            ],
            [
                'id' => 66,
                'active' => 0,
                'area' => 1001450,
                'capital_names' => '{"de": "Kairo"}',
                'comments' => null,
                'fips10' => 'EG',
                'ioc' => 'EGY',
                'iso3166_alpha_2' => 'EG',
                'iso3166_alpha_3' => 'EGY',
                'iso3166_numeric' => '818',
                'local_name' => 'Misr',
                'locales' => null,
                'long_names' => '{"de": "Arabische Republik Ägypten", "en": "Arab Republic Of Egypt"}',
                'nationality_names' => '{"de": "ägyptisch"}',
                'nato_country_code_2' => 'EG',
                'nato_country_code_3' => 'EGY',
                'short_names' => '{"de": "Ägypten", "en": "Egypt"}',
                'telephone_country_code' => '+20',
                'telephone_country_code_extended' => '+20',
                'tld' => '.eg',
                'vehicle_registration_code' => 'EG',
            ],
            [
                'id' => 67,
                'active' => 1,
                'area' => 266000,
                'capital_names' => '{"de": "El Aaiún"}',
                'comments' => null,
                'fips10' => 'WI',
                'ioc' => null,
                'iso3166_alpha_2' => 'EH',
                'iso3166_alpha_3' => 'ESH',
                'iso3166_numeric' => '732',
                'local_name' => 'Sahara Occidental',
                'locales' => null,
                'long_names' => '{"de": "Demokratische Arabische Republik Sahara", "en": "Sahrawi Arab Democratic Republic"}',
                'nationality_names' => '{"de": "westsaharisch"}',
                'nato_country_code_2' => 'WI',
                'nato_country_code_3' => 'ESH',
                'short_names' => '{"de": "Arabische Republik Sahara", "en": "Sahrawi Republic"}',
                'telephone_country_code' => '+',
                'telephone_country_code_extended' => '+212',
                'tld' => '.eh',
                'vehicle_registration_code' => 'WSA',
            ],
            [
                'id' => 68,
                'active' => 0,
                'area' => 117600,
                'capital_names' => '{"de": "Asmara"}',
                'comments' => null,
                'fips10' => 'ER',
                'ioc' => 'ERI',
                'iso3166_alpha_2' => 'ER',
                'iso3166_alpha_3' => 'ERI',
                'iso3166_numeric' => '232',
                'local_name' => 'Ertra',
                'locales' => null,
                'long_names' => '{"de": "Staat Eritrea", "en": "State Of Eritrea"}',
                'nationality_names' => '{"de": "eritreisch"}',
                'nato_country_code_2' => 'ER',
                'nato_country_code_3' => 'ERI',
                'short_names' => '{"de": "Eritrea", "en": "Eritrea"}',
                'telephone_country_code' => '+291',
                'telephone_country_code_extended' => '+291',
                'tld' => '.er',
                'vehicle_registration_code' => 'ER',
            ],
            [
                'id' => 69,
                'active' => 1,
                'area' => 505370,
                'capital_names' => '{"de": "Madrid"}',
                'comments' => null,
                'fips10' => 'SP',
                'ioc' => 'ESP',
                'iso3166_alpha_2' => 'ES',
                'iso3166_alpha_3' => 'ESP',
                'iso3166_numeric' => '724',
                'local_name' => 'España',
                'locales' => null,
                'long_names' => '{"de": "Königreich Spanien", "en": "Kingdom Of Spain"}',
                'nationality_names' => '{"de": "spanisch"}',
                'nato_country_code_2' => 'SP',
                'nato_country_code_3' => 'ESP',
                'short_names' => '{"de": "Spanien", "en": "Spain"}',
                'telephone_country_code' => '+34',
                'telephone_country_code_extended' => '+34',
                'tld' => '.es',
                'vehicle_registration_code' => 'E',
            ],
            [
                'id' => 70,
                'active' => 0,
                'area' => 1104300,
                'capital_names' => '{"de": "Addis Abeba"}',
                'comments' => null,
                'fips10' => 'ET',
                'ioc' => 'ETH',
                'iso3166_alpha_2' => 'ET',
                'iso3166_alpha_3' => 'ETH',
                'iso3166_numeric' => '231',
                'local_name' => 'Ityop\'iya',
                'locales' => null,
                'long_names' => '{"de": "Demokratische Bundesrepublik Äthiopien", "en": "Federal Democratic Republic Of Ethiopia"}',
                'nationality_names' => '{"de": "äthiopisch"}',
                'nato_country_code_2' => 'ET',
                'nato_country_code_3' => 'ETH',
                'short_names' => '{"de": "Äthiopien", "en": "Ethiopia"}',
                'telephone_country_code' => '+251',
                'telephone_country_code_extended' => '+251',
                'tld' => '.et',
                'vehicle_registration_code' => 'ETH',
            ],
            [
                'id' => 71,
                'active' => 1,
                'area' => 338145,
                'capital_names' => '{"de": "Helsinki"}',
                'comments' => null,
                'fips10' => 'FI',
                'ioc' => 'FIN',
                'iso3166_alpha_2' => 'FI',
                'iso3166_alpha_3' => 'FIN',
                'iso3166_numeric' => '246',
                'local_name' => 'Suomi (Finnisch), Finland (Schwedisch)',
                'locales' => null,
                'long_names' => '{"de": "Republik Finnland", "en": "Republic Of Finland"}',
                'nationality_names' => '{"de": "finnisch"}',
                'nato_country_code_2' => 'FI',
                'nato_country_code_3' => 'FIN',
                'short_names' => '{"de": "Finnland", "en": "Finland"}',
                'telephone_country_code' => '+358',
                'telephone_country_code_extended' => '+358',
                'tld' => '.fi',
                'vehicle_registration_code' => 'FIN',
            ],
            [
                'id' => 72,
                'active' => 0,
                'area' => 18274,
                'capital_names' => '{"de": "Suva"}',
                'comments' => null,
                'fips10' => 'FJ',
                'ioc' => 'FIJ',
                'iso3166_alpha_2' => 'FJ',
                'iso3166_alpha_3' => 'FJI',
                'iso3166_numeric' => '242',
                'local_name' => 'Fiji',
                'locales' => null,
                'long_names' => '{"de": "Republik Fidschi", "en": "Republic Of The Fiji Islands"}',
                'nationality_names' => '{"de": "fidschianisch"}',
                'nato_country_code_2' => 'FJ',
                'nato_country_code_3' => 'FJI',
                'short_names' => '{"de": "Fidschi", "en": "Fiji Islands"}',
                'telephone_country_code' => '+679',
                'telephone_country_code_extended' => '+679',
                'tld' => '.fj',
                'vehicle_registration_code' => 'FJI',
            ],
            [
                'id' => 73,
                'active' => 0,
                'area' => 12173000,
                'capital_names' => '{"de": "Stanley", "en": "Stanley"}',
                'comments' => null,
                'fips10' => 'FK',
                'ioc' => null,
                'iso3166_alpha_2' => 'FK',
                'iso3166_alpha_3' => 'FLK',
                'iso3166_numeric' => '238',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Falklandinseln", "en": "Falkland Islands"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'FK',
                'nato_country_code_3' => 'FLK',
                'short_names' => '{"de": "Falklandinseln", "en": "Falkland Islands"}',
                'telephone_country_code' => '+500',
                'telephone_country_code_extended' => '+500',
                'tld' => '.fk',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 74,
                'active' => 0,
                'area' => 1395740,
                'capital_names' => '{"de": "Tórshavn", "en": "Tórshavn"}',
                'comments' => null,
                'fips10' => 'FO',
                'ioc' => null,
                'iso3166_alpha_2' => 'FO',
                'iso3166_alpha_3' => 'FRO',
                'iso3166_numeric' => '234',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Färöer-Inseln", "en": "Faroe Islands"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'FO',
                'nato_country_code_3' => 'FRO',
                'short_names' => '{"de": "Färöer", "en": "Faroe"}',
                'telephone_country_code' => '+298',
                'telephone_country_code_extended' => '+298',
                'tld' => '.fo',
                'vehicle_registration_code' => 'FO',
            ],
            [
                'id' => 75,
                'active' => 0,
                'area' => 702,
                'capital_names' => '{"de": "Palikir"}',
                'comments' => null,
                'fips10' => 'FM',
                'ioc' => 'FSM',
                'iso3166_alpha_2' => 'FM',
                'iso3166_alpha_3' => 'FSM',
                'iso3166_numeric' => '583',
                'local_name' => 'Micronesia',
                'locales' => null,
                'long_names' => '{"de": "Föderierte Staaten von Mikronesien", "en": "Federated States Of Micronesia"}',
                'nationality_names' => '{"de": "mikronesisch"}',
                'nato_country_code_2' => 'FM',
                'nato_country_code_3' => 'FSM',
                'short_names' => '{"de": "Mikronesien", "en": "Micronesia"}',
                'telephone_country_code' => '+691',
                'telephone_country_code_extended' => '+691',
                'tld' => '.fm',
                'vehicle_registration_code' => 'FSM',
            ],
            [
                'id' => 76,
                'active' => 1,
                'area' => 551500,
                'capital_names' => '{"de": "Paris"}',
                'comments' => null,
                'fips10' => 'FR',
                'ioc' => 'FRA',
                'iso3166_alpha_2' => 'FR',
                'iso3166_alpha_3' => 'FRA',
                'iso3166_numeric' => '250',
                'local_name' => 'France',
                'locales' => null,
                'long_names' => '{"de": "Französische Republik", "en": "French Republic"}',
                'nationality_names' => '{"de": "französisch"}',
                'nato_country_code_2' => 'FR',
                'nato_country_code_3' => 'FRA',
                'short_names' => '{"de": "Frankreich", "en": "France"}',
                'telephone_country_code' => '+33',
                'telephone_country_code_extended' => '+33',
                'tld' => '.fr',
                'vehicle_registration_code' => 'F',
            ],
            [
                'id' => 77,
                'active' => 0,
                'area' => 267667,
                'capital_names' => '{"de": "Libreville"}',
                'comments' => null,
                'fips10' => 'GB',
                'ioc' => 'GAB',
                'iso3166_alpha_2' => 'GA',
                'iso3166_alpha_3' => 'GAB',
                'iso3166_numeric' => '266',
                'local_name' => 'Gabon',
                'locales' => null,
                'long_names' => '{"de": "Gabunische Republik", "en": "Gabonese Republic"}',
                'nationality_names' => '{"de": "gabunisch"}',
                'nato_country_code_2' => 'GB',
                'nato_country_code_3' => 'GAB',
                'short_names' => '{"de": "Gabun", "en": "Gabon"}',
                'telephone_country_code' => '+241',
                'telephone_country_code_extended' => '+241',
                'tld' => '.ga',
                'vehicle_registration_code' => 'G',
            ],
            [
                'id' => 78,
                'active' => 1,
                'area' => 243610,
                'capital_names' => '{"de": "London"}',
                'comments' => null,
                'fips10' => 'UK',
                'ioc' => 'GBR',
                'iso3166_alpha_2' => 'GB',
                'iso3166_alpha_3' => 'GBR',
                'iso3166_numeric' => '826',
                'local_name' => 'United Kingdom',
                'locales' => '["en_GB"]',
                'long_names' => '{"de": "Vereinigtes Königreich Großbritannien und Nordirland", "en": "United Kingdom Of Great Britain And Northern Ireland"}',
                'nationality_names' => '{"de": "britisch"}',
                'nato_country_code_2' => 'UK',
                'nato_country_code_3' => 'GBR',
                'short_names' => '{"de": "Großbritannien und Nordirland", "en": "Great Britain And Northern Ireland"}',
                'telephone_country_code' => '+44',
                'telephone_country_code_extended' => '+44',
                'tld' => '.uk',
                'vehicle_registration_code' => 'GB',
            ],
            [
                'id' => 79,
                'active' => 0,
                'area' => 344,
                'capital_names' => '{"de": "St. George’s"}',
                'comments' => null,
                'fips10' => 'GJ',
                'ioc' => 'GRN',
                'iso3166_alpha_2' => 'GD',
                'iso3166_alpha_3' => 'GRD',
                'iso3166_numeric' => '308',
                'local_name' => 'Grenada',
                'locales' => null,
                'long_names' => '{"de": "Grenada", "en": "Grenada"}',
                'nationality_names' => '{"de": "grenadisch"}',
                'nato_country_code_2' => 'GJ',
                'nato_country_code_3' => 'GRD',
                'short_names' => '{"de": "Grenada", "en": "Grenada"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1473',
                'tld' => '.gd',
                'vehicle_registration_code' => 'WG',
            ],
            [
                'id' => 80,
                'active' => 0,
                'area' => 69700,
                'capital_names' => '{"de": "Tiflis"}',
                'comments' => null,
                'fips10' => 'GG',
                'ioc' => 'GEO',
                'iso3166_alpha_2' => 'GE',
                'iso3166_alpha_3' => 'GEO',
                'iso3166_numeric' => '268',
                'local_name' => 'Sak\'art\'velo',
                'locales' => null,
                'long_names' => '{"de": "Georgien", "en": "Georgia"}',
                'nationality_names' => '{"de": "georgisch"}',
                'nato_country_code_2' => 'GG',
                'nato_country_code_3' => 'GEO',
                'short_names' => '{"de": "Georgien", "en": "Georgia"}',
                'telephone_country_code' => '+995',
                'telephone_country_code_extended' => '+995',
                'tld' => '.ge',
                'vehicle_registration_code' => 'GEO',
            ],
            [
                'id' => 81,
                'active' => 0,
                'area' => 83846000,
                'capital_names' => '{"de": "Cayenne", "en": "Cayenne"}',
                'comments' => null,
                'fips10' => 'FG',
                'ioc' => null,
                'iso3166_alpha_2' => 'GF',
                'iso3166_alpha_3' => 'GUF',
                'iso3166_numeric' => '254',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Französisch-Guayana", "en": "French Guiana"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'FG',
                'nato_country_code_3' => 'GUF',
                'short_names' => '{"de": "Französisch-Guayana", "en": "French Guiana"}',
                'telephone_country_code' => '+594',
                'telephone_country_code_extended' => '+594',
                'tld' => '.gf',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 82,
                'active' => 0,
                'area' => 78000,
                'capital_names' => '{"de": "St. Peter Port", "en": "St. Peter Port"}',
                'comments' => null,
                'fips10' => 'GK',
                'ioc' => null,
                'iso3166_alpha_2' => 'GG',
                'iso3166_alpha_3' => 'GGY',
                'iso3166_numeric' => '831',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Bailiwick of Guernsey", "en": "Bailiwick of Guernsey"}',
                'nationality_names' => null,
                'nato_country_code_2' => null,
                'nato_country_code_3' => null,
                'short_names' => '{"de": "Guernsey", "en": "Guernsey"}',
                'telephone_country_code' => '+44',
                'telephone_country_code_extended' => '+44',
                'tld' => '.gg',
                'vehicle_registration_code' => 'GBG',
            ],
            [
                'id' => 83,
                'active' => 0,
                'area' => 238533,
                'capital_names' => '{"de": "Accra"}',
                'comments' => null,
                'fips10' => 'GH',
                'ioc' => 'GHA',
                'iso3166_alpha_2' => 'GH',
                'iso3166_alpha_3' => 'GHA',
                'iso3166_numeric' => '288',
                'local_name' => 'Ghana',
                'locales' => null,
                'long_names' => '{"de": "Republik Ghana", "en": "Republic Of Ghana"}',
                'nationality_names' => '{"de": "ghanaisch"}',
                'nato_country_code_2' => 'GH',
                'nato_country_code_3' => 'GHA',
                'short_names' => '{"de": "Ghana", "en": "Ghana"}',
                'telephone_country_code' => '+233',
                'telephone_country_code_extended' => '+233',
                'tld' => '.gh',
                'vehicle_registration_code' => 'GH',
            ],
            [
                'id' => 84,
                'active' => 0,
                'area' => 6500,
                'capital_names' => '{"de": "Gibraltar", "en": "Gibraltar"}',
                'comments' => null,
                'fips10' => 'GI',
                'ioc' => null,
                'iso3166_alpha_2' => 'GI',
                'iso3166_alpha_3' => 'GIB',
                'iso3166_numeric' => '292',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Gibraltar", "en": "Gibraltar"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'GI',
                'nato_country_code_3' => 'GIB',
                'short_names' => '{"de": "Gibraltar", "en": "Gibraltar"}',
                'telephone_country_code' => '+350',
                'telephone_country_code_extended' => '+350',
                'tld' => '.gi',
                'vehicle_registration_code' => 'GBZ',
            ],
            [
                'id' => 85,
                'active' => 0,
                'area' => 2166086,
                'capital_names' => '{"de": "Nuuk", "en": "Nuuk"}',
                'comments' => null,
                'fips10' => 'GL',
                'ioc' => null,
                'iso3166_alpha_2' => 'GL',
                'iso3166_alpha_3' => 'GRL',
                'iso3166_numeric' => '308',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Grönland", "en": "Greenland"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'GL',
                'nato_country_code_3' => 'GLR',
                'short_names' => '{"de": "Grönland", "en": "Greenland"}',
                'telephone_country_code' => '+299',
                'telephone_country_code_extended' => '+299',
                'tld' => '.gl',
                'vehicle_registration_code' => 'KN',
            ],
            [
                'id' => 86,
                'active' => 0,
                'area' => 11295,
                'capital_names' => '{"de": "Banjul"}',
                'comments' => null,
                'fips10' => 'GA',
                'ioc' => 'GAM',
                'iso3166_alpha_2' => 'GM',
                'iso3166_alpha_3' => 'GMB',
                'iso3166_numeric' => '270',
                'local_name' => 'Gambia, the',
                'locales' => null,
                'long_names' => '{"de": "Republik Gambia", "en": "Republic Of The Gambia"}',
                'nationality_names' => '{"de": "gambisch"}',
                'nato_country_code_2' => 'GA',
                'nato_country_code_3' => 'GMB',
                'short_names' => '{"de": "Gambia", "en": "Gambia"}',
                'telephone_country_code' => '+220',
                'telephone_country_code_extended' => '+220',
                'tld' => '.gm',
                'vehicle_registration_code' => 'WAG',
            ],
            [
                'id' => 87,
                'active' => 0,
                'area' => 245857,
                'capital_names' => '{"de": "Conakry"}',
                'comments' => null,
                'fips10' => 'GV',
                'ioc' => 'GUI',
                'iso3166_alpha_2' => 'GN',
                'iso3166_alpha_3' => 'GIN',
                'iso3166_numeric' => '324',
                'local_name' => 'Guinée',
                'locales' => null,
                'long_names' => '{"de": "Republik Guinea", "en": "Republic Of Guinea"}',
                'nationality_names' => '{"de": "guineisch"}',
                'nato_country_code_2' => 'GV',
                'nato_country_code_3' => 'GIN',
                'short_names' => '{"de": "Guinea", "en": "Guinea"}',
                'telephone_country_code' => '+224',
                'telephone_country_code_extended' => '+224',
                'tld' => '.gn',
                'vehicle_registration_code' => 'GUI',
            ],
            [
                'id' => 88,
                'active' => 0,
                'area' => 2166086,
                'capital_names' => '{"de": "Basse-Terre", "en": "Basse-Terre"}',
                'comments' => null,
                'fips10' => 'GP',
                'ioc' => null,
                'iso3166_alpha_2' => 'GP',
                'iso3166_alpha_3' => 'GLP',
                'iso3166_numeric' => '312',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Guadeloupe", "en": "Guadeloupe"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'GP',
                'nato_country_code_3' => 'GLP',
                'short_names' => '{"de": "Guadeloupe", "en": "Guadeloupe"}',
                'telephone_country_code' => '+590',
                'telephone_country_code_extended' => '+590',
                'tld' => '.gp',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 89,
                'active' => 0,
                'area' => 28051,
                'capital_names' => '{"de": "Malabo"}',
                'comments' => null,
                'fips10' => 'EK',
                'ioc' => 'GEQ',
                'iso3166_alpha_2' => 'GQ',
                'iso3166_alpha_3' => 'GNQ',
                'iso3166_numeric' => '226',
                'local_name' => 'Guinea Ecuatorial',
                'locales' => null,
                'long_names' => '{"de": "Republik Äquatorialguinea", "en": "Republic Of Equatorial Guinea"}',
                'nationality_names' => '{"de": "äquatorial-guineisch"}',
                'nato_country_code_2' => 'EK',
                'nato_country_code_3' => 'GNQ',
                'short_names' => '{"de": "Äquatorialguinea", "en": "Equatorial Guinea"}',
                'telephone_country_code' => '+240',
                'telephone_country_code_extended' => '+240',
                'tld' => '.gq',
                'vehicle_registration_code' => 'GQ',
            ],
            [
                'id' => 90,
                'active' => 1,
                'area' => 131957,
                'capital_names' => '{"de": "Athen", "en": "Athens"}',
                'comments' => null,
                'fips10' => 'GR',
                'ioc' => 'GRE',
                'iso3166_alpha_2' => 'GR',
                'iso3166_alpha_3' => 'GRC',
                'iso3166_numeric' => '300',
                'local_name' => 'Elláda oder Ellás',
                'locales' => null,
                'long_names' => '{"de": "Hellenische Republik", "en": "Hellenic Republic"}',
                'nationality_names' => '{"de": "griechisch"}',
                'nato_country_code_2' => 'GR',
                'nato_country_code_3' => 'GRC',
                'short_names' => '{"de": "Griechenland", "en": "Greece"}',
                'telephone_country_code' => '+30',
                'telephone_country_code_extended' => '+30',
                'tld' => '.gr',
                'vehicle_registration_code' => 'GR',
            ],
            [
                'id' => 91,
                'active' => 0,
                'area' => 4066000,
                'capital_names' => '{"de": "King Edward Point", "en": "King Edward Point"}',
                'comments' => null,
                'fips10' => 'SX',
                'ioc' => null,
                'iso3166_alpha_2' => 'GS',
                'iso3166_alpha_3' => 'SGS',
                'iso3166_numeric' => '239',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Südgeorgien und die Südlichen Sandwichinseln", "en": "South Georgia and the South Sandwich Islands"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'SX',
                'nato_country_code_3' => 'SGS',
                'short_names' => '{"de": "Südgeorgien", "en": "South Georgia"}',
                'telephone_country_code' => '+500',
                'telephone_country_code_extended' => '+500',
                'tld' => '.gs',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 92,
                'active' => 0,
                'area' => 108889,
                'capital_names' => '{"de": "Guatemala-Stadt"}',
                'comments' => null,
                'fips10' => 'GT',
                'ioc' => 'GUA',
                'iso3166_alpha_2' => 'GT',
                'iso3166_alpha_3' => 'GTM',
                'iso3166_numeric' => '320',
                'local_name' => 'Guatemala',
                'locales' => null,
                'long_names' => '{"de": "Republik Guatemala", "en": "Republic Of Guatemala"}',
                'nationality_names' => '{"de": "guatemaltekisch"}',
                'nato_country_code_2' => 'GT',
                'nato_country_code_3' => 'GTM',
                'short_names' => '{"de": "Guatemala", "en": "Guatemala"}',
                'telephone_country_code' => '+502',
                'telephone_country_code_extended' => '+502',
                'tld' => '.gt',
                'vehicle_registration_code' => 'GCA',
            ],
            [
                'id' => 93,
                'active' => 0,
                'area' => 545,
                'capital_names' => '{"de": "Hagåtña", "en": "Hagåtña"}',
                'comments' => null,
                'fips10' => 'GQ',
                'ioc' => 'GUM',
                'iso3166_alpha_2' => 'GU',
                'iso3166_alpha_3' => 'GUM',
                'iso3166_numeric' => '316',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Guam", "en": "Guam"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'GQ',
                'nato_country_code_3' => 'GUM',
                'short_names' => '{"de": "Guam", "en": "Guam"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1671',
                'tld' => '.gu',
                'vehicle_registration_code' => 'USA',
            ],
            [
                'id' => 94,
                'active' => 0,
                'area' => 36125,
                'capital_names' => '{"de": "Bissau"}',
                'comments' => null,
                'fips10' => 'PU',
                'ioc' => 'GBS',
                'iso3166_alpha_2' => 'GW',
                'iso3166_alpha_3' => 'GNB',
                'iso3166_numeric' => '624',
                'local_name' => 'Guiné-Bissau',
                'locales' => null,
                'long_names' => '{"de": "Republik Guinea-Bissau", "en": "Republic Of Guinea-Bissau"}',
                'nationality_names' => '{"de": "guinea-bissauisch"}',
                'nato_country_code_2' => 'PU',
                'nato_country_code_3' => 'GNB',
                'short_names' => '{"de": "Guinea-Bissau", "en": "Guinea-Bissau"}',
                'telephone_country_code' => '+245',
                'telephone_country_code_extended' => '+245',
                'tld' => '.gw',
                'vehicle_registration_code' => 'GUB',
            ],
            [
                'id' => 95,
                'active' => 0,
                'area' => 214969,
                'capital_names' => '{"de": "Georgetown"}',
                'comments' => null,
                'fips10' => 'GY',
                'ioc' => 'GUY',
                'iso3166_alpha_2' => 'GY',
                'iso3166_alpha_3' => 'GUY',
                'iso3166_numeric' => '328',
                'local_name' => 'Guyana',
                'locales' => null,
                'long_names' => '{"de": "Kooperative Republik Guyana", "en": "Co-Operative Republic Of Guyana"}',
                'nationality_names' => '{"de": "guyanisch"}',
                'nato_country_code_2' => 'GY',
                'nato_country_code_3' => 'GUY',
                'short_names' => '{"de": "Guyana", "en": "Guyana"}',
                'telephone_country_code' => '+592',
                'telephone_country_code_extended' => '+592',
                'tld' => '.gy',
                'vehicle_registration_code' => 'GUY',
            ],
            [
                'id' => 96,
                'active' => 0,
                'area' => 1114600,
                'capital_names' => '{"de": "Hongkong", "en": "Hong Kong"}',
                'comments' => null,
                'fips10' => 'HK',
                'ioc' => 'HKG',
                'iso3166_alpha_2' => 'HK',
                'iso3166_alpha_3' => 'HKG',
                'iso3166_numeric' => '344',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Hongkong", "en": "Hong Kong"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'HK',
                'nato_country_code_3' => 'HKG',
                'short_names' => '{"de": "Hongkong", "en": "Hong Kong"}',
                'telephone_country_code' => '+852',
                'telephone_country_code_extended' => '+852',
                'tld' => '.hk',
                'vehicle_registration_code' => 'HK',
            ],
            [
                'id' => 97,
                'active' => 0,
                'area' => 372000,
                'capital_names' => '{"de": ""}',
                'comments' => null,
                'fips10' => 'HM',
                'ioc' => null,
                'iso3166_alpha_2' => 'HM',
                'iso3166_alpha_3' => 'HMD',
                'iso3166_numeric' => '334',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Heard und McDonaldinseln", "en": "Heard Island and McDonald Islands"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'HM',
                'nato_country_code_3' => 'HMD',
                'short_names' => '{"de": "Heard und McDonaldinseln", "en": "Heard Island and McDonald Islands"}',
                'telephone_country_code' => '+672',
                'telephone_country_code_extended' => '+672',
                'tld' => '.hm',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 98,
                'active' => 0,
                'area' => 112090,
                'capital_names' => '{"de": "Tegucigalpa"}',
                'comments' => null,
                'fips10' => 'HO',
                'ioc' => 'HON',
                'iso3166_alpha_2' => 'HN',
                'iso3166_alpha_3' => 'HND',
                'iso3166_numeric' => '340',
                'local_name' => 'Honduras',
                'locales' => null,
                'long_names' => '{"de": "Republik Honduras", "en": "Republic Of Honduras"}',
                'nationality_names' => '{"de": "hondurianisch"}',
                'nato_country_code_2' => 'HO',
                'nato_country_code_3' => 'HND',
                'short_names' => '{"de": "Honduras", "en": "Honduras"}',
                'telephone_country_code' => '+504',
                'telephone_country_code_extended' => '+504',
                'tld' => '.hn',
                'vehicle_registration_code' => 'HN',
            ],
            [
                'id' => 99,
                'active' => 1,
                'area' => 56594,
                'capital_names' => '{"de": "Zagreb (Agram)"}',
                'comments' => null,
                'fips10' => 'HR',
                'ioc' => 'CRO',
                'iso3166_alpha_2' => 'HR',
                'iso3166_alpha_3' => 'HRV',
                'iso3166_numeric' => '191',
                'local_name' => 'Hrvatska',
                'locales' => null,
                'long_names' => '{"de": "Republik Kroatien", "en": "Republic Of Croatia"}',
                'nationality_names' => '{"de": "kroatisch"}',
                'nato_country_code_2' => 'HR',
                'nato_country_code_3' => 'HRV',
                'short_names' => '{"de": "Kroatien", "en": "Croatia"}',
                'telephone_country_code' => '+385',
                'telephone_country_code_extended' => '+385',
                'tld' => '.hr',
                'vehicle_registration_code' => 'HR',
            ],
            [
                'id' => 100,
                'active' => 0,
                'area' => 27750,
                'capital_names' => '{"de": "Port-au-Prince"}',
                'comments' => null,
                'fips10' => 'HA',
                'ioc' => 'HAI',
                'iso3166_alpha_2' => 'HT',
                'iso3166_alpha_3' => 'HTI',
                'iso3166_numeric' => '332',
                'local_name' => 'Haïti',
                'locales' => null,
                'long_names' => '{"de": "Republik Haiti", "en": "Republic Of Haiti"}',
                'nationality_names' => '{"de": "haitianisch"}',
                'nato_country_code_2' => 'HA',
                'nato_country_code_3' => 'HTI',
                'short_names' => '{"de": "Haiti", "en": "Haiti"}',
                'telephone_country_code' => '+509',
                'telephone_country_code_extended' => '+509',
                'tld' => '.ht',
                'vehicle_registration_code' => 'RH',
            ],
            [
                'id' => 101,
                'active' => 1,
                'area' => 93028,
                'capital_names' => '{"de": "Budapest"}',
                'comments' => null,
                'fips10' => 'HU',
                'ioc' => 'HUN',
                'iso3166_alpha_2' => 'HU',
                'iso3166_alpha_3' => 'HUN',
                'iso3166_numeric' => '348',
                'local_name' => 'Magyarország',
                'locales' => null,
                'long_names' => '{"de": "Ungarn", "en": "Republic Of Hungary"}',
                'nationality_names' => '{"de": "ungarisch"}',
                'nato_country_code_2' => 'HU',
                'nato_country_code_3' => 'HUN',
                'short_names' => '{"de": "Ungarn", "en": "Hungary"}',
                'telephone_country_code' => '+36',
                'telephone_country_code_extended' => '+36',
                'tld' => '.hu',
                'vehicle_registration_code' => 'H',
            ],
            [
                'id' => 102,
                'active' => 0,
                'area' => 1904569,
                'capital_names' => '{"de": "Jakarta"}',
                'comments' => null,
                'fips10' => 'ID',
                'ioc' => 'INA',
                'iso3166_alpha_2' => 'ID',
                'iso3166_alpha_3' => 'IDN',
                'iso3166_numeric' => '360',
                'local_name' => 'Indonesia',
                'locales' => null,
                'long_names' => '{"de": "Republik Indonesien", "en": "Republic Of Indonesia"}',
                'nationality_names' => '{"de": "indoneisch"}',
                'nato_country_code_2' => 'ID',
                'nato_country_code_3' => 'IDN',
                'short_names' => '{"de": "Indonesien", "en": "Indonesia"}',
                'telephone_country_code' => '+62',
                'telephone_country_code_extended' => '+62',
                'tld' => '.id',
                'vehicle_registration_code' => 'RI',
            ],
            [
                'id' => 103,
                'active' => 1,
                'area' => 70273,
                'capital_names' => '{"de": "Dublin"}',
                'comments' => null,
                'fips10' => 'EI',
                'ioc' => 'IRL',
                'iso3166_alpha_2' => 'IE',
                'iso3166_alpha_3' => 'IRL',
                'iso3166_numeric' => '372',
                'local_name' => 'Éire (Irisch), Ireland (Englisch)',
                'locales' => null,
                'long_names' => '{"de": "Irland", "en": "Ireland"}',
                'nationality_names' => '{"de": "irisch"}',
                'nato_country_code_2' => 'EI',
                'nato_country_code_3' => 'IRL',
                'short_names' => '{"de": "Irland", "en": "Ireland"}',
                'telephone_country_code' => '+353',
                'telephone_country_code_extended' => '+353',
                'tld' => '.ie',
                'vehicle_registration_code' => 'IRL',
            ],
            [
                'id' => 104,
                'active' => 0,
                'area' => 22380,
                'capital_names' => '{"de": "Jerusalem"}',
                'comments' => null,
                'fips10' => 'IS',
                'ioc' => 'ISR',
                'iso3166_alpha_2' => 'IL',
                'iso3166_alpha_3' => 'ISR',
                'iso3166_numeric' => '376',
                'local_name' => 'Yisr\'el',
                'locales' => null,
                'long_names' => '{"de": "Staat Israel", "en": "State Of Israel"}',
                'nationality_names' => '{"de": "israelisch"}',
                'nato_country_code_2' => 'IS',
                'nato_country_code_3' => 'ISR',
                'short_names' => '{"de": "Israel", "en": "Israel"}',
                'telephone_country_code' => '+972',
                'telephone_country_code_extended' => '+972',
                'tld' => '.il',
                'vehicle_registration_code' => 'IL',
            ],
            [
                'id' => 105,
                'active' => 0,
                'area' => 572000,
                'capital_names' => '{"de": "Douglas", "en": "Douglas"}',
                'comments' => null,
                'fips10' => 'IM',
                'ioc' => null,
                'iso3166_alpha_2' => 'IM',
                'iso3166_alpha_3' => 'IMN',
                'iso3166_numeric' => '833',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Isle of Man", "en": "Isle of Man"}',
                'nationality_names' => null,
                'nato_country_code_2' => null,
                'nato_country_code_3' => null,
                'short_names' => '{"de": "Isle of Man", "en": "Isle of Man"}',
                'telephone_country_code' => '+44',
                'telephone_country_code_extended' => '+44',
                'tld' => '.im',
                'vehicle_registration_code' => 'GBM',
            ],
            [
                'id' => 106,
                'active' => 0,
                'area' => 3287263,
                'capital_names' => '{"de": "Neu-Delhi"}',
                'comments' => null,
                'fips10' => 'IN',
                'ioc' => 'IND',
                'iso3166_alpha_2' => 'IN',
                'iso3166_alpha_3' => 'IND',
                'iso3166_numeric' => '356',
                'local_name' => 'India (Englisch), Bharat (Hindi)',
                'locales' => null,
                'long_names' => '{"de": "Republik Indien", "en": "Republic Of India"}',
                'nationality_names' => '{"de": "indisch"}',
                'nato_country_code_2' => 'IN',
                'nato_country_code_3' => 'IND',
                'short_names' => '{"de": "Indien", "en": "India"}',
                'telephone_country_code' => '+91',
                'telephone_country_code_extended' => '+91',
                'tld' => '.in',
                'vehicle_registration_code' => 'IND',
            ],
            [
                'id' => 107,
                'active' => 0,
                'area' => 63170,
                'capital_names' => '{"de": ""}',
                'comments' => null,
                'fips10' => 'IO',
                'ioc' => null,
                'iso3166_alpha_2' => 'IO',
                'iso3166_alpha_3' => 'IOT',
                'iso3166_numeric' => '086',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Britisches Territorium im Indischen Ozean", "en": "British Indian Ocean Territory"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'IO',
                'nato_country_code_3' => 'IOT',
                'short_names' => '{"de": "Britisches Territorium im Indischen Ozean", "en": "British Indian Ocean Territory"}',
                'telephone_country_code' => '+246',
                'telephone_country_code_extended' => '+246',
                'tld' => '.io',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 108,
                'active' => 0,
                'area' => 438317,
                'capital_names' => '{"de": "Bagdad"}',
                'comments' => null,
                'fips10' => 'IZ',
                'ioc' => 'IRQ',
                'iso3166_alpha_2' => 'IQ',
                'iso3166_alpha_3' => 'IRQ',
                'iso3166_numeric' => '368',
                'local_name' => 'al-ʿIrāq',
                'locales' => null,
                'long_names' => '{"de": "Republik Irak", "en": "Republic Of Iraq"}',
                'nationality_names' => '{"de": "irakisch"}',
                'nato_country_code_2' => 'IZ',
                'nato_country_code_3' => 'IRQ',
                'short_names' => '{"de": "Irak", "en": "Iraq"}',
                'telephone_country_code' => '+964',
                'telephone_country_code_extended' => '+964',
                'tld' => '.iq',
                'vehicle_registration_code' => 'IRQ',
            ],
            [
                'id' => 109,
                'active' => 1,
                'area' => 1648195,
                'capital_names' => '{"de": "Teheran"}',
                'comments' => null,
                'fips10' => 'IR',
                'ioc' => 'IRI',
                'iso3166_alpha_2' => 'IR',
                'iso3166_alpha_3' => 'IRN',
                'iso3166_numeric' => '364',
                'local_name' => 'Īrān',
                'locales' => null,
                'long_names' => '{"de": "Islamische Republik Iran", "en": "Islamic Republic Of Iran"}',
                'nationality_names' => '{"de": "iranisch"}',
                'nato_country_code_2' => 'IR',
                'nato_country_code_3' => 'IRN',
                'short_names' => '{"de": "Iran", "en": "Iran"}',
                'telephone_country_code' => '+98',
                'telephone_country_code_extended' => '+98',
                'tld' => '.ir',
                'vehicle_registration_code' => 'IR',
            ],
            [
                'id' => 110,
                'active' => 1,
                'area' => 103000,
                'capital_names' => '{"de": "Reykjavík"}',
                'comments' => null,
                'fips10' => 'IC',
                'ioc' => 'ISL',
                'iso3166_alpha_2' => 'IS',
                'iso3166_alpha_3' => 'ISL',
                'iso3166_numeric' => '352',
                'local_name' => 'Ísland',
                'locales' => null,
                'long_names' => '{"de": "Republik Island", "en": "Republic Of Iceland"}',
                'nationality_names' => '{"de": "isländisch"}',
                'nato_country_code_2' => 'IC',
                'nato_country_code_3' => 'ISL',
                'short_names' => '{"de": "Island", "en": "Iceland"}',
                'telephone_country_code' => '+354',
                'telephone_country_code_extended' => '+354',
                'tld' => '.is',
                'vehicle_registration_code' => 'IS',
            ],
            [
                'id' => 111,
                'active' => 1,
                'area' => 301340,
                'capital_names' => '{"de": "Rom"}',
                'comments' => null,
                'fips10' => 'IT',
                'ioc' => 'ITA',
                'iso3166_alpha_2' => 'IT',
                'iso3166_alpha_3' => 'ITA',
                'iso3166_numeric' => '380',
                'local_name' => 'Italia',
                'locales' => null,
                'long_names' => '{"de": "Italienische Republik", "en": "Italian Republic"}',
                'nationality_names' => '{"de": "italienisch"}',
                'nato_country_code_2' => 'IT',
                'nato_country_code_3' => 'ITA',
                'short_names' => '{"de": "Italien", "en": "Italy"}',
                'telephone_country_code' => '+39',
                'telephone_country_code_extended' => '+39',
                'tld' => '.it',
                'vehicle_registration_code' => 'I',
            ],
            [
                'id' => 112,
                'active' => 0,
                'area' => 119600,
                'capital_names' => '{"de": "Saint Helier", "en": "Saint Helier"}',
                'comments' => null,
                'fips10' => 'JE',
                'ioc' => null,
                'iso3166_alpha_2' => 'JE',
                'iso3166_alpha_3' => 'JEY',
                'iso3166_numeric' => '832',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Bailiwick of Jersey", "en": "Bailiwick of Jersey"}',
                'nationality_names' => null,
                'nato_country_code_2' => null,
                'nato_country_code_3' => null,
                'short_names' => '{"de": "Bailiwick of Jersey", "en": "Bailiwick of Jersey"}',
                'telephone_country_code' => '+44',
                'telephone_country_code_extended' => '+44',
                'tld' => '.je',
                'vehicle_registration_code' => 'GBJ',
            ],
            [
                'id' => 113,
                'active' => 0,
                'area' => 10991,
                'capital_names' => '{"de": "Kingston"}',
                'comments' => null,
                'fips10' => 'JM',
                'ioc' => 'JAM',
                'iso3166_alpha_2' => 'JM',
                'iso3166_alpha_3' => 'JAM',
                'iso3166_numeric' => '388',
                'local_name' => 'Jamaica',
                'locales' => null,
                'long_names' => '{"de": "Jamaika", "en": "Jamaica"}',
                'nationality_names' => '{"de": "jamaikanisch"}',
                'nato_country_code_2' => 'JM',
                'nato_country_code_3' => 'JAM',
                'short_names' => '{"de": "Jamaika", "en": "Jamaica"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1876',
                'tld' => '.jm',
                'vehicle_registration_code' => 'JA',
            ],
            [
                'id' => 114,
                'active' => 0,
                'area' => 89342,
                'capital_names' => '{"de": "Amman"}',
                'comments' => null,
                'fips10' => 'JO',
                'ioc' => 'JOR',
                'iso3166_alpha_2' => 'JO',
                'iso3166_alpha_3' => 'JOR',
                'iso3166_numeric' => '400',
                'local_name' => 'al-Urdunn',
                'locales' => null,
                'long_names' => '{"de": "Haschemitisches Königreich Jordanien", "en": "Hashemite Kingdom Of Jordan"}',
                'nationality_names' => '{"de": "jordanisch"}',
                'nato_country_code_2' => 'JO',
                'nato_country_code_3' => 'JOR',
                'short_names' => '{"de": "Jordanien", "en": "Jordan"}',
                'telephone_country_code' => '+962',
                'telephone_country_code_extended' => '+962',
                'tld' => '.jo',
                'vehicle_registration_code' => 'HKJ',
            ],
            [
                'id' => 115,
                'active' => 0,
                'area' => 377915,
                'capital_names' => '{"de": "Tokio"}',
                'comments' => null,
                'fips10' => 'JA',
                'ioc' => 'JPN',
                'iso3166_alpha_2' => 'JP',
                'iso3166_alpha_3' => 'JPN',
                'iso3166_numeric' => '392',
                'local_name' => 'Nihon oder Nippon',
                'locales' => null,
                'long_names' => '{"de": "Japan", "en": "Japan"}',
                'nationality_names' => '{"de": "japanisch"}',
                'nato_country_code_2' => 'JA',
                'nato_country_code_3' => 'JPN',
                'short_names' => '{"de": "Japan", "en": "Japan"}',
                'telephone_country_code' => '+81',
                'telephone_country_code_extended' => '+81',
                'tld' => '.jp',
                'vehicle_registration_code' => 'J',
            ],
            [
                'id' => 116,
                'active' => 0,
                'area' => 580367,
                'capital_names' => '{"de": "Nairobi"}',
                'comments' => null,
                'fips10' => 'KE',
                'ioc' => 'KEN',
                'iso3166_alpha_2' => 'KE',
                'iso3166_alpha_3' => 'KEN',
                'iso3166_numeric' => '404',
                'local_name' => 'Kenya',
                'locales' => null,
                'long_names' => '{"de": "Republik Kenia", "en": "Republic Of Kenya"}',
                'nationality_names' => '{"de": "kenianisch"}',
                'nato_country_code_2' => 'KE',
                'nato_country_code_3' => 'KEN',
                'short_names' => '{"de": "Kenia", "en": "Kenya"}',
                'telephone_country_code' => '+254',
                'telephone_country_code_extended' => '+254',
                'tld' => '.ke',
                'vehicle_registration_code' => 'EAK',
            ],
            [
                'id' => 117,
                'active' => 0,
                'area' => 199951,
                'capital_names' => '{"de": "Bischkek"}',
                'comments' => null,
                'fips10' => 'KG',
                'ioc' => 'KGZ',
                'iso3166_alpha_2' => 'KG',
                'iso3166_alpha_3' => 'KGZ',
                'iso3166_numeric' => '417',
                'local_name' => 'Kyrgyzstan (Kirgisisch)',
                'locales' => null,
                'long_names' => '{"de": "Kirgisische Republik", "en": "Kyrgyz Republic"}',
                'nationality_names' => '{"de": "kirgisisch"}',
                'nato_country_code_2' => 'KG',
                'nato_country_code_3' => 'KGZ',
                'short_names' => '{"de": "Kirgisistan", "en": "Kyrgyzstan"}',
                'telephone_country_code' => '+996',
                'telephone_country_code_extended' => '+996',
                'tld' => '.kg',
                'vehicle_registration_code' => 'KG',
            ],
            [
                'id' => 118,
                'active' => 0,
                'area' => 181035,
                'capital_names' => '{"de": "Phnom Penh"}',
                'comments' => null,
                'fips10' => 'CB',
                'ioc' => 'CAM',
                'iso3166_alpha_2' => 'KH',
                'iso3166_alpha_3' => 'KHM',
                'iso3166_numeric' => '116',
                'local_name' => 'Kampuchea',
                'locales' => null,
                'long_names' => '{"de": "Königreich Kambodscha", "en": "Kingdom Of Cambodia"}',
                'nationality_names' => '{"de": "kambodschanisch"}',
                'nato_country_code_2' => 'CB',
                'nato_country_code_3' => 'KHM',
                'short_names' => '{"de": "Kambodscha", "en": "Cambodia"}',
                'telephone_country_code' => '+855',
                'telephone_country_code_extended' => '+855',
                'tld' => '.kh',
                'vehicle_registration_code' => 'K',
            ],
            [
                'id' => 119,
                'active' => 0,
                'area' => 811,
                'capital_names' => '{"de": "South Tarawa"}',
                'comments' => null,
                'fips10' => 'KR',
                'ioc' => 'KIR',
                'iso3166_alpha_2' => 'KI',
                'iso3166_alpha_3' => 'KIR',
                'iso3166_numeric' => '296',
                'local_name' => 'Kiribati oder Kiribas',
                'locales' => null,
                'long_names' => '{"de": "Republik Kiribati", "en": "Republic Of Kiribati"}',
                'nationality_names' => '{"de": "kiribati"}',
                'nato_country_code_2' => 'KR',
                'nato_country_code_3' => 'KIR',
                'short_names' => '{"de": "Kiribati", "en": "Kiribati"}',
                'telephone_country_code' => '+686',
                'telephone_country_code_extended' => '+686',
                'tld' => '.ki',
                'vehicle_registration_code' => 'KIR',
            ],
            [
                'id' => 120,
                'active' => 0,
                'area' => 2235,
                'capital_names' => '{"de": "Moroni"}',
                'comments' => null,
                'fips10' => 'CN',
                'ioc' => 'COM',
                'iso3166_alpha_2' => 'KM',
                'iso3166_alpha_3' => 'COM',
                'iso3166_numeric' => '174',
                'local_name' => 'Comores',
                'locales' => null,
                'long_names' => '{"de": "Union der Komoren", "en": "Union Of The Comoros"}',
                'nationality_names' => '{"de": "komorisch"}',
                'nato_country_code_2' => 'CN',
                'nato_country_code_3' => 'COM',
                'short_names' => '{"de": "Komoren", "en": "Comoros"}',
                'telephone_country_code' => '+269',
                'telephone_country_code_extended' => '+269',
                'tld' => '.km',
                'vehicle_registration_code' => 'COM',
            ],
            [
                'id' => 121,
                'active' => 0,
                'area' => 261,
                'capital_names' => '{"de": "Basseterre"}',
                'comments' => null,
                'fips10' => 'SC',
                'ioc' => 'SKN',
                'iso3166_alpha_2' => 'KN',
                'iso3166_alpha_3' => 'KNA',
                'iso3166_numeric' => '659',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Föderation St. Kitts und Nevis", "en": "Federation Of Saint Kitts And Nevis"}',
                'nationality_names' => '{"de": ""}',
                'nato_country_code_2' => 'KN',
                'nato_country_code_3' => 'KNA',
                'short_names' => '{"de": "St. Kitts und Nevis", "en": "Saint Kitts And Nevis"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1869',
                'tld' => '.kn',
                'vehicle_registration_code' => 'KAN',
            ],
            [
                'id' => 122,
                'active' => 0,
                'area' => 120538,
                'capital_names' => '{"de": "Pjöngjang"}',
                'comments' => null,
                'fips10' => 'KN',
                'ioc' => 'PRK',
                'iso3166_alpha_2' => 'KP',
                'iso3166_alpha_3' => 'PRK',
                'iso3166_numeric' => '408',
                'local_name' => '조선민주주의인민공화국, 朝鮮民主主義人民共和國',
                'locales' => null,
                'long_names' => '{"de": "Demokratische Volksrepublik Korea", "en": "Democratic People\'s Republic Of Korea"}',
                'nationality_names' => '{"de": "nordkoreanisch"}',
                'nato_country_code_2' => 'KP',
                'nato_country_code_3' => 'PRK',
                'short_names' => '{"de": "Nordkorea", "en": "North Korea"}',
                'telephone_country_code' => '+850',
                'telephone_country_code_extended' => '+850',
                'tld' => '.kp',
                'vehicle_registration_code' => 'KP',
            ],
            [
                'id' => 123,
                'active' => 0,
                'area' => 99720,
                'capital_names' => '{"de": "Seoul"}',
                'comments' => null,
                'fips10' => 'KS',
                'ioc' => 'KOR',
                'iso3166_alpha_2' => 'KR',
                'iso3166_alpha_3' => 'KOR',
                'iso3166_numeric' => '410',
                'local_name' => '대한민국, 大韓民國',
                'locales' => null,
                'long_names' => '{"de": "Republik Korea", "en": "Republic Of Korea"}',
                'nationality_names' => '{"de": "südkoreanisch"}',
                'nato_country_code_2' => 'KS',
                'nato_country_code_3' => 'KOR',
                'short_names' => '{"de": "Südkorea", "en": "South Korea"}',
                'telephone_country_code' => '+82',
                'telephone_country_code_extended' => '+82',
                'tld' => '.kr',
                'vehicle_registration_code' => 'ROK',
            ],
            [
                'id' => 124,
                'active' => 0,
                'area' => 17818,
                'capital_names' => '{"de": "Kuwait-Stadt"}',
                'comments' => null,
                'fips10' => 'KU',
                'ioc' => 'KUW',
                'iso3166_alpha_2' => 'KW',
                'iso3166_alpha_3' => 'KWT',
                'iso3166_numeric' => '414',
                'local_name' => 'al-Kuwayt',
                'locales' => null,
                'long_names' => '{"de": "Staat Kuwait", "en": "State Of Kuwait"}',
                'nationality_names' => '{"de": "kuwaitisch"}',
                'nato_country_code_2' => 'KU',
                'nato_country_code_3' => 'KWT',
                'short_names' => '{"de": "Kuwait", "en": "Kuwait"}',
                'telephone_country_code' => '+965',
                'telephone_country_code_extended' => '+965',
                'tld' => '.kw',
                'vehicle_registration_code' => 'KWT',
            ],
            [
                'id' => 125,
                'active' => 0,
                'area' => 264000,
                'capital_names' => '{"de": "George Town", "en": "George Town"}',
                'comments' => null,
                'fips10' => 'CJ',
                'ioc' => 'CAY',
                'iso3166_alpha_2' => 'KY',
                'iso3166_alpha_3' => 'CYM',
                'iso3166_numeric' => '136',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Cayman Islands", "en": "Cayman Islands"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'CJ',
                'nato_country_code_3' => 'CYM',
                'short_names' => '{"de": "Cayman Islands", "en": "Cayman Islands"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1345',
                'tld' => '.ky',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 126,
                'active' => 1,
                'area' => 2724900,
                'capital_names' => '{"de": "Astana"}',
                'comments' => null,
                'fips10' => 'KZ',
                'ioc' => 'KAZ',
                'iso3166_alpha_2' => 'KZ',
                'iso3166_alpha_3' => 'KAZ',
                'iso3166_numeric' => '398',
                'local_name' => 'Qazaqstan (Kasachisch), Kazahstan (Russisch)',
                'locales' => null,
                'long_names' => '{"de": "Republik Kasachstan", "en": "Republic Of Kazakhstan"}',
                'nationality_names' => '{"de": "kasachisch"}',
                'nato_country_code_2' => 'KZ',
                'nato_country_code_3' => 'KAZ',
                'short_names' => '{"de": "Kasachstan", "en": "Kazakhstan"}',
                'telephone_country_code' => '+7',
                'telephone_country_code_extended' => null,
                'tld' => '.kz',
                'vehicle_registration_code' => 'KZ',
            ],
            [
                'id' => 127,
                'active' => 0,
                'area' => 236800,
                'capital_names' => '{"de": "Vientiane"}',
                'comments' => null,
                'fips10' => 'LA',
                'ioc' => 'LAO',
                'iso3166_alpha_2' => 'LA',
                'iso3166_alpha_3' => 'LAO',
                'iso3166_numeric' => '418',
                'local_name' => 'Lao',
                'locales' => null,
                'long_names' => '{"de": "Demokratische Volksrepublik Laos", "en": "Lao People\'s Democratic Republic"}',
                'nationality_names' => '{"de": "laotisch"}',
                'nato_country_code_2' => 'LA',
                'nato_country_code_3' => 'LAO',
                'short_names' => '{"de": "Laos", "en": "Laos"}',
                'telephone_country_code' => '+856',
                'telephone_country_code_extended' => '+856',
                'tld' => '.la',
                'vehicle_registration_code' => 'LAO',
            ],
            [
                'id' => 128,
                'active' => 0,
                'area' => 10400,
                'capital_names' => '{"de": "Beirut"}',
                'comments' => null,
                'fips10' => 'LE',
                'ioc' => 'LIB',
                'iso3166_alpha_2' => 'LB',
                'iso3166_alpha_3' => 'LBN',
                'iso3166_numeric' => '422',
                'local_name' => 'Lubnān',
                'locales' => null,
                'long_names' => '{"de": "Libanesische Republik", "en": "Lebanese Republic"}',
                'nationality_names' => '{"de": "libanesich"}',
                'nato_country_code_2' => 'LE',
                'nato_country_code_3' => 'LBN',
                'short_names' => '{"de": "Libanon", "en": "Lebanon"}',
                'telephone_country_code' => '+961',
                'telephone_country_code_extended' => '+961',
                'tld' => '.lb',
                'vehicle_registration_code' => 'RL',
            ],
            [
                'id' => 129,
                'active' => 0,
                'area' => 616,
                'capital_names' => '{"de": "Castries"}',
                'comments' => null,
                'fips10' => 'ST',
                'ioc' => 'LCA',
                'iso3166_alpha_2' => 'LC',
                'iso3166_alpha_3' => 'LCA',
                'iso3166_numeric' => '662',
                'local_name' => 'Saint Lucia',
                'locales' => null,
                'long_names' => '{"de": "St. Lucia", "en": "Saint Lucia"}',
                'nationality_names' => '{"de": "lucianisch"}',
                'nato_country_code_2' => 'ST',
                'nato_country_code_3' => 'LCA',
                'short_names' => '{"de": "St. Lucia", "en": "Saint Lucia"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1758',
                'tld' => '.lc',
                'vehicle_registration_code' => 'WL',
            ],
            [
                'id' => 130,
                'active' => 1,
                'area' => 160,
                'capital_names' => '{"de": "Vaduz"}',
                'comments' => null,
                'fips10' => 'LS',
                'ioc' => 'LIE',
                'iso3166_alpha_2' => 'LI',
                'iso3166_alpha_3' => 'LIE',
                'iso3166_numeric' => '438',
                'local_name' => 'Liechtenstein',
                'locales' => null,
                'long_names' => '{"de": "Fürstentum Liechtenstein", "en": "Principality Of Liechtenstein"}',
                'nationality_names' => '{"de": "liechtensteinisch"}',
                'nato_country_code_2' => 'LS',
                'nato_country_code_3' => 'LIE',
                'short_names' => '{"de": "Liechtenstein", "en": "Liechtenstein"}',
                'telephone_country_code' => '+423',
                'telephone_country_code_extended' => '+423',
                'tld' => '.li',
                'vehicle_registration_code' => 'FL',
            ],
            [
                'id' => 131,
                'active' => 0,
                'area' => 65610,
                'capital_names' => '{"de": "Colombo"}',
                'comments' => null,
                'fips10' => 'CE',
                'ioc' => 'SRI',
                'iso3166_alpha_2' => 'LK',
                'iso3166_alpha_3' => 'LKA',
                'iso3166_numeric' => '144',
                'local_name' => 'Sri Lanka',
                'locales' => null,
                'long_names' => '{"de": "Demokratische Sozialistische Republik Sri Lanka", "en": "Democratic Socialist Republic Of Sri Lanka"}',
                'nationality_names' => '{"de": "sri-lankisch"}',
                'nato_country_code_2' => 'CE',
                'nato_country_code_3' => 'LKA',
                'short_names' => '{"de": "Sri Lanka", "en": "Sri Lanka"}',
                'telephone_country_code' => '+94',
                'telephone_country_code_extended' => '+94',
                'tld' => '.lk',
                'vehicle_registration_code' => 'CL',
            ],
            [
                'id' => 132,
                'active' => 0,
                'area' => 111369,
                'capital_names' => '{"de": "Monrovia"}',
                'comments' => null,
                'fips10' => 'LI',
                'ioc' => 'LBR',
                'iso3166_alpha_2' => 'LR',
                'iso3166_alpha_3' => 'LBR',
                'iso3166_numeric' => '430',
                'local_name' => 'Liberia',
                'locales' => null,
                'long_names' => '{"de": "Republik Liberia", "en": "Republic Of Liberia"}',
                'nationality_names' => '{"de": "liberianisch"}',
                'nato_country_code_2' => 'LI',
                'nato_country_code_3' => 'LBR',
                'short_names' => '{"de": "Liberia", "en": "Liberia"}',
                'telephone_country_code' => '+231',
                'telephone_country_code_extended' => '+231',
                'tld' => '.lr',
                'vehicle_registration_code' => 'LB',
            ],
            [
                'id' => 133,
                'active' => 0,
                'area' => 30355,
                'capital_names' => '{"de": "Maseru"}',
                'comments' => null,
                'fips10' => 'LT',
                'ioc' => 'LES',
                'iso3166_alpha_2' => 'LS',
                'iso3166_alpha_3' => 'LSO',
                'iso3166_numeric' => '426',
                'local_name' => 'Lesotho',
                'locales' => null,
                'long_names' => '{"de": "Königreich Lesotho", "en": "Kingdom Of Lesotho"}',
                'nationality_names' => '{"de": "lesothisch"}',
                'nato_country_code_2' => 'LT',
                'nato_country_code_3' => 'LSO',
                'short_names' => '{"de": "Lesotho", "en": "Lesotho"}',
                'telephone_country_code' => '+266',
                'telephone_country_code_extended' => '+266',
                'tld' => '.ls',
                'vehicle_registration_code' => 'LS',
            ],
            [
                'id' => 134,
                'active' => 1,
                'area' => 65300,
                'capital_names' => '{"de": "Vilnius (Wilna)"}',
                'comments' => null,
                'fips10' => 'LH',
                'ioc' => 'LTU',
                'iso3166_alpha_2' => 'LT',
                'iso3166_alpha_3' => 'LTU',
                'iso3166_numeric' => '440',
                'local_name' => 'Lietuva',
                'locales' => null,
                'long_names' => '{"de": "Republik Litauen", "en": "Republic Of Lithuania"}',
                'nationality_names' => '{"de": "litauisch"}',
                'nato_country_code_2' => 'LH',
                'nato_country_code_3' => 'LTU',
                'short_names' => '{"de": "Litauen", "en": "Lithuania"}',
                'telephone_country_code' => '+370',
                'telephone_country_code_extended' => '+370',
                'tld' => '.lt',
                'vehicle_registration_code' => 'LT',
            ],
            [
                'id' => 135,
                'active' => 1,
                'area' => 2586,
                'capital_names' => '{"de": "Luxemburg"}',
                'comments' => null,
                'fips10' => 'LU',
                'ioc' => 'LUX',
                'iso3166_alpha_2' => 'LU',
                'iso3166_alpha_3' => 'LUX',
                'iso3166_numeric' => '442',
                'local_name' => 'Luxembourg (Französisch), Lëtzebuerg (Luxemburgisch)',
                'locales' => null,
                'long_names' => '{"de": "Großherzogtum Luxemburg", "en": "Grand Duchy Of Luxembourg"}',
                'nationality_names' => '{"de": "luxemburgisch"}',
                'nato_country_code_2' => 'LU',
                'nato_country_code_3' => 'LUX',
                'short_names' => '{"de": "Luxemburg", "en": "Luxembourg"}',
                'telephone_country_code' => '+352',
                'telephone_country_code_extended' => '+352',
                'tld' => '.lu',
                'vehicle_registration_code' => 'L',
            ],
            [
                'id' => 136,
                'active' => 1,
                'area' => 64589,
                'capital_names' => '{"de": "Riga"}',
                'comments' => null,
                'fips10' => 'LG',
                'ioc' => 'LAT',
                'iso3166_alpha_2' => 'LV',
                'iso3166_alpha_3' => 'LVA',
                'iso3166_numeric' => '428',
                'local_name' => 'Latvija',
                'locales' => null,
                'long_names' => '{"de": "Republik Lettland", "en": "Republic Of Latvia"}',
                'nationality_names' => '{"de": "lettisch"}',
                'nato_country_code_2' => 'LG',
                'nato_country_code_3' => 'LVA',
                'short_names' => '{"de": "Lettland", "en": "Latvia"}',
                'telephone_country_code' => '+371',
                'telephone_country_code_extended' => '+371',
                'tld' => '.lv',
                'vehicle_registration_code' => 'LV',
            ],
            [
                'id' => 137,
                'active' => 0,
                'area' => 1759540,
                'capital_names' => '{"de": "Tripolis"}',
                'comments' => null,
                'fips10' => 'LY',
                'ioc' => 'LBA',
                'iso3166_alpha_2' => 'LY',
                'iso3166_alpha_3' => 'LBY',
                'iso3166_numeric' => '434',
                'local_name' => 'Lībiyā',
                'locales' => null,
                'long_names' => '{"de": "Libyen", "en": "Great Socialist People\'s Libyan Arab Jamahiriya"}',
                'nationality_names' => '{"de": "libysch"}',
                'nato_country_code_2' => 'LY',
                'nato_country_code_3' => 'LBY',
                'short_names' => '{"de": "Libyen", "en": "Libya"}',
                'telephone_country_code' => '+218',
                'telephone_country_code_extended' => '+218',
                'tld' => '.ly',
                'vehicle_registration_code' => 'LAR',
            ],
            [
                'id' => 138,
                'active' => 0,
                'area' => 446550,
                'capital_names' => '{"de": "Rabat"}',
                'comments' => null,
                'fips10' => 'MO',
                'ioc' => 'MAR',
                'iso3166_alpha_2' => 'MA',
                'iso3166_alpha_3' => 'MAR',
                'iso3166_numeric' => '504',
                'local_name' => 'al-Maghrib',
                'locales' => null,
                'long_names' => '{"de": "Königreich Marokko", "en": "Kingdom Of Morocco"}',
                'nationality_names' => '{"de": "marokkanisch"}',
                'nato_country_code_2' => 'MO',
                'nato_country_code_3' => 'MAR',
                'short_names' => '{"de": "Marokko", "en": "Morocco"}',
                'telephone_country_code' => '+212',
                'telephone_country_code_extended' => '+212',
                'tld' => '.ma',
                'vehicle_registration_code' => 'MA',
            ],
            [
                'id' => 139,
                'active' => 1,
                'area' => 2,
                'capital_names' => '{"de": ""}',
                'comments' => null,
                'fips10' => 'MN',
                'ioc' => 'MON',
                'iso3166_alpha_2' => 'MC',
                'iso3166_alpha_3' => 'MCO',
                'iso3166_numeric' => '492',
                'local_name' => 'Monaco',
                'locales' => null,
                'long_names' => '{"de": "Fürstentum Monaco", "en": "Principality Of Monaco"}',
                'nationality_names' => '{"de": "monegassisch"}',
                'nato_country_code_2' => 'MN',
                'nato_country_code_3' => 'MCO',
                'short_names' => '{"de": "Monaco", "en": "Monaco"}',
                'telephone_country_code' => '+377',
                'telephone_country_code_extended' => '+377',
                'tld' => '.mc',
                'vehicle_registration_code' => 'MC',
            ],
            [
                'id' => 140,
                'active' => 1,
                'area' => 33851,
                'capital_names' => '{"de": "Chișinău"}',
                'comments' => null,
                'fips10' => 'MD',
                'ioc' => 'MDA',
                'iso3166_alpha_2' => 'MD',
                'iso3166_alpha_3' => 'MDA',
                'iso3166_numeric' => '498',
                'local_name' => 'Moldova',
                'locales' => null,
                'long_names' => '{"de": "Republik Moldau", "en": "Republic Of Moldova"}',
                'nationality_names' => '{"de": "moldawisch"}',
                'nato_country_code_2' => 'MD',
                'nato_country_code_3' => 'MDA',
                'short_names' => '{"de": "Moldau", "en": "Moldova"}',
                'telephone_country_code' => '+373',
                'telephone_country_code_extended' => '+373',
                'tld' => '.md',
                'vehicle_registration_code' => 'MD',
            ],
            [
                'id' => 141,
                'active' => 1,
                'area' => 13812,
                'capital_names' => '{"de": "Podgorica"}',
                'comments' => null,
                'fips10' => 'MW',
                'ioc' => 'MNE',
                'iso3166_alpha_2' => 'ME',
                'iso3166_alpha_3' => 'MNE',
                'iso3166_numeric' => '499',
                'local_name' => 'Crna Gora',
                'locales' => null,
                'long_names' => '{"de": "Montenegro", "en": "Montenegro"}',
                'nationality_names' => '{"de": "montenegrinisch"}',
                'nato_country_code_2' => null,
                'nato_country_code_3' => 'SCG',
                'short_names' => '{"de": "Montenegro", "en": "Montenegro"}',
                'telephone_country_code' => '+382',
                'telephone_country_code_extended' => '+382',
                'tld' => '.me',
                'vehicle_registration_code' => 'MNE',
            ],
            [
                'id' => 142,
                'active' => 0,
                'area' => 53200,
                'capital_names' => '{"de": "Marigot", "en": "Marigot"}',
                'comments' => null,
                'fips10' => 'RN',
                'ioc' => null,
                'iso3166_alpha_2' => 'MF',
                'iso3166_alpha_3' => 'MAF',
                'iso3166_numeric' => '663',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Saint-Martin", "en": "Saint-Martin"}',
                'nationality_names' => null,
                'nato_country_code_2' => null,
                'nato_country_code_3' => null,
                'short_names' => '{"de": "Saint-Martin", "en": "Saint-Martin"}',
                'telephone_country_code' => '+590',
                'telephone_country_code_extended' => '+590',
                'tld' => '.gp',
                'vehicle_registration_code' => 'F',
            ],
            [
                'id' => 143,
                'active' => 0,
                'area' => 587041,
                'capital_names' => '{"de": "Antananarivo"}',
                'comments' => null,
                'fips10' => 'MA',
                'ioc' => 'MAD',
                'iso3166_alpha_2' => 'MG',
                'iso3166_alpha_3' => 'MDG',
                'iso3166_numeric' => '450',
                'local_name' => 'Madagascar',
                'locales' => null,
                'long_names' => '{"de": "Republik Madagaskar", "en": "Republic Of Madagascar"}',
                'nationality_names' => '{"de": "madagassisch"}',
                'nato_country_code_2' => 'MA',
                'nato_country_code_3' => 'MDG',
                'short_names' => '{"de": "Madagaskar", "en": "Madagascar"}',
                'telephone_country_code' => '+261',
                'telephone_country_code_extended' => '+261',
                'tld' => '.mg',
                'vehicle_registration_code' => 'RM',
            ],
            [
                'id' => 144,
                'active' => 0,
                'area' => 181,
                'capital_names' => '{"de": "Majuro"}',
                'comments' => null,
                'fips10' => 'RM',
                'ioc' => 'MHL',
                'iso3166_alpha_2' => 'MH',
                'iso3166_alpha_3' => 'MHL',
                'iso3166_numeric' => '584',
                'local_name' => 'Marshall Islands',
                'locales' => null,
                'long_names' => '{"de": "Republik Marshallinseln", "en": "Republic Of The Marshall Islands"}',
                'nationality_names' => '{"de": "marshallisch"}',
                'nato_country_code_2' => 'RM',
                'nato_country_code_3' => 'MHL',
                'short_names' => '{"de": "Marshallinseln", "en": "Marshall Islands"}',
                'telephone_country_code' => '+692',
                'telephone_country_code_extended' => '+692',
                'tld' => '.mh',
                'vehicle_registration_code' => 'MH',
            ],
            [
                'id' => 145,
                'active' => 1,
                'area' => 25713,
                'capital_names' => '{"de": "Skopje"}',
                'comments' => null,
                'fips10' => 'MK',
                'ioc' => 'MKD',
                'iso3166_alpha_2' => 'MK',
                'iso3166_alpha_3' => 'MKD',
                'iso3166_numeric' => '807',
                'local_name' => 'Makedonija',
                'locales' => null,
                'long_names' => '{"de": "Ehemalige jugoslawische Republik Mazedonien", "en": "Republic Of Macedonia"}',
                'nationality_names' => '{"de": "mazedonisch"}',
                'nato_country_code_2' => 'FY',
                'nato_country_code_3' => 'FYR',
                'short_names' => '{"de": "Nordmazedonien", "en": "North Macedonia"}',
                'telephone_country_code' => '+389',
                'telephone_country_code_extended' => '+389',
                'tld' => '.mk',
                'vehicle_registration_code' => 'NMK',
            ],
            [
                'id' => 146,
                'active' => 0,
                'area' => 1240192,
                'capital_names' => '{"de": "Bamako"}',
                'comments' => null,
                'fips10' => 'ML',
                'ioc' => 'MLI',
                'iso3166_alpha_2' => 'ML',
                'iso3166_alpha_3' => 'MLI',
                'iso3166_numeric' => '466',
                'local_name' => 'Mali',
                'locales' => null,
                'long_names' => '{"de": "Republik Mali", "en": "Republic Of Mali"}',
                'nationality_names' => '{"de": "malisch"}',
                'nato_country_code_2' => 'ML',
                'nato_country_code_3' => 'MLI',
                'short_names' => '{"de": "Mali", "en": "Mali"}',
                'telephone_country_code' => '+223',
                'telephone_country_code_extended' => '+223',
                'tld' => '.ml',
                'vehicle_registration_code' => 'RMM',
            ],
            [
                'id' => 147,
                'active' => 0,
                'area' => 676578,
                'capital_names' => '{"de": "Naypyidaw"}',
                'comments' => null,
                'fips10' => 'BM',
                'ioc' => 'MYA',
                'iso3166_alpha_2' => 'MM',
                'iso3166_alpha_3' => 'MMR',
                'iso3166_numeric' => '104',
                'local_name' => 'Myanma Naingngandaw',
                'locales' => null,
                'long_names' => '{"de": "Republik der Union Myanmar", "en": "Union Of Burma"}',
                'nationality_names' => '{"de": "burmesisch"}',
                'nato_country_code_2' => 'BN',
                'nato_country_code_3' => 'MMR',
                'short_names' => '{"de": "Myanmar", "en": "Myanmar"}',
                'telephone_country_code' => '+95',
                'telephone_country_code_extended' => '+95',
                'tld' => '.mm',
                'vehicle_registration_code' => 'MYA',
            ],
            [
                'id' => 148,
                'active' => 0,
                'area' => 1564116,
                'capital_names' => '{"de": "Ulaanbaatar", "en": "Ulaanbaatar"}',
                'comments' => null,
                'fips10' => 'MG',
                'ioc' => 'MGL',
                'iso3166_alpha_2' => 'MN',
                'iso3166_alpha_3' => 'MNG',
                'iso3166_numeric' => '496',
                'local_name' => 'Mongol Uls',
                'locales' => null,
                'long_names' => '{"de": "Mongolei", "en": "Mongolia"}',
                'nationality_names' => '{"de": "monglolisch"}',
                'nato_country_code_2' => 'MG',
                'nato_country_code_3' => 'MNG',
                'short_names' => '{"de": "Mongolei", "en": "Mongolia"}',
                'telephone_country_code' => '+976',
                'telephone_country_code_extended' => '+976',
                'tld' => '.mn',
                'vehicle_registration_code' => 'MNG',
            ],
            [
                'id' => 149,
                'active' => 0,
                'area' => 30300,
                'capital_names' => '{"de": ""}',
                'comments' => null,
                'fips10' => 'MC',
                'ioc' => null,
                'iso3166_alpha_2' => 'MO',
                'iso3166_alpha_3' => 'MAC',
                'iso3166_numeric' => '446',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Macau", "en": "Macau"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'MC',
                'nato_country_code_3' => 'MAC',
                'short_names' => '{"de": "Macau", "en": "Macau"}',
                'telephone_country_code' => '+853',
                'telephone_country_code_extended' => '+853',
                'tld' => '.mo',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 150,
                'active' => 0,
                'area' => 477000,
                'capital_names' => '{"de": "Saipan", "en": "Saipan"}',
                'comments' => null,
                'fips10' => 'CQ',
                'ioc' => null,
                'iso3166_alpha_2' => 'MP',
                'iso3166_alpha_3' => 'MNP',
                'iso3166_numeric' => '580',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Nördliche Marianen", "en": "Northern Mariana Islands"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'CQ',
                'nato_country_code_3' => 'MNP',
                'short_names' => '{"de": "Nördliche Marianen", "en": "Northern Mariana Islands"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1670',
                'tld' => '.mp',
                'vehicle_registration_code' => 'USA',
            ],
            [
                'id' => 151,
                'active' => 0,
                'area' => 1108010,
                'capital_names' => '{"de": "Fort-de-France", "en": "Fort-de-France"}',
                'comments' => null,
                'fips10' => 'MB',
                'ioc' => null,
                'iso3166_alpha_2' => 'MQ',
                'iso3166_alpha_3' => 'MTQ',
                'iso3166_numeric' => '474',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Martinique", "en": "Martinique"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'MB',
                'nato_country_code_3' => 'MTQ',
                'short_names' => '{"de": "Martinique", "en": "Martinique"}',
                'telephone_country_code' => '+596',
                'telephone_country_code_extended' => '+596',
                'tld' => '.mq',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 152,
                'active' => 0,
                'area' => 1030700,
                'capital_names' => '{"de": "Nouakchott", "en": "Nouakchott"}',
                'comments' => null,
                'fips10' => 'MR',
                'ioc' => 'MTN',
                'iso3166_alpha_2' => 'MR',
                'iso3166_alpha_3' => 'MRT',
                'iso3166_numeric' => '478',
                'local_name' => 'Mūrītānīya',
                'locales' => null,
                'long_names' => '{"de": "Islamische Republik Mauretanien", "en": "Islamic Republic Of Mauritania"}',
                'nationality_names' => '{"de": "mauretanisch"}',
                'nato_country_code_2' => 'MR',
                'nato_country_code_3' => 'MRT',
                'short_names' => '{"de": "Mauretanien", "en": "Mauritania"}',
                'telephone_country_code' => '+222',
                'telephone_country_code_extended' => '+222',
                'tld' => '.mr',
                'vehicle_registration_code' => 'RIM',
            ],
            [
                'id' => 153,
                'active' => 0,
                'area' => 102000,
                'capital_names' => '{"de": "Plymouth", "en": "Plymouth"}',
                'comments' => null,
                'fips10' => 'MH',
                'ioc' => null,
                'iso3166_alpha_2' => 'MS',
                'iso3166_alpha_3' => 'MSR',
                'iso3166_numeric' => '500',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Montserrat", "en": "Montserrat"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'MH',
                'nato_country_code_3' => 'MSR',
                'short_names' => '{"de": "Montserrat", "en": "Montserrat"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1664',
                'tld' => '.ms',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 154,
                'active' => 1,
                'area' => 316,
                'capital_names' => '{"de": "Valletta", "en": "Valletta"}',
                'comments' => null,
                'fips10' => 'MT',
                'ioc' => 'MLT',
                'iso3166_alpha_2' => 'MT',
                'iso3166_alpha_3' => 'MLT',
                'iso3166_numeric' => '470',
                'local_name' => 'Malta',
                'locales' => null,
                'long_names' => '{"de": "Republik Malta", "en": "Republic Of Malta"}',
                'nationality_names' => '{"de": "maltesisch"}',
                'nato_country_code_2' => 'MT',
                'nato_country_code_3' => 'MLT',
                'short_names' => '{"de": "Malta", "en": "Malta"}',
                'telephone_country_code' => '+356',
                'telephone_country_code_extended' => '+356',
                'tld' => '.mt',
                'vehicle_registration_code' => 'M',
            ],
            [
                'id' => 155,
                'active' => 0,
                'area' => 2040,
                'capital_names' => '{"de": "Port Louis"}',
                'comments' => null,
                'fips10' => 'MP',
                'ioc' => 'MRI',
                'iso3166_alpha_2' => 'MU',
                'iso3166_alpha_3' => 'MUS',
                'iso3166_numeric' => '480',
                'local_name' => 'Mauritius',
                'locales' => null,
                'long_names' => '{"de": "Republik Mauritius", "en": "Republic Of Mauritius"}',
                'nationality_names' => '{"de": "mauritianisch"}',
                'nato_country_code_2' => 'MP',
                'nato_country_code_3' => 'MUS',
                'short_names' => '{"de": "Mauritius", "en": "Mauritius"}',
                'telephone_country_code' => '+230',
                'telephone_country_code_extended' => '+230',
                'tld' => '.mu',
                'vehicle_registration_code' => 'MS',
            ],
            [
                'id' => 156,
                'active' => 0,
                'area' => 298,
                'capital_names' => '{"de": "Malé", "en": "Malé"}',
                'comments' => null,
                'fips10' => 'MV',
                'ioc' => 'MDV',
                'iso3166_alpha_2' => 'MV',
                'iso3166_alpha_3' => 'MDV',
                'iso3166_numeric' => '462',
                'local_name' => 'Dhivehi Raajje',
                'locales' => null,
                'long_names' => '{"de": "Republik Malediven", "en": "Republic Of Maldives"}',
                'nationality_names' => '{"de": "maledivisch"}',
                'nato_country_code_2' => 'MV',
                'nato_country_code_3' => 'MDV',
                'short_names' => '{"de": "Malediven", "en": "Maldives"}',
                'telephone_country_code' => '+960',
                'telephone_country_code_extended' => '+960',
                'tld' => '.mv',
                'vehicle_registration_code' => 'MV',
            ],
            [
                'id' => 157,
                'active' => 0,
                'area' => 118484,
                'capital_names' => '{"de": "Lilongwe", "en": "Lilongwe"}',
                'comments' => null,
                'fips10' => 'MI',
                'ioc' => 'MAW',
                'iso3166_alpha_2' => 'MW',
                'iso3166_alpha_3' => 'MWI',
                'iso3166_numeric' => '454',
                'local_name' => 'Malawi',
                'locales' => null,
                'long_names' => '{"de": "Republik Malawi", "en": "Republic Of Malawi"}',
                'nationality_names' => '{"de": "malawisch"}',
                'nato_country_code_2' => 'MI',
                'nato_country_code_3' => 'MWI',
                'short_names' => '{"de": "Malawi", "en": "Malawi"}',
                'telephone_country_code' => '+265',
                'telephone_country_code_extended' => '+265',
                'tld' => '.mw',
                'vehicle_registration_code' => 'MW',
            ],
            [
                'id' => 158,
                'active' => 0,
                'area' => 1964375,
                'capital_names' => '{"de": "Mexiko-Stadt", "en": "Mexico City"}',
                'comments' => null,
                'fips10' => 'MX',
                'ioc' => 'MEX',
                'iso3166_alpha_2' => 'MX',
                'iso3166_alpha_3' => 'MEX',
                'iso3166_numeric' => '484',
                'local_name' => 'México',
                'locales' => null,
                'long_names' => '{"de": "Vereinigte Mexikanische Staaten", "en": "United Mexican States"}',
                'nationality_names' => '{"de": "mexikanisch"}',
                'nato_country_code_2' => 'MX',
                'nato_country_code_3' => 'MEX',
                'short_names' => '{"de": "Mexiko", "en": "Mexico"}',
                'telephone_country_code' => '+52',
                'telephone_country_code_extended' => '+52',
                'tld' => '.mx',
                'vehicle_registration_code' => 'MEX',
            ],
            [
                'id' => 159,
                'active' => 0,
                'area' => 329847,
                'capital_names' => '{"de": "Kuala Lumpur", "en": "Kuala Lumpur"}',
                'comments' => null,
                'fips10' => 'MY',
                'ioc' => 'MAS',
                'iso3166_alpha_2' => 'MY',
                'iso3166_alpha_3' => 'MYS',
                'iso3166_numeric' => '458',
                'local_name' => 'Malaysia',
                'locales' => null,
                'long_names' => '{"de": "Malaysia", "en": "Malaysia"}',
                'nationality_names' => '{"de": "malaiisch"}',
                'nato_country_code_2' => 'MY',
                'nato_country_code_3' => 'MYS',
                'short_names' => '{"de": "Malaysia", "en": "Malaysia"}',
                'telephone_country_code' => '+60',
                'telephone_country_code_extended' => '+60',
                'tld' => '.my',
                'vehicle_registration_code' => 'MAL',
            ],
            [
                'id' => 160,
                'active' => 0,
                'area' => 799380,
                'capital_names' => '{"de": "Maputo", "en": "Maputo"}',
                'comments' => null,
                'fips10' => 'MZ',
                'ioc' => 'MOZ',
                'iso3166_alpha_2' => 'MZ',
                'iso3166_alpha_3' => 'MOZ',
                'iso3166_numeric' => '508',
                'local_name' => 'Moçambique',
                'locales' => null,
                'long_names' => '{"de": "Republik Mosambik", "en": "Republic Of Mozambique"}',
                'nationality_names' => '{"de": "mosambikanisch"}',
                'nato_country_code_2' => 'MZ',
                'nato_country_code_3' => 'MOZ',
                'short_names' => '{"de": "Mosambik", "en": "Mozambique"}',
                'telephone_country_code' => '+258',
                'telephone_country_code_extended' => '+258',
                'tld' => '.mz',
                'vehicle_registration_code' => 'MOC',
            ],
            [
                'id' => 161,
                'active' => 0,
                'area' => 824292,
                'capital_names' => '{"de": "Windhoek", "en": "Windhoek"}',
                'comments' => null,
                'fips10' => 'WA',
                'ioc' => 'NAM',
                'iso3166_alpha_2' => 'NA',
                'iso3166_alpha_3' => 'NAM',
                'iso3166_numeric' => '516',
                'local_name' => 'Namibia',
                'locales' => null,
                'long_names' => '{"de": "Republik Namibia", "en": "Republic Of Namibia"}',
                'nationality_names' => '{"de": "namibisch"}',
                'nato_country_code_2' => 'WA',
                'nato_country_code_3' => 'NAM',
                'short_names' => '{"de": "Namibia", "en": "Namibia"}',
                'telephone_country_code' => '+264',
                'telephone_country_code_extended' => '+264',
                'tld' => '.na',
                'vehicle_registration_code' => 'NAM',
            ],
            [
                'id' => 162,
                'active' => 0,
                'area' => 18518920,
                'capital_names' => '{"de": "Nouméa", "en": "Nouméa"}',
                'comments' => null,
                'fips10' => 'NC',
                'ioc' => null,
                'iso3166_alpha_2' => 'NC',
                'iso3166_alpha_3' => 'NCL',
                'iso3166_numeric' => '540',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Neukaledonien", "en": "New Caledonia"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'NC',
                'nato_country_code_3' => 'NCL',
                'short_names' => '{"de": "Neukaledonien", "en": "New Caledonia"}',
                'telephone_country_code' => '+687',
                'telephone_country_code_extended' => '+687',
                'tld' => '.nc',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 163,
                'active' => 0,
                'area' => 1267000,
                'capital_names' => '{"de": "Niamey", "en": "Niamey"}',
                'comments' => null,
                'fips10' => 'NG',
                'ioc' => 'NIG',
                'iso3166_alpha_2' => 'NE',
                'iso3166_alpha_3' => 'NER',
                'iso3166_numeric' => '562',
                'local_name' => 'Niger',
                'locales' => null,
                'long_names' => '{"de": "Republik Niger", "en": "Republic Of Niger"}',
                'nationality_names' => '{"de": "nigerisch"}',
                'nato_country_code_2' => 'NG',
                'nato_country_code_3' => 'NER',
                'short_names' => '{"de": "Republik Niger", "en": "Republic Of Niger"}',
                'telephone_country_code' => '+227',
                'telephone_country_code_extended' => '+227',
                'tld' => '.ne',
                'vehicle_registration_code' => 'RN',
            ],
            [
                'id' => 164,
                'active' => 0,
                'area' => 34600,
                'capital_names' => '{"de": "Kingston", "en": "Kingston"}',
                'comments' => null,
                'fips10' => 'NF',
                'ioc' => null,
                'iso3166_alpha_2' => 'NF',
                'iso3166_alpha_3' => 'NFK',
                'iso3166_numeric' => '574',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Norfolkinsel", "en": "Norfolk Island"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'NF',
                'nato_country_code_3' => 'NFK',
                'short_names' => '{"de": "Norfolkinsel", "en": "Norfolk Island"}',
                'telephone_country_code' => '+672',
                'telephone_country_code_extended' => '+672',
                'tld' => '.nf',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 165,
                'active' => 0,
                'area' => 923768,
                'capital_names' => '{"de": "Abuja", "en": "Abuja"}',
                'comments' => null,
                'fips10' => 'NI',
                'ioc' => 'NGR',
                'iso3166_alpha_2' => 'NG',
                'iso3166_alpha_3' => 'NGA',
                'iso3166_numeric' => '566',
                'local_name' => 'Nigeria',
                'locales' => null,
                'long_names' => '{"de": "Bundesrepublik Nigeria", "en": "Federal Republic Of Nigeria"}',
                'nationality_names' => '{"de": "nigerianisch"}',
                'nato_country_code_2' => 'NI',
                'nato_country_code_3' => 'NGA',
                'short_names' => '{"de": "Bundesrepublik Nigeria", "en": "Federal Republic Of Nigeria"}',
                'telephone_country_code' => '+234',
                'telephone_country_code_extended' => '+234',
                'tld' => '.ng',
                'vehicle_registration_code' => 'NGR',
            ],
            [
                'id' => 166,
                'active' => 0,
                'area' => 130730,
                'capital_names' => '{"de": "Managua", "en": "Managua"}',
                'comments' => null,
                'fips10' => 'NU',
                'ioc' => 'NCA',
                'iso3166_alpha_2' => 'NI',
                'iso3166_alpha_3' => 'NIC',
                'iso3166_numeric' => '558',
                'local_name' => 'Nicaragua',
                'locales' => null,
                'long_names' => '{"de": "Republik Nicaragua", "en": "Republic Of Nicaragua"}',
                'nationality_names' => '{"de": "nicaraguanisch"}',
                'nato_country_code_2' => 'NU',
                'nato_country_code_3' => 'NIC',
                'short_names' => '{"de": "Nicaragua", "en": "Nicaragua"}',
                'telephone_country_code' => '+505',
                'telephone_country_code_extended' => '+505',
                'tld' => '.ni',
                'vehicle_registration_code' => 'NIC',
            ],
            [
                'id' => 167,
                'active' => 1,
                'area' => 41543,
                'capital_names' => '{"de": "Amsterdam", "en": "Amsterdam"}',
                'comments' => null,
                'fips10' => 'NL',
                'ioc' => 'NED',
                'iso3166_alpha_2' => 'NL',
                'iso3166_alpha_3' => 'NLD',
                'iso3166_numeric' => '528',
                'local_name' => 'Nederland',
                'locales' => '["nl_NL"]',
                'long_names' => '{"de": "Königreich der Niederlande", "en": "Kingdom Of The Netherlands"}',
                'nationality_names' => '{"de": "niederländisch"}',
                'nato_country_code_2' => 'NL',
                'nato_country_code_3' => 'NLD',
                'short_names' => '{"de": "Niederlande", "en": "Netherlands"}',
                'telephone_country_code' => '+31',
                'telephone_country_code_extended' => '+31',
                'tld' => '.nl',
                'vehicle_registration_code' => 'NL',
            ],
            [
                'id' => 168,
                'active' => 1,
                'area' => 323802,
                'capital_names' => '{"de": "Oslo", "en": "Oslo"}',
                'comments' => null,
                'fips10' => 'NO',
                'ioc' => 'NOR',
                'iso3166_alpha_2' => 'NO',
                'iso3166_alpha_3' => 'NOR',
                'iso3166_numeric' => '578',
                'local_name' => 'Norge (bokmål), Noreg (nynorsk)',
                'locales' => null,
                'long_names' => '{"de": "Königreich Norwegen", "en": "Kingdom Of Norway"}',
                'nationality_names' => '{"de": "norwegisch"}',
                'nato_country_code_2' => 'NO',
                'nato_country_code_3' => 'NOR',
                'short_names' => '{"de": "Norwegen", "en": "Norway"}',
                'telephone_country_code' => '+47',
                'telephone_country_code_extended' => '+47',
                'tld' => '.no',
                'vehicle_registration_code' => 'N',
            ],
            [
                'id' => 169,
                'active' => 0,
                'area' => 147181,
                'capital_names' => '{"de": "Kathmandu", "en": "Kathmandu"}',
                'comments' => null,
                'fips10' => 'NP',
                'ioc' => 'NEP',
                'iso3166_alpha_2' => 'NP',
                'iso3166_alpha_3' => 'NPL',
                'iso3166_numeric' => '524',
                'local_name' => 'Nepal',
                'locales' => null,
                'long_names' => '{"de": "Demokratische Bundesrepublik Nepal", "en": "Federal Democratic Republic Of Nepal"}',
                'nationality_names' => '{"de": "nepalesisch"}',
                'nato_country_code_2' => 'NP',
                'nato_country_code_3' => 'NPL',
                'short_names' => '{"de": "Nepal", "en": "Nepal"}',
                'telephone_country_code' => '+977',
                'telephone_country_code_extended' => '+977',
                'tld' => '.np',
                'vehicle_registration_code' => 'NEP',
            ],
            [
                'id' => 170,
                'active' => 0,
                'area' => 21,
                'capital_names' => '{"de": "Yaren", "en": "Yaren"}',
                'comments' => null,
                'fips10' => 'NR',
                'ioc' => 'NRU',
                'iso3166_alpha_2' => 'NR',
                'iso3166_alpha_3' => 'NRU',
                'iso3166_numeric' => '520',
                'local_name' => 'Nauru',
                'locales' => null,
                'long_names' => '{"de": "Republik Nauru", "en": "Republic Of Nauru"}',
                'nationality_names' => '{"de": "Nauruisch"}',
                'nato_country_code_2' => 'NR',
                'nato_country_code_3' => 'NRU',
                'short_names' => '{"de": "Nauru", "en": "Nauru"}',
                'telephone_country_code' => '+674',
                'telephone_country_code_extended' => '+674',
                'tld' => '.nr',
                'vehicle_registration_code' => 'NAU',
            ],
            [
                'id' => 171,
                'active' => 0,
                'area' => 260,
                'capital_names' => '{"de": "Alofi", "en": "Alofi"}',
                'comments' => null,
                'fips10' => 'NE',
                'ioc' => null,
                'iso3166_alpha_2' => 'NU',
                'iso3166_alpha_3' => 'NIU',
                'iso3166_numeric' => '570',
                'local_name' => 'Niue',
                'locales' => null,
                'long_names' => '{"de": "Niue", "en": "Niue"}',
                'nationality_names' => '{"de": "niueanisch"}',
                'nato_country_code_2' => 'NE',
                'nato_country_code_3' => 'NIU',
                'short_names' => '{"de": "Niue", "en": "Niue"}',
                'telephone_country_code' => '+683',
                'telephone_country_code_extended' => '+683',
                'tld' => '.nu',
                'vehicle_registration_code' => 'NZ',
            ],
            [
                'id' => 172,
                'active' => 0,
                'area' => 267710,
                'capital_names' => '{"de": "Wellington", "en": "Wellington"}',
                'comments' => null,
                'fips10' => 'NZ',
                'ioc' => 'NZL',
                'iso3166_alpha_2' => 'NZ',
                'iso3166_alpha_3' => 'NZL',
                'iso3166_numeric' => '554',
                'local_name' => 'New Zealand (Englisch), Aotearoa (Maorisch)',
                'locales' => null,
                'long_names' => '{"de": "Neuseeland", "en": "New Zealand"}',
                'nationality_names' => '{"de": "neuseeländisch"}',
                'nato_country_code_2' => 'NZ',
                'nato_country_code_3' => 'NZL',
                'short_names' => '{"de": "Neuseeland", "en": "New Zealand"}',
                'telephone_country_code' => '+64',
                'telephone_country_code_extended' => '+64',
                'tld' => '.nz',
                'vehicle_registration_code' => 'NZ',
            ],
            [
                'id' => 173,
                'active' => 0,
                'area' => 309500,
                'capital_names' => '{"de": "Maskat", "en": "Maskat"}',
                'comments' => null,
                'fips10' => 'MU',
                'ioc' => 'OMA',
                'iso3166_alpha_2' => 'OM',
                'iso3166_alpha_3' => 'OMN',
                'iso3166_numeric' => '512',
                'local_name' => 'ʿUmān',
                'locales' => null,
                'long_names' => '{"de": "Sultanat Oman", "en": "Sultanate Of Oman"}',
                'nationality_names' => '{"de": "omanisch"}',
                'nato_country_code_2' => 'MU',
                'nato_country_code_3' => 'OMN',
                'short_names' => '{"de": "Oman", "en": "Oman"}',
                'telephone_country_code' => '+968',
                'telephone_country_code_extended' => '+968',
                'tld' => '.om',
                'vehicle_registration_code' => 'OM',
            ],
            [
                'id' => 174,
                'active' => 0,
                'area' => 75420,
                'capital_names' => '{"de": "Panama-Stadt", "en": "Panama City"}',
                'comments' => null,
                'fips10' => 'PM',
                'ioc' => 'PAN',
                'iso3166_alpha_2' => 'PA',
                'iso3166_alpha_3' => 'PAN',
                'iso3166_numeric' => '591',
                'local_name' => 'Panamá',
                'locales' => null,
                'long_names' => '{"de": "Republik Panama", "en": "Republic Of Panama"}',
                'nationality_names' => '{"de": "panamaisch"}',
                'nato_country_code_2' => 'PM',
                'nato_country_code_3' => 'PAN',
                'short_names' => '{"de": "Panama", "en": "Panama"}',
                'telephone_country_code' => '+507',
                'telephone_country_code_extended' => '+507',
                'tld' => '.pa',
                'vehicle_registration_code' => 'PA',
            ],
            [
                'id' => 175,
                'active' => 0,
                'area' => 1285216,
                'capital_names' => '{"de": "Lima", "en": "Lima"}',
                'comments' => null,
                'fips10' => 'PE',
                'ioc' => 'PER',
                'iso3166_alpha_2' => 'PE',
                'iso3166_alpha_3' => 'PER',
                'iso3166_numeric' => '604',
                'local_name' => 'Perú',
                'locales' => null,
                'long_names' => '{"de": "Republik Peru", "en": "Republic Of Peru"}',
                'nationality_names' => '{"de": "peruanisch"}',
                'nato_country_code_2' => 'PE',
                'nato_country_code_3' => 'PER',
                'short_names' => '{"de": "Peru", "en": "Peru"}',
                'telephone_country_code' => '+51',
                'telephone_country_code_extended' => '+51',
                'tld' => '.pe',
                'vehicle_registration_code' => 'PE',
            ],
            [
                'id' => 176,
                'active' => 0,
                'area' => 4167000,
                'capital_names' => '{"de": "Papeete", "en": "Papeete"}',
                'comments' => null,
                'fips10' => 'FP',
                'ioc' => null,
                'iso3166_alpha_2' => 'PF',
                'iso3166_alpha_3' => 'PYF',
                'iso3166_numeric' => '258',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Französisch-Polynesien", "en": "French Polynesia"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'FP',
                'nato_country_code_3' => 'PYF',
                'short_names' => '{"de": "Französisch-Polynesien", "en": "French Polynesia"}',
                'telephone_country_code' => '+689',
                'telephone_country_code_extended' => '+689',
                'tld' => '.pf',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 177,
                'active' => 0,
                'area' => 462840,
                'capital_names' => '{"de": "Port Moresby", "en": "Port Moresby"}',
                'comments' => null,
                'fips10' => 'PP',
                'ioc' => 'PNG',
                'iso3166_alpha_2' => 'PG',
                'iso3166_alpha_3' => 'PNG',
                'iso3166_numeric' => '598',
                'local_name' => 'Papua Niu Gini',
                'locales' => null,
                'long_names' => '{"de": "Unabhängiger Staat Papua-Neuguinea", "en": "Independent State Of Papua New Guinea"}',
                'nationality_names' => '{"de": "papua-neuguineisch"}',
                'nato_country_code_2' => 'PP',
                'nato_country_code_3' => 'PNG',
                'short_names' => '{"de": "Papua-Neuguinea", "en": "Papua New Guinea"}',
                'telephone_country_code' => '+675',
                'telephone_country_code_extended' => '+675',
                'tld' => '.pg',
                'vehicle_registration_code' => 'PNG',
            ],
            [
                'id' => 178,
                'active' => 0,
                'area' => 299000,
                'capital_names' => '{"de": "Manila", "en": "Manila"}',
                'comments' => null,
                'fips10' => 'RP',
                'ioc' => 'PHI',
                'iso3166_alpha_2' => 'PH',
                'iso3166_alpha_3' => 'PHL',
                'iso3166_numeric' => '608',
                'local_name' => 'Pilipinas',
                'locales' => null,
                'long_names' => '{"de": "Republik der Philippinen", "en": "Republic Of The Philippines"}',
                'nationality_names' => '{"de": "philippinisch"}',
                'nato_country_code_2' => 'RP',
                'nato_country_code_3' => 'PHL',
                'short_names' => '{"de": "Philippinen", "en": "Philippines"}',
                'telephone_country_code' => '+63',
                'telephone_country_code_extended' => '+63',
                'tld' => '.ph',
                'vehicle_registration_code' => 'RP',
            ],
            [
                'id' => 179,
                'active' => 0,
                'area' => 796095,
                'capital_names' => '{"de": "Islamabad", "en": "Islamabad"}',
                'comments' => null,
                'fips10' => 'PK',
                'ioc' => 'PAK',
                'iso3166_alpha_2' => 'PK',
                'iso3166_alpha_3' => 'PAK',
                'iso3166_numeric' => '586',
                'local_name' => 'Pākistān',
                'locales' => null,
                'long_names' => '{"de": "Islamische Republik Pakistan", "en": "Islamic Republic Of Pakistan"}',
                'nationality_names' => '{"de": "pakistanisch"}',
                'nato_country_code_2' => 'PK',
                'nato_country_code_3' => 'PAK',
                'short_names' => '{"de": "Pakistan", "en": "Pakistan"}',
                'telephone_country_code' => '+92',
                'telephone_country_code_extended' => '+92',
                'tld' => '.pk',
                'vehicle_registration_code' => 'PK',
            ],
            [
                'id' => 180,
                'active' => 1,
                'area' => 312685,
                'capital_names' => '{"de": "Warschau", "en": "Warsaw"}',
                'comments' => null,
                'fips10' => 'PL',
                'ioc' => 'POL',
                'iso3166_alpha_2' => 'PL',
                'iso3166_alpha_3' => 'POL',
                'iso3166_numeric' => '616',
                'local_name' => 'Polska',
                'locales' => null,
                'long_names' => '{"de": "Republik Polen", "en": "Republic Of Poland"}',
                'nationality_names' => '{"de": "polnisch"}',
                'nato_country_code_2' => 'PL',
                'nato_country_code_3' => 'POL',
                'short_names' => '{"de": "Polen", "en": "Poland"}',
                'telephone_country_code' => '+48',
                'telephone_country_code_extended' => '+48',
                'tld' => '.pl',
                'vehicle_registration_code' => 'PL',
            ],
            [
                'id' => 181,
                'active' => 0,
                'area' => 237490,
                'capital_names' => '{"de": "Saint-Pierre", "en": "Saint-Pierre"}',
                'comments' => null,
                'fips10' => 'SB',
                'ioc' => null,
                'iso3166_alpha_2' => 'PM',
                'iso3166_alpha_3' => 'SPM',
                'iso3166_numeric' => '666',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Saint-Pierre und Miquelon", "en": "Saint Pierre and Miquelon"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'SB',
                'nato_country_code_3' => 'SPM',
                'short_names' => '{"de": "Saint-Pierre und Miquelon", "en": "Saint Pierre and Miquelon"}',
                'telephone_country_code' => '+508',
                'telephone_country_code_extended' => '+508',
                'tld' => '.pm',
                'vehicle_registration_code' => 'SPM',
            ],
            [
                'id' => 182,
                'active' => 0,
                'area' => 9104000,
                'capital_names' => '{"de": "San Juan", "en": "San Juan"}',
                'comments' => null,
                'fips10' => 'RQ',
                'ioc' => 'PUR',
                'iso3166_alpha_2' => 'PR',
                'iso3166_alpha_3' => 'PRI',
                'iso3166_numeric' => '630',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Puerto Rico", "en": "Puerto Rico"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'RQ',
                'nato_country_code_3' => 'PRI',
                'short_names' => '{"de": "Puerto Rico", "en": "Puerto Rico"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1787',
                'tld' => '.pr',
                'vehicle_registration_code' => 'PRI',
            ],
            [
                'id' => 183,
                'active' => 0,
                'area' => 6220,
                'capital_names' => '{"de": "Ramallah", "en": "Ramallah"}',
                'comments' => null,
                'fips10' => 'gz',
                'ioc' => 'PLE',
                'iso3166_alpha_2' => 'PS',
                'iso3166_alpha_3' => 'PSE',
                'iso3166_numeric' => '275',
                'local_name' => 'Dawlat Filastīn',
                'locales' => null,
                'long_names' => '{"de": "Palästina", "en": "Palestine"}',
                'nationality_names' => '{"de": "palästinensisch"}',
                'nato_country_code_2' => 'PS',
                'nato_country_code_3' => 'PSE',
                'short_names' => '{"de": "Palästina", "en": "Palestine"}',
                'telephone_country_code' => '+970',
                'telephone_country_code_extended' => '+970',
                'tld' => '.ps',
                'vehicle_registration_code' => 'WB',
            ],
            [
                'id' => 184,
                'active' => 1,
                'area' => 92090,
                'capital_names' => '{"de": "Lissabon", "en": "Lisbon"}',
                'comments' => null,
                'fips10' => 'PO',
                'ioc' => 'POR',
                'iso3166_alpha_2' => 'PT',
                'iso3166_alpha_3' => 'PRT',
                'iso3166_numeric' => '620',
                'local_name' => 'Portugal',
                'locales' => null,
                'long_names' => '{"de": "Portugiesische Republik", "en": "Portuguese Republic"}',
                'nationality_names' => '{"de": "portugiesisch"}',
                'nato_country_code_2' => 'PO',
                'nato_country_code_3' => 'PRT',
                'short_names' => '{"de": "Portugal", "en": "Portugal"}',
                'telephone_country_code' => '+351',
                'telephone_country_code_extended' => '+351',
                'tld' => '.pt',
                'vehicle_registration_code' => 'P',
            ],
            [
                'id' => 185,
                'active' => 0,
                'area' => 459,
                'capital_names' => '{"de": "Melekeok", "en": "Melekeok"}',
                'comments' => null,
                'fips10' => 'PS',
                'ioc' => 'PLW',
                'iso3166_alpha_2' => 'PW',
                'iso3166_alpha_3' => 'PLW',
                'iso3166_numeric' => '585',
                'local_name' => 'Belau',
                'locales' => null,
                'long_names' => '{"de": "Republik Palau", "en": "Republic Of Palau"}',
                'nationality_names' => '{"de": "palauisch"}',
                'nato_country_code_2' => 'PS',
                'nato_country_code_3' => 'PLW',
                'short_names' => '{"de": "Palau", "en": "Palau"}',
                'telephone_country_code' => '+680',
                'telephone_country_code_extended' => '+680',
                'tld' => '.pw',
                'vehicle_registration_code' => 'PAL',
            ],
            [
                'id' => 186,
                'active' => 0,
                'area' => 406752,
                'capital_names' => '{"de": "Asunción", "en": "Asunción"}',
                'comments' => null,
                'fips10' => 'PA',
                'ioc' => 'PAR',
                'iso3166_alpha_2' => 'PY',
                'iso3166_alpha_3' => 'PRY',
                'iso3166_numeric' => '600',
                'local_name' => 'Paraguay (spanisch), Paraguái (Guaraní)',
                'locales' => null,
                'long_names' => '{"de": "Republik Paraguay", "en": "Republic Of Paraguay"}',
                'nationality_names' => '{"de": "paraguayanisch"}',
                'nato_country_code_2' => 'PA',
                'nato_country_code_3' => 'PRY',
                'short_names' => '{"de": "Paraguay", "en": "Paraguay"}',
                'telephone_country_code' => '+595',
                'telephone_country_code_extended' => '+595',
                'tld' => '.py',
                'vehicle_registration_code' => 'PY',
            ],
            [
                'id' => 187,
                'active' => 0,
                'area' => 11586,
                'capital_names' => '{"de": "Doha", "en": "Doha"}',
                'comments' => null,
                'fips10' => 'QA',
                'ioc' => 'QAT',
                'iso3166_alpha_2' => 'QA',
                'iso3166_alpha_3' => 'QAT',
                'iso3166_numeric' => '634',
                'local_name' => 'Dawlat Qatar',
                'locales' => null,
                'long_names' => '{"de": "Staat Katar", "en": "State Of Qatar"}',
                'nationality_names' => '{"de": "katarisch"}',
                'nato_country_code_2' => 'QA',
                'nato_country_code_3' => 'QAT',
                'short_names' => '{"de": "Katar", "en": "Qatar"}',
                'telephone_country_code' => '+974',
                'telephone_country_code_extended' => '+974',
                'tld' => '.qa',
                'vehicle_registration_code' => 'Q',
            ],
            [
                'id' => 188,
                'active' => 0,
                'area' => 2503080,
                'capital_names' => '{"de": "Saint-Denis", "en": "Saint-Denis"}',
                'comments' => null,
                'fips10' => 'RE',
                'ioc' => null,
                'iso3166_alpha_2' => 'RE',
                'iso3166_alpha_3' => 'REU',
                'iso3166_numeric' => '638',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Réunion", "en": "Réunion"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'RE',
                'nato_country_code_3' => 'REU',
                'short_names' => '{"de": "Réunion", "en": "Réunion"}',
                'telephone_country_code' => '+262',
                'telephone_country_code_extended' => '+262',
                'tld' => '.re',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 189,
                'active' => 1,
                'area' => 238391,
                'capital_names' => '{"de": "Bukarest", "en": "Bucharest"}',
                'comments' => null,
                'fips10' => 'RO',
                'ioc' => 'ROU',
                'iso3166_alpha_2' => 'RO',
                'iso3166_alpha_3' => 'ROU',
                'iso3166_numeric' => '642',
                'local_name' => 'România',
                'locales' => null,
                'long_names' => '{"de": "Rumänien", "en": "Romania"}',
                'nationality_names' => '{"de": "rumänisch"}',
                'nato_country_code_2' => 'RO',
                'nato_country_code_3' => 'ROU',
                'short_names' => '{"de": "Rumänien", "en": "Romania"}',
                'telephone_country_code' => '+40',
                'telephone_country_code_extended' => '+40',
                'tld' => '.ro',
                'vehicle_registration_code' => 'RO',
            ],
            [
                'id' => 190,
                'active' => 1,
                'area' => 77474,
                'capital_names' => '{"de": "Belgrad", "en": "Belgrade"}',
                'comments' => null,
                'fips10' => 'RI',
                'ioc' => 'SRB',
                'iso3166_alpha_2' => 'RS',
                'iso3166_alpha_3' => 'SRB',
                'iso3166_numeric' => '688',
                'local_name' => 'Srbija',
                'locales' => null,
                'long_names' => '{"de": "Republik Serbien", "en": "Republic Of Serbia"}',
                'nationality_names' => '{"de": "serbisch"}',
                'nato_country_code_2' => null,
                'nato_country_code_3' => 'SCG',
                'short_names' => '{"de": "Serbien", "en": "Serbia"}',
                'telephone_country_code' => '+381',
                'telephone_country_code_extended' => '+381',
                'tld' => '.rs',
                'vehicle_registration_code' => 'SRB',
            ],
            [
                'id' => 191,
                'active' => 1,
                'area' => 17098242,
                'capital_names' => '{"de": "Moskau", "en": "Moscow"}',
                'comments' => null,
                'fips10' => 'RS',
                'ioc' => 'RUS',
                'iso3166_alpha_2' => 'RU',
                'iso3166_alpha_3' => 'RUS',
                'iso3166_numeric' => '643',
                'local_name' => 'Rossija oder Rossijskaja Federacija',
                'locales' => null,
                'long_names' => '{"de": "Russische Föderation", "en": "Russian Federation"}',
                'nationality_names' => '{"de": "russisch"}',
                'nato_country_code_2' => null,
                'nato_country_code_3' => null,
                'short_names' => '{"de": "Russland", "en": "Russia"}',
                'telephone_country_code' => '+7',
                'telephone_country_code_extended' => '+7',
                'tld' => '.ru',
                'vehicle_registration_code' => 'RUS',
            ],
            [
                'id' => 192,
                'active' => 0,
                'area' => 26338,
                'capital_names' => '{"de": "Kigali", "en": "Kigali"}',
                'comments' => null,
                'fips10' => 'RW',
                'ioc' => 'RWA',
                'iso3166_alpha_2' => 'RW',
                'iso3166_alpha_3' => 'RWA',
                'iso3166_numeric' => '646',
                'local_name' => 'Rwanda',
                'locales' => null,
                'long_names' => '{"de": "Republik Ruanda", "en": "Republic Of Rwanda"}',
                'nationality_names' => '{"de": "ruandisch"}',
                'nato_country_code_2' => 'RW',
                'nato_country_code_3' => 'RWA',
                'short_names' => '{"de": "Ruanda", "en": "Rwanda"}',
                'telephone_country_code' => '+250',
                'telephone_country_code_extended' => '+250',
                'tld' => '.rw',
                'vehicle_registration_code' => 'RWA',
            ],
            [
                'id' => 193,
                'active' => 0,
                'area' => 2149690,
                'capital_names' => '{"de": "Riad", "en": "Riad"}',
                'comments' => null,
                'fips10' => 'SA',
                'ioc' => 'KSA',
                'iso3166_alpha_2' => 'SA',
                'iso3166_alpha_3' => 'SAU',
                'iso3166_numeric' => '682',
                'local_name' => 'al-ʿArabīya as-Saʿudīya',
                'locales' => null,
                'long_names' => '{"de": "Königreich Saudi-Arabien", "en": "Kingdom Of Saudi Arabia"}',
                'nationality_names' => '{"de": "saudi-arabisch"}',
                'nato_country_code_2' => 'SA',
                'nato_country_code_3' => 'SAU',
                'short_names' => '{"de": "Saudi-Arabien", "en": "Saudi Arabia"}',
                'telephone_country_code' => '+966',
                'telephone_country_code_extended' => '+966',
                'tld' => '.sa',
                'vehicle_registration_code' => 'KSA',
            ],
            [
                'id' => 194,
                'active' => 0,
                'area' => 28896,
                'capital_names' => '{"de": "Honiara", "en": "Honiara"}',
                'comments' => null,
                'fips10' => 'BP',
                'ioc' => 'SOL',
                'iso3166_alpha_2' => 'SB',
                'iso3166_alpha_3' => 'SLB',
                'iso3166_numeric' => '090',
                'local_name' => 'Solomon Islands',
                'locales' => null,
                'long_names' => '{"de": "Salomonen", "en": "Solomon Islands"}',
                'nationality_names' => '{"de": "salomonisch"}',
                'nato_country_code_2' => 'BP',
                'nato_country_code_3' => 'SLB',
                'short_names' => '{"de": "Salomonen", "en": "Solomon Islands"}',
                'telephone_country_code' => '+677',
                'telephone_country_code_extended' => '+677',
                'tld' => '.sb',
                'vehicle_registration_code' => 'SOL',
            ],
            [
                'id' => 195,
                'active' => 0,
                'area' => 455,
                'capital_names' => '{"de": "Victoria", "en": "Victoria"}',
                'comments' => null,
                'fips10' => 'SE',
                'ioc' => 'SEY',
                'iso3166_alpha_2' => 'SC',
                'iso3166_alpha_3' => 'SYC',
                'iso3166_numeric' => '690',
                'local_name' => 'Seychelles',
                'locales' => null,
                'long_names' => '{"de": "Republik Seychellen", "en": "Republic Of Seychelles"}',
                'nationality_names' => '{"de": "seychellig"}',
                'nato_country_code_2' => 'SC',
                'nato_country_code_3' => 'SYC',
                'short_names' => '{"de": "Seychellen", "en": "Seychelles"}',
                'telephone_country_code' => '+248',
                'telephone_country_code_extended' => '+248',
                'tld' => '.sc',
                'vehicle_registration_code' => 'SY',
            ],
            [
                'id' => 196,
                'active' => 0,
                'area' => 1886068,
                'capital_names' => '{"de": "Khartum", "en": "Khartoum"}',
                'comments' => null,
                'fips10' => 'SU',
                'ioc' => 'SUD',
                'iso3166_alpha_2' => 'SD',
                'iso3166_alpha_3' => 'SDN',
                'iso3166_numeric' => '729',
                'local_name' => 'as-Sūdān',
                'locales' => null,
                'long_names' => '{"de": "Republik Sudan", "en": "Republic Of The Sudan"}',
                'nationality_names' => '{"de": "sudanesisch"}',
                'nato_country_code_2' => 'SU',
                'nato_country_code_3' => 'SDN',
                'short_names' => '{"de": "Sudan", "en": "Sudan"}',
                'telephone_country_code' => '+249',
                'telephone_country_code_extended' => '+249',
                'tld' => '.sd',
                'vehicle_registration_code' => 'SUD',
            ],
            [
                'id' => 197,
                'active' => 1,
                'area' => 450295,
                'capital_names' => '{"de": "Stockholm", "en": "Stockholm"}',
                'comments' => null,
                'fips10' => 'SW',
                'ioc' => 'SWE',
                'iso3166_alpha_2' => 'SE',
                'iso3166_alpha_3' => 'SWE',
                'iso3166_numeric' => '752',
                'local_name' => 'Sverige',
                'locales' => null,
                'long_names' => '{"de": "Königreich Schweden", "en": "Kingdom Of Sweden"}',
                'nationality_names' => '{"de": "schwedisch"}',
                'nato_country_code_2' => 'SE',
                'nato_country_code_3' => 'SWE',
                'short_names' => '{"de": "Schweden", "en": "Sweden"}',
                'telephone_country_code' => '+46',
                'telephone_country_code_extended' => '+46',
                'tld' => '.se',
                'vehicle_registration_code' => 'S',
            ],
            [
                'id' => 198,
                'active' => 0,
                'area' => 697000,
                'capital_names' => '{"de": "Singapur", "en": "Stockholm"}',
                'comments' => null,
                'fips10' => 'SN',
                'ioc' => 'SIN',
                'iso3166_alpha_2' => 'SG',
                'iso3166_alpha_3' => 'SGP',
                'iso3166_numeric' => '702',
                'local_name' => 'Singapore',
                'locales' => null,
                'long_names' => '{"de": "Republik Singapur", "en": "Republic Of Singapore"}',
                'nationality_names' => '{"de": "singapurianisch"}',
                'nato_country_code_2' => 'SN',
                'nato_country_code_3' => 'SGP',
                'short_names' => '{"de": "Singapur", "en": "Singapore"}',
                'telephone_country_code' => '+65',
                'telephone_country_code_extended' => '+65',
                'tld' => '.sg',
                'vehicle_registration_code' => 'SGP',
            ],
            [
                'id' => 199,
                'active' => 0,
                'area' => 391000,
                'capital_names' => '{"de": "Jamestown", "en": "Jamestown"}',
                'comments' => null,
                'fips10' => 'SH',
                'ioc' => null,
                'iso3166_alpha_2' => 'SH',
                'iso3166_alpha_3' => 'SHN',
                'iso3166_numeric' => '654',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "St. Helena, Ascension und Tristan da Cunha", "en": "Saint Helena, Ascension and Tristan da Cunha"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'SH',
                'nato_country_code_3' => 'SHN',
                'short_names' => '{"de": "St. Helena, Ascension und Tristan da Cunha", "en": "Saint Helena, Ascension and Tristan da Cunha"}',
                'telephone_country_code' => '+290',
                'telephone_country_code_extended' => '+290',
                'tld' => '.sh',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 200,
                'active' => 1,
                'area' => 20273,
                'capital_names' => '{"de": "Ljubljana", "en": "Ljubljana"}',
                'comments' => null,
                'fips10' => 'SI',
                'ioc' => 'SLO',
                'iso3166_alpha_2' => 'SI',
                'iso3166_alpha_3' => 'SVN',
                'iso3166_numeric' => '705',
                'local_name' => 'Slovenija',
                'locales' => null,
                'long_names' => '{"de": "Republik Slowenien", "en": "Republic Of Slovenia"}',
                'nationality_names' => '{"de": "slowenisch"}',
                'nato_country_code_2' => 'SI',
                'nato_country_code_3' => 'SVN',
                'short_names' => '{"de": "Slowenien", "en": "Slovenia"}',
                'telephone_country_code' => '+386',
                'telephone_country_code_extended' => '+386',
                'tld' => '.si',
                'vehicle_registration_code' => 'SLO',
            ],
            [
                'id' => 201,
                'active' => 0,
                'area' => null,
                'capital_names' => '{"de": ""}',
                'comments' => null,
                'fips10' => 'SV',
                'ioc' => null,
                'iso3166_alpha_2' => 'SJ',
                'iso3166_alpha_3' => 'SJM',
                'iso3166_numeric' => '744',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Spitzbergen und Jan Mayen", "en": "Svalbard and Jan Mayen"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'SV',
                'nato_country_code_3' => 'SJM',
                'short_names' => '{"de": "Spitzbergen und Jan Mayen", "en": "Svalbard and Jan Mayen"}',
                'telephone_country_code' => '+47',
                'telephone_country_code_extended' => '+47',
                'tld' => '.sj',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 202,
                'active' => 1,
                'area' => 49035,
                'capital_names' => '{"de": "Bratislava (Pressburg)", "en": "Bratislava"}',
                'comments' => null,
                'fips10' => 'LO',
                'ioc' => 'SVK',
                'iso3166_alpha_2' => 'SK',
                'iso3166_alpha_3' => 'SVK',
                'iso3166_numeric' => '703',
                'local_name' => 'Slovensko',
                'locales' => null,
                'long_names' => '{"de": "Slowakische Republik", "en": "Slovak Republic"}',
                'nationality_names' => '{"de": "slowakisch"}',
                'nato_country_code_2' => 'LO',
                'nato_country_code_3' => 'SVK',
                'short_names' => '{"de": "Slowakei", "en": "Slovakia"}',
                'telephone_country_code' => '+421',
                'telephone_country_code_extended' => '+421',
                'tld' => '.sk',
                'vehicle_registration_code' => 'SK',
            ],
            [
                'id' => 203,
                'active' => 0,
                'area' => 71740,
                'capital_names' => '{"de": "Freetown", "en": "Freetown"}',
                'comments' => null,
                'fips10' => 'SL',
                'ioc' => 'SLE',
                'iso3166_alpha_2' => 'SL',
                'iso3166_alpha_3' => 'SLE',
                'iso3166_numeric' => '694',
                'local_name' => 'Sierra Leone',
                'locales' => null,
                'long_names' => '{"de": "Republik Sierra Leone", "en": "Republic Of Sierra Leone"}',
                'nationality_names' => '{"de": "sierra-leonisch"}',
                'nato_country_code_2' => 'SL',
                'nato_country_code_3' => 'SLE',
                'short_names' => '{"de": "Sierra Leone", "en": "Sierra Leone"}',
                'telephone_country_code' => '+232',
                'telephone_country_code_extended' => '+232',
                'tld' => '.sl',
                'vehicle_registration_code' => 'WAL',
            ],
            [
                'id' => 204,
                'active' => 1,
                'area' => 61000,
                'capital_names' => '{"de": "San Marino", "en": "San Marino"}',
                'comments' => null,
                'fips10' => 'SM',
                'ioc' => 'SMR',
                'iso3166_alpha_2' => 'SM',
                'iso3166_alpha_3' => 'SMR',
                'iso3166_numeric' => '674',
                'local_name' => 'San Marino',
                'locales' => null,
                'long_names' => '{"de": "Republik San Marino", "en": "Republic Of San Marino"}',
                'nationality_names' => '{"de": "sanmarinesisch"}',
                'nato_country_code_2' => 'SM',
                'nato_country_code_3' => 'SMR',
                'short_names' => '{"de": "San Marino", "en": "San Marino"}',
                'telephone_country_code' => '+378',
                'telephone_country_code_extended' => '+378',
                'tld' => '.sm',
                'vehicle_registration_code' => 'RSM',
            ],
            [
                'id' => 205,
                'active' => 0,
                'area' => 196722,
                'capital_names' => '{"de": "Dakar", "en": "Dakar"}',
                'comments' => null,
                'fips10' => 'SG',
                'ioc' => 'SEN',
                'iso3166_alpha_2' => 'SN',
                'iso3166_alpha_3' => 'SEN',
                'iso3166_numeric' => '686',
                'local_name' => 'Sénégal',
                'locales' => null,
                'long_names' => '{"de": "Republik Senegal", "en": "Republic Of Senegal"}',
                'nationality_names' => '{"de": "senegalesisch"}',
                'nato_country_code_2' => 'SG',
                'nato_country_code_3' => 'SEN',
                'short_names' => '{"de": "Senegal", "en": "Senegal"}',
                'telephone_country_code' => '+221',
                'telephone_country_code_extended' => '+221',
                'tld' => '.sn',
                'vehicle_registration_code' => 'SN',
            ],
            [
                'id' => 206,
                'active' => 0,
                'area' => 637657,
                'capital_names' => '{"de": "Mogadischu", "en": "Mogadishu"}',
                'comments' => null,
                'fips10' => 'SO',
                'ioc' => 'SOM',
                'iso3166_alpha_2' => 'SO',
                'iso3166_alpha_3' => 'SOM',
                'iso3166_numeric' => '706',
                'local_name' => 'Soomaaliya (Somali), as-Sūmāl (arabisch)',
                'locales' => null,
                'long_names' => '{"de": "Bundesrepublik Somalia", "en": "Somalia"}',
                'nationality_names' => '{"de": "somalisch"}',
                'nato_country_code_2' => 'SO',
                'nato_country_code_3' => 'SOM',
                'short_names' => '{"de": "Somalia", "en": "Somalia"}',
                'telephone_country_code' => '+252',
                'telephone_country_code_extended' => '+252',
                'tld' => '.so',
                'vehicle_registration_code' => 'SO',
            ],
            [
                'id' => 207,
                'active' => 0,
                'area' => 163820,
                'capital_names' => '{"de": "Paramaribo", "en": "Paramaribo"}',
                'comments' => null,
                'fips10' => 'NS',
                'ioc' => 'SUR',
                'iso3166_alpha_2' => 'SR',
                'iso3166_alpha_3' => 'SUR',
                'iso3166_numeric' => '740',
                'local_name' => 'Suriname',
                'locales' => null,
                'long_names' => '{"de": "Republik Suriname", "en": "Republic Of Suriname"}',
                'nationality_names' => '{"de": "surinamisch"}',
                'nato_country_code_2' => 'NS',
                'nato_country_code_3' => 'SUR',
                'short_names' => '{"de": "Suriname", "en": "Suriname"}',
                'telephone_country_code' => '+597',
                'telephone_country_code_extended' => '+597',
                'tld' => '.sr',
                'vehicle_registration_code' => 'SME',
            ],
            [
                'id' => 208,
                'active' => 0,
                'area' => 619745,
                'capital_names' => '{"de": "Juba", "en": "Juba"}',
                'comments' => null,
                'fips10' => 'OD',
                'ioc' => null,
                'iso3166_alpha_2' => 'SS',
                'iso3166_alpha_3' => 'SSD',
                'iso3166_numeric' => '728',
                'local_name' => 'South Sudan',
                'locales' => null,
                'long_names' => '{"de": "Republik Südsudan", "en": "Republic Of South Sudan"}',
                'nationality_names' => '{"de": "südsudanesisch"}',
                'nato_country_code_2' => 'SS',
                'nato_country_code_3' => 'SSD',
                'short_names' => '{"de": "Südsudan", "en": "South Sudan"}',
                'telephone_country_code' => '+211',
                'telephone_country_code_extended' => '+211',
                'tld' => '.ss',
                'vehicle_registration_code' => 'SSD',
            ],
            [
                'id' => 209,
                'active' => 0,
                'area' => 964,
                'capital_names' => '{"de": "São Tomé", "en": "São Tomé"}',
                'comments' => null,
                'fips10' => 'TP',
                'ioc' => 'STP',
                'iso3166_alpha_2' => 'ST',
                'iso3166_alpha_3' => 'STP',
                'iso3166_numeric' => '678',
                'local_name' => 'São Tomé e Príncipe',
                'locales' => null,
                'long_names' => '{"de": "Demokratische Republik São Tomé und Príncipe", "en": "Democratic Republic Of Sao Tome And Principe"}',
                'nationality_names' => '{"de": "santomeisch"}',
                'nato_country_code_2' => 'TP',
                'nato_country_code_3' => 'STP',
                'short_names' => '{"de": "São Tomé und Príncipe", "en": "Sao Tome And Principe"}',
                'telephone_country_code' => '+239',
                'telephone_country_code_extended' => '+239',
                'tld' => '.st',
                'vehicle_registration_code' => 'STP',
            ],
            [
                'id' => 210,
                'active' => 0,
                'area' => 21041,
                'capital_names' => '{"de": "San Salvador", "en": "San Salvador"}',
                'comments' => null,
                'fips10' => 'ES',
                'ioc' => 'ESA',
                'iso3166_alpha_2' => 'SV',
                'iso3166_alpha_3' => 'SLV',
                'iso3166_numeric' => '222',
                'local_name' => 'El Salvador',
                'locales' => null,
                'long_names' => '{"de": "Republik El Salvador", "en": "Republic Of El Salvador"}',
                'nationality_names' => '{"de": "el-salvadorianisch"}',
                'nato_country_code_2' => 'ES',
                'nato_country_code_3' => 'SLV',
                'short_names' => '{"de": "El Salvador", "en": "El Salvador"}',
                'telephone_country_code' => '+503',
                'telephone_country_code_extended' => '+503',
                'tld' => '.sv',
                'vehicle_registration_code' => 'ES',
            ],
            [
                'id' => 211,
                'active' => 0,
                'area' => 34000,
                'capital_names' => '{"de": "Philipsburg", "en": "Philipsburg"}',
                'comments' => null,
                'fips10' => null,
                'ioc' => null,
                'iso3166_alpha_2' => 'SX',
                'iso3166_alpha_3' => 'SXM',
                'iso3166_numeric' => '534',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Sint Maarten", "en": "Sint Maarten"}',
                'nationality_names' => null,
                'nato_country_code_2' => null,
                'nato_country_code_3' => null,
                'short_names' => '{"de": "Sint Maarten", "en": "Sint Maarten"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1721',
                'tld' => '.sx',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 212,
                'active' => 0,
                'area' => 185180,
                'capital_names' => '{"de": "Damaskus", "en": "Damaskus"}',
                'comments' => null,
                'fips10' => 'SY',
                'ioc' => 'SYR',
                'iso3166_alpha_2' => 'SY',
                'iso3166_alpha_3' => 'SYR',
                'iso3166_numeric' => '760',
                'local_name' => 'Sūriyā',
                'locales' => null,
                'long_names' => '{"de": "Arabische Republik Syrien", "en": "Syrian Arab Republic"}',
                'nationality_names' => '{"de": "syrisch"}',
                'nato_country_code_2' => 'SY',
                'nato_country_code_3' => 'SYR',
                'short_names' => '{"de": "Syrien", "en": "Syria"}',
                'telephone_country_code' => '+963',
                'telephone_country_code_extended' => '+963',
                'tld' => '.sy',
                'vehicle_registration_code' => 'SYR',
            ],
            [
                'id' => 213,
                'active' => 0,
                'area' => 17364,
                'capital_names' => '{"de": "Mbabane", "en": "Mbabane"}',
                'comments' => null,
                'fips10' => 'WZ',
                'ioc' => 'SWZ',
                'iso3166_alpha_2' => 'SZ',
                'iso3166_alpha_3' => 'SWZ',
                'iso3166_numeric' => '748',
                'local_name' => 'Swaziland',
                'locales' => null,
                'long_names' => '{"de": "Königreich Swasiland", "en": "Kingdom Of Swaziland"}',
                'nationality_names' => '{"de": "swasisch"}',
                'nato_country_code_2' => 'WZ',
                'nato_country_code_3' => 'SWZ',
                'short_names' => '{"de": "Swasiland", "en": "Swaziland"}',
                'telephone_country_code' => '+268',
                'telephone_country_code_extended' => '+268',
                'tld' => '.sz',
                'vehicle_registration_code' => 'SD',
            ],
            [
                'id' => 214,
                'active' => 0,
                'area' => 616300,
                'capital_names' => '{"de": "Cockburn Town", "en": "Cockburn Town"}',
                'comments' => null,
                'fips10' => 'TK',
                'ioc' => null,
                'iso3166_alpha_2' => 'TC',
                'iso3166_alpha_3' => 'TCA',
                'iso3166_numeric' => '796',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Turks- und Caicosinseln", "en": "Turks and Caicos Islands"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'TK',
                'nato_country_code_3' => 'TCA',
                'short_names' => '{"de": "Turks- und Caicosinseln", "en": "Turks and Caicos Islands"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1649',
                'tld' => '.tc',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 215,
                'active' => 0,
                'area' => 1284000,
                'capital_names' => '{"de": "N’Djamena", "en": "N’Djamena"}',
                'comments' => null,
                'fips10' => 'CD',
                'ioc' => 'CHA',
                'iso3166_alpha_2' => 'TD',
                'iso3166_alpha_3' => 'TCD',
                'iso3166_numeric' => '148',
                'local_name' => 'Tchad',
                'locales' => null,
                'long_names' => '{"de": "Republik Tschad", "en": "Republic Of Chad"}',
                'nationality_names' => '{"de": "tschadisch"}',
                'nato_country_code_2' => 'CD',
                'nato_country_code_3' => 'TCD',
                'short_names' => '{"de": "Tschad", "en": "Chad"}',
                'telephone_country_code' => '+235',
                'telephone_country_code_extended' => '+235',
                'tld' => '.td',
                'vehicle_registration_code' => 'TD',
            ],
            [
                'id' => 216,
                'active' => 0,
                'area' => null,
                'capital_names' => '{"de": ""}',
                'comments' => null,
                'fips10' => 'FS',
                'ioc' => null,
                'iso3166_alpha_2' => 'TF',
                'iso3166_alpha_3' => 'ATF',
                'iso3166_numeric' => '260',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Französische Süd- und Antarktisgebiete", "en": "French Southern and Antarctic Lands"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'FS',
                'nato_country_code_3' => null,
                'short_names' => '{"de": "Französische Süd- und Antarktisgebiete", "en": "French Southern and Antarctic Lands"}',
                'telephone_country_code' => '+262',
                'telephone_country_code_extended' => '+262',
                'tld' => '.tf',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 217,
                'active' => 0,
                'area' => 56785,
                'capital_names' => '{"de": "Lomé", "en": "Lomé"}',
                'comments' => null,
                'fips10' => 'TO',
                'ioc' => 'TOG',
                'iso3166_alpha_2' => 'TG',
                'iso3166_alpha_3' => 'TGO',
                'iso3166_numeric' => '768',
                'local_name' => 'Togo',
                'locales' => null,
                'long_names' => '{"de": "Republik Togo", "en": "Togolese Republic"}',
                'nationality_names' => '{"de": "togoisch"}',
                'nato_country_code_2' => 'TO',
                'nato_country_code_3' => 'TGO',
                'short_names' => '{"de": "Togo", "en": "Togo"}',
                'telephone_country_code' => '+228',
                'telephone_country_code_extended' => '+228',
                'tld' => '.tg',
                'vehicle_registration_code' => 'TG',
            ],
            [
                'id' => 218,
                'active' => 0,
                'area' => 513120,
                'capital_names' => '{"de": "Bangkok", "en": "Bangkok"}',
                'comments' => null,
                'fips10' => 'TH',
                'ioc' => 'THA',
                'iso3166_alpha_2' => 'TH',
                'iso3166_alpha_3' => 'THA',
                'iso3166_numeric' => '764',
                'local_name' => 'Prathet Thai',
                'locales' => null,
                'long_names' => '{"de": "Königreich Thailand", "en": "Kingdom Of Thailand"}',
                'nationality_names' => '{"de": "thailändisch"}',
                'nato_country_code_2' => 'TH',
                'nato_country_code_3' => 'THA',
                'short_names' => '{"de": "Thailand", "en": "Thailand"}',
                'telephone_country_code' => '+66',
                'telephone_country_code_extended' => '+66',
                'tld' => '.th',
                'vehicle_registration_code' => 'T',
            ],
            [
                'id' => 219,
                'active' => 0,
                'area' => 143100,
                'capital_names' => '{"de": "Duschanbe", "en": "Dushanbe"}',
                'comments' => null,
                'fips10' => 'TI',
                'ioc' => 'TJK',
                'iso3166_alpha_2' => 'TJ',
                'iso3166_alpha_3' => 'TJK',
                'iso3166_numeric' => '762',
                'local_name' => 'Todschikiston',
                'locales' => null,
                'long_names' => '{"de": "Republik Tadschikistan", "en": "Republic Of Tajikistan"}',
                'nationality_names' => '{"de": "tadschikisch"}',
                'nato_country_code_2' => 'TI',
                'nato_country_code_3' => 'TJK',
                'short_names' => '{"de": "Tadschikistan", "en": "Tajikistan"}',
                'telephone_country_code' => '+992',
                'telephone_country_code_extended' => '+992',
                'tld' => '.tj',
                'vehicle_registration_code' => 'TJ',
            ],
            [
                'id' => 220,
                'active' => 0,
                'area' => 12200,
                'capital_names' => '{"de": "Atafu", "en": "Atafu"}',
                'comments' => null,
                'fips10' => 'TL',
                'ioc' => null,
                'iso3166_alpha_2' => 'TK',
                'iso3166_alpha_3' => 'TKL',
                'iso3166_numeric' => '772',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Tokelau", "en": "Tokelau"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'TL',
                'nato_country_code_3' => 'TKL',
                'short_names' => '{"de": "Tokelau", "en": "Tokelau"}',
                'telephone_country_code' => '+690',
                'telephone_country_code_extended' => '+690',
                'tld' => '.tk',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 221,
                'active' => 0,
                'area' => 14874,
                'capital_names' => '{"de": "Dili", "en": "Dili"}',
                'comments' => null,
                'fips10' => 'TT',
                'ioc' => 'TLS',
                'iso3166_alpha_2' => 'TL',
                'iso3166_alpha_3' => 'TLS',
                'iso3166_numeric' => '626',
                'local_name' => 'Timor-Leste',
                'locales' => null,
                'long_names' => '{"de": "Demokratische Republik Timor-Leste", "en": "Democratic Republic Of Timor-Leste"}',
                'nationality_names' => '{"de": "osttimorisch"}',
                'nato_country_code_2' => 'TM',
                'nato_country_code_3' => 'TLS',
                'short_names' => '{"de": "Osttimor", "en": "Timor-Leste"}',
                'telephone_country_code' => '+670',
                'telephone_country_code_extended' => '+670',
                'tld' => '.tl',
                'vehicle_registration_code' => 'TL',
            ],
            [
                'id' => 222,
                'active' => 0,
                'area' => 488100,
                'capital_names' => '{"de": "Aschgabad", "en": "Ashgabat"}',
                'comments' => null,
                'fips10' => 'TX',
                'ioc' => 'TKM',
                'iso3166_alpha_2' => 'TM',
                'iso3166_alpha_3' => 'TKM',
                'iso3166_numeric' => '795',
                'local_name' => 'Türkmenistan',
                'locales' => null,
                'long_names' => '{"de": "Turkmenistan", "en": "Turkmenistan"}',
                'nationality_names' => '{"de": "turkmenisch"}',
                'nato_country_code_2' => 'TX',
                'nato_country_code_3' => 'TKM',
                'short_names' => '{"de": "Turkmenistan", "en": "Turkmenistan"}',
                'telephone_country_code' => '+993',
                'telephone_country_code_extended' => '+993',
                'tld' => '.tm',
                'vehicle_registration_code' => 'TM',
            ],
            [
                'id' => 223,
                'active' => 0,
                'area' => 163610,
                'capital_names' => '{"de": "Tunis", "en": "Tunis"}',
                'comments' => null,
                'fips10' => 'TS',
                'ioc' => 'TUN',
                'iso3166_alpha_2' => 'TN',
                'iso3166_alpha_3' => 'TUN',
                'iso3166_numeric' => '788',
                'local_name' => 'Tunis',
                'locales' => null,
                'long_names' => '{"de": "Tunesische Republik", "en": "Tunisian Republic"}',
                'nationality_names' => '{"de": "tunesisch"}',
                'nato_country_code_2' => 'TS',
                'nato_country_code_3' => 'TUN',
                'short_names' => '{"de": "Tunesien", "en": "Tunisia"}',
                'telephone_country_code' => '+216',
                'telephone_country_code_extended' => '+216',
                'tld' => '.tn',
                'vehicle_registration_code' => 'TN',
            ],
            [
                'id' => 224,
                'active' => 0,
                'area' => 747,
                'capital_names' => '{"de": "Nukuʻalofa", "en": "Nukuʻalofa"}',
                'comments' => null,
                'fips10' => 'TN',
                'ioc' => 'TGA',
                'iso3166_alpha_2' => 'TO',
                'iso3166_alpha_3' => 'TON',
                'iso3166_numeric' => '776',
                'local_name' => 'Tonga',
                'locales' => null,
                'long_names' => '{"de": "Königreich Tonga", "en": "Kingdom Of Tonga"}',
                'nationality_names' => '{"de": "tongisch"}',
                'nato_country_code_2' => 'TN',
                'nato_country_code_3' => 'TON',
                'short_names' => '{"de": "Tonga", "en": "Tonga"}',
                'telephone_country_code' => '+676',
                'telephone_country_code_extended' => '+676',
                'tld' => '.to',
                'vehicle_registration_code' => 'TON',
            ],
            [
                'id' => 225,
                'active' => 0,
                'area' => 783562,
                'capital_names' => '{"de": "Ankara", "en": "Ankara"}',
                'comments' => null,
                'fips10' => 'TU',
                'ioc' => 'TUR',
                'iso3166_alpha_2' => 'TR',
                'iso3166_alpha_3' => 'TUR',
                'iso3166_numeric' => '792',
                'local_name' => 'Türkiye',
                'locales' => null,
                'long_names' => '{"de": "Republik Türkei", "en": "Republic Of Turkey"}',
                'nationality_names' => '{"de": "türkisch"}',
                'nato_country_code_2' => 'TU',
                'nato_country_code_3' => 'TUR',
                'short_names' => '{"de": "Türkei", "en": "Turkey"}',
                'telephone_country_code' => '+90',
                'telephone_country_code_extended' => '+90',
                'tld' => '.tr',
                'vehicle_registration_code' => 'TR',
            ],
            [
                'id' => 226,
                'active' => 0,
                'area' => 5128,
                'capital_names' => '{"de": "Port of Spain", "en": "Port of Spain"}',
                'comments' => null,
                'fips10' => 'TD',
                'ioc' => 'TRI',
                'iso3166_alpha_2' => 'TT',
                'iso3166_alpha_3' => 'TTO',
                'iso3166_numeric' => '780',
                'local_name' => 'Trinidad and Tobago',
                'locales' => null,
                'long_names' => '{"de": "Republik Trinidad und Tobago", "en": "Republic Of Trinidad And Tobago"}',
                'nationality_names' => '{"de": "trinbegonisch"}',
                'nato_country_code_2' => 'TD',
                'nato_country_code_3' => 'TTO',
                'short_names' => '{"de": "Trinidad und Tobago", "en": "Trinidad And Tobago"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1868',
                'tld' => '.tt',
                'vehicle_registration_code' => 'TT',
            ],
            [
                'id' => 227,
                'active' => 0,
                'area' => 26,
                'capital_names' => '{"de": "Funafuti", "en": "Funafuti"}',
                'comments' => null,
                'fips10' => 'TV',
                'ioc' => 'TUV',
                'iso3166_alpha_2' => 'TV',
                'iso3166_alpha_3' => 'TUV',
                'iso3166_numeric' => '798',
                'local_name' => 'Tuvalu',
                'locales' => null,
                'long_names' => '{"de": "Tuvalu", "en": "Tuvalu"}',
                'nationality_names' => '{"de": "tuvalanisch"}',
                'nato_country_code_2' => 'TV',
                'nato_country_code_3' => 'TUV',
                'short_names' => '{"de": "Tuvalu", "en": "Tuvalu"}',
                'telephone_country_code' => '+688',
                'telephone_country_code_extended' => '+688',
                'tld' => '.tv',
                'vehicle_registration_code' => 'TUV',
            ],
            [
                'id' => 228,
                'active' => 0,
                'area' => 35980,
                'capital_names' => '{"de": "Taipeh", "en": "Taipeh"}',
                'comments' => null,
                'fips10' => 'TW',
                'ioc' => 'TPE',
                'iso3166_alpha_2' => 'TW',
                'iso3166_alpha_3' => 'TWN',
                'iso3166_numeric' => '158',
                'local_name' => '中華民國 Zhonghua Minguo',
                'locales' => null,
                'long_names' => '{"de": "Republik China (Taiwan)", "en": "Republic of China (Taiwan)"}',
                'nationality_names' => '{"de": "taiwanesisch"}',
                'nato_country_code_2' => 'TW',
                'nato_country_code_3' => 'TWN',
                'short_names' => '{"de": "Taiwan", "en": "Taiwan"}',
                'telephone_country_code' => '+886',
                'telephone_country_code_extended' => '+886',
                'tld' => '.tw',
                'vehicle_registration_code' => 'RC',
            ],
            [
                'id' => 229,
                'active' => 0,
                'area' => 947300,
                'capital_names' => '{"de": "Dodoma", "en": "Dodoma"}',
                'comments' => null,
                'fips10' => 'TZ',
                'ioc' => 'TAN',
                'iso3166_alpha_2' => 'TZ',
                'iso3166_alpha_3' => 'TZA',
                'iso3166_numeric' => '834',
                'local_name' => 'Tanzania',
                'locales' => null,
                'long_names' => '{"de": "Vereinigte Republik Tansania", "en": "United Republic Of Tanzania"}',
                'nationality_names' => '{"de": "tansanisch"}',
                'nato_country_code_2' => 'TZ',
                'nato_country_code_3' => 'TZN',
                'short_names' => '{"de": "Tansania", "en": "Tanzania"}',
                'telephone_country_code' => '+255',
                'telephone_country_code_extended' => '+255',
                'tld' => '.tz',
                'vehicle_registration_code' => 'EAT',
            ],
            [
                'id' => 230,
                'active' => 1,
                'area' => 603550,
                'capital_names' => '{"de": "Kiew", "en": "Kyiv"}',
                'comments' => null,
                'fips10' => 'UP',
                'ioc' => 'UKR',
                'iso3166_alpha_2' => 'UA',
                'iso3166_alpha_3' => 'UKR',
                'iso3166_numeric' => '804',
                'local_name' => 'Ukrajina',
                'locales' => null,
                'long_names' => '{"de": "Ukraine", "en": "Ukraine"}',
                'nationality_names' => '{"de": "ukrainisch"}',
                'nato_country_code_2' => 'UA',
                'nato_country_code_3' => 'UKR',
                'short_names' => '{"de": "Ukraine", "en": "Ukraine"}',
                'telephone_country_code' => '+380',
                'telephone_country_code_extended' => '+380',
                'tld' => '.ua',
                'vehicle_registration_code' => 'UA',
            ],
            [
                'id' => 231,
                'active' => 0,
                'area' => 241038,
                'capital_names' => '{"de": "Kampala", "en": "Kampala"}',
                'comments' => null,
                'fips10' => 'UG',
                'ioc' => 'UGA',
                'iso3166_alpha_2' => 'UG',
                'iso3166_alpha_3' => 'UGA',
                'iso3166_numeric' => '800',
                'local_name' => 'Uganda',
                'locales' => null,
                'long_names' => '{"de": "Republik Uganda", "en": "Republic Of Uganda"}',
                'nationality_names' => '{"de": "ugandisch"}',
                'nato_country_code_2' => 'UG',
                'nato_country_code_3' => 'UGA',
                'short_names' => '{"de": "Uganda", "en": "Uganda"}',
                'telephone_country_code' => '+256',
                'telephone_country_code_extended' => '+256',
                'tld' => '.ug',
                'vehicle_registration_code' => 'EAU',
            ],
            [
                'id' => 232,
                'active' => 0,
                'area' => null,
                'capital_names' => '{"de": "Washington, D.C.", "en": "Washington, D.C."}',
                'comments' => null,
                'fips10' => null,
                'ioc' => null,
                'iso3166_alpha_2' => 'UM',
                'iso3166_alpha_3' => 'UMI',
                'iso3166_numeric' => '581',
                'local_name' => null,
                'locales' => '["en_US"]',
                'long_names' => '{"de": "United States Minor Outlying Islands", "en": "United States Minor Outlying Islands"}',
                'nationality_names' => null,
                'nato_country_code_2' => null,
                'nato_country_code_3' => null,
                'short_names' => '{"de": "US Minor Outlying Islands", "en": "US Minor Outlying Islands"}',
                'telephone_country_code' => null,
                'telephone_country_code_extended' => null,
                'tld' => '.um',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 233,
                'active' => 0,
                'area' => 9826675,
                'capital_names' => '{"de": "Washington, D.C.", "en": "Washington, D.C."}',
                'comments' => null,
                'fips10' => 'US',
                'ioc' => 'USA',
                'iso3166_alpha_2' => 'US',
                'iso3166_alpha_3' => 'USA',
                'iso3166_numeric' => '840',
                'local_name' => 'United States',
                'locales' => '["en_US"]',
                'long_names' => '{"de": "Vereinigte Staaten von Amerika", "en": "United States Of America"}',
                'nationality_names' => '{"de": "us-amerikanisch"}',
                'nato_country_code_2' => 'US',
                'nato_country_code_3' => 'USA',
                'short_names' => '{"de": "USA", "en": "United States"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1',
                'tld' => '.us',
                'vehicle_registration_code' => 'USA',
            ],
            [
                'id' => 234,
                'active' => 0,
                'area' => 176215,
                'capital_names' => '{"de": "Montevideo", "en": "Montevideo"}',
                'comments' => null,
                'fips10' => 'UY',
                'ioc' => 'URU',
                'iso3166_alpha_2' => 'UY',
                'iso3166_alpha_3' => 'URY',
                'iso3166_numeric' => '858',
                'local_name' => 'Uruguay',
                'locales' => null,
                'long_names' => '{"de": "Republik Östlich des Uruguay", "en": "Oriental Republic Of Uruguay"}',
                'nationality_names' => '{"de": "uruguayanisch"}',
                'nato_country_code_2' => 'UY',
                'nato_country_code_3' => 'URY',
                'short_names' => '{"de": "Uruguay", "en": "Uruguay"}',
                'telephone_country_code' => '+598',
                'telephone_country_code_extended' => '+598',
                'tld' => '.uy',
                'vehicle_registration_code' => 'ROU',
            ],
            [
                'id' => 235,
                'active' => 0,
                'area' => 447400,
                'capital_names' => '{"de": "Taschkent", "en": "Tashkent"}',
                'comments' => null,
                'fips10' => 'UZ',
                'ioc' => 'UZB',
                'iso3166_alpha_2' => 'UZ',
                'iso3166_alpha_3' => 'UZB',
                'iso3166_numeric' => '860',
                'local_name' => 'Oʻzbekiston',
                'locales' => null,
                'long_names' => '{"de": "Republik Usbekistan", "en": "Republic Of Uzbekistan"}',
                'nationality_names' => '{"de": "usbekisch"}',
                'nato_country_code_2' => 'UZ',
                'nato_country_code_3' => 'UZB',
                'short_names' => '{"de": "Usbekistan", "en": "Uzbekistan"}',
                'telephone_country_code' => '+998',
                'telephone_country_code_extended' => '+998',
                'tld' => '.uz',
                'vehicle_registration_code' => 'UZ',
            ],
            [
                'id' => 236,
                'active' => 1,
                'area' => 0.44,
                'capital_names' => '{"de": ""}',
                'comments' => null,
                'fips10' => 'VT',
                'ioc' => null,
                'iso3166_alpha_2' => 'VA',
                'iso3166_alpha_3' => 'VAT',
                'iso3166_numeric' => '336',
                'local_name' => 'Status Civitatis Vaticanæ',
                'locales' => null,
                'long_names' => '{"de": "Staat Vatikanstadt", "en": "State Of The Vatican City"}',
                'nationality_names' => '{"de": "vatikanisch"}',
                'nato_country_code_2' => 'VT',
                'nato_country_code_3' => 'VAT',
                'short_names' => '{"de": "Vatikanstadt", "en": "Vatican City"}',
                'telephone_country_code' => '+379',
                'telephone_country_code_extended' => '+379',
                'tld' => '.va',
                'vehicle_registration_code' => 'V',
            ],
            [
                'id' => 237,
                'active' => 0,
                'area' => 389,
                'capital_names' => '{"de": "Kingstown", "en": "Kingstown"}',
                'comments' => null,
                'fips10' => 'VC',
                'ioc' => 'VIN',
                'iso3166_alpha_2' => 'VC',
                'iso3166_alpha_3' => 'VCT',
                'iso3166_numeric' => '670',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "St. Vincent und die Grenadinen", "en": "Saint Vincent And The Grenadines"}',
                'nationality_names' => '{"de": "vincentisch"}',
                'nato_country_code_2' => 'VC',
                'nato_country_code_3' => 'VCT',
                'short_names' => '{"de": "St. Vincent und die Grenadinen", "en": "Saint Vincent And The Grenadines"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1784',
                'tld' => '.vc',
                'vehicle_registration_code' => 'WV',
            ],
            [
                'id' => 238,
                'active' => 0,
                'area' => 912050,
                'capital_names' => '{"de": "Caracas", "en": "Caracas"}',
                'comments' => null,
                'fips10' => 'VE',
                'ioc' => 'VEN',
                'iso3166_alpha_2' => 'VE',
                'iso3166_alpha_3' => 'VEN',
                'iso3166_numeric' => '862',
                'local_name' => 'Venezuela',
                'locales' => null,
                'long_names' => '{"de": "Bolivarische Republik Venezuela", "en": "Bolivarian Republic Of Venezuela"}',
                'nationality_names' => '{"de": "venezulanisch"}',
                'nato_country_code_2' => 'VE',
                'nato_country_code_3' => 'VEN',
                'short_names' => '{"de": "Venezuela", "en": "Venezuela"}',
                'telephone_country_code' => '+58',
                'telephone_country_code_extended' => '+58',
                'tld' => '.ve',
                'vehicle_registration_code' => 'YV',
            ],
            [
                'id' => 239,
                'active' => 0,
                'area' => 150000,
                'capital_names' => '{"de": "Road Town", "en": "Road Town"}',
                'comments' => null,
                'fips10' => 'VI',
                'ioc' => 'IVB',
                'iso3166_alpha_2' => 'VG',
                'iso3166_alpha_3' => 'VGB',
                'iso3166_numeric' => '092',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Britische Jungferninseln", "en": "British Virgin Islands"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'VS',
                'nato_country_code_3' => 'VGB',
                'short_names' => '{"de": "Britische Jungferninseln", "en": "British Virgin Islands"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1284',
                'tld' => '.vg',
                'vehicle_registration_code' => 'VG',
            ],
            [
                'id' => 240,
                'active' => 0,
                'area' => 346000,
                'capital_names' => '{"de": "Charlotte Amalie", "en": "Charlotte Amalie"}',
                'comments' => null,
                'fips10' => 'VQ',
                'ioc' => 'ISV',
                'iso3166_alpha_2' => 'VI',
                'iso3166_alpha_3' => 'VIR',
                'iso3166_numeric' => '850',
                'local_name' => 'Virgin Islands of the United States',
                'locales' => '["en_US"]',
                'long_names' => '{"de": "Amerikanische Jungferninseln", "en": "United States Virgin Islands"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'VI',
                'nato_country_code_3' => 'VIR',
                'short_names' => '{"de": "Amerikanische Jungferninseln", "en": "United States Virgin Islands"}',
                'telephone_country_code' => '+1',
                'telephone_country_code_extended' => '+1340',
                'tld' => '.vi',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 241,
                'active' => 0,
                'area' => 331210,
                'capital_names' => '{"de": "Hanoi", "en": "Hanoi"}',
                'comments' => null,
                'fips10' => 'VM',
                'ioc' => 'VIE',
                'iso3166_alpha_2' => 'VN',
                'iso3166_alpha_3' => 'VNM',
                'iso3166_numeric' => '704',
                'local_name' => 'Việt Nam',
                'locales' => null,
                'long_names' => '{"de": "Sozialistische Republik Vietnam", "en": "Socialist Republic Of Vietnam"}',
                'nationality_names' => '{"de": "vietnamesisch"}',
                'nato_country_code_2' => 'VN',
                'nato_country_code_3' => 'VNM',
                'short_names' => '{"de": "Vietnam", "en": "Vietnam"}',
                'telephone_country_code' => '+84',
                'telephone_country_code_extended' => '+84',
                'tld' => '.vn',
                'vehicle_registration_code' => 'VN',
            ],
            [
                'id' => 242,
                'active' => 0,
                'area' => 12189,
                'capital_names' => '{"de": "Port Vila", "en": "Port Vila"}',
                'comments' => null,
                'fips10' => 'NH',
                'ioc' => 'VAN',
                'iso3166_alpha_2' => 'VU',
                'iso3166_alpha_3' => 'VUT',
                'iso3166_numeric' => '548',
                'local_name' => 'Vanuatu',
                'locales' => null,
                'long_names' => '{"de": "Republik Vanuatu", "en": "Republic Of Vanuatu"}',
                'nationality_names' => '{"de": "vanuatisch"}',
                'nato_country_code_2' => 'NH',
                'nato_country_code_3' => 'VUT',
                'short_names' => '{"de": "Vanuatu", "en": "Vanuatu"}',
                'telephone_country_code' => '+678',
                'telephone_country_code_extended' => '+678',
                'tld' => '.vu',
                'vehicle_registration_code' => 'VAN',
            ],
            [
                'id' => 243,
                'active' => 0,
                'area' => 142000,
                'capital_names' => '{"de": "Mata Utu", "en": "Mata Utu"}',
                'comments' => null,
                'fips10' => 'WF',
                'ioc' => null,
                'iso3166_alpha_2' => 'WF',
                'iso3166_alpha_3' => 'WLF',
                'iso3166_numeric' => '876',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Wallis und Futuna", "en": "Wallis and Futuna"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'WF',
                'nato_country_code_3' => 'WLF',
                'short_names' => '{"de": "Wallis und Futuna", "en": "Wallis and Futuna"}',
                'telephone_country_code' => '+681',
                'telephone_country_code_extended' => '+681',
                'tld' => '.wf',
                'vehicle_registration_code' => 'F',
            ],
            [
                'id' => 244,
                'active' => 0,
                'area' => 2831,
                'capital_names' => '{"de": "Apia", "en": "Apia"}',
                'comments' => null,
                'fips10' => 'WS',
                'ioc' => 'SAM',
                'iso3166_alpha_2' => 'WS',
                'iso3166_alpha_3' => 'WSM',
                'iso3166_numeric' => '882',
                'local_name' => 'Samoa',
                'locales' => null,
                'long_names' => '{"de": "Unabhängiger Staat Samoa", "en": "Independent State Of Samoa"}',
                'nationality_names' => '{"de": "samoanisch"}',
                'nato_country_code_2' => 'SS',
                'nato_country_code_3' => 'WSM',
                'short_names' => '{"de": "Samoa", "en": "Samoa"}',
                'telephone_country_code' => '+685',
                'telephone_country_code_extended' => '+685',
                'tld' => '.ws',
                'vehicle_registration_code' => 'WS',
            ],
            [
                'id' => 245,
                'active' => 0,
                'area' => 527968,
                'capital_names' => '{"de": "Sanaa", "en": "Sanaa"}',
                'comments' => null,
                'fips10' => 'YM',
                'ioc' => 'YEM',
                'iso3166_alpha_2' => 'YE',
                'iso3166_alpha_3' => 'YEM',
                'iso3166_numeric' => '887',
                'local_name' => 'al-Yaman',
                'locales' => null,
                'long_names' => '{"de": "Republik Jemen", "en": "Republic Of Yemen"}',
                'nationality_names' => '{"de": "jemenitisch"}',
                'nato_country_code_2' => 'YE',
                'nato_country_code_3' => 'YEM',
                'short_names' => '{"de": "Jemen", "en": "Yemen"}',
                'telephone_country_code' => '+967',
                'telephone_country_code_extended' => '+967',
                'tld' => '.ye',
                'vehicle_registration_code' => 'YEM',
            ],
            [
                'id' => 246,
                'active' => 0,
                'area' => 376780,
                'capital_names' => '{"de": "Mamoudzou", "en": "Mamoudzou"}',
                'comments' => null,
                'fips10' => 'MF',
                'ioc' => null,
                'iso3166_alpha_2' => 'YT',
                'iso3166_alpha_3' => 'MYT',
                'iso3166_numeric' => '175',
                'local_name' => null,
                'locales' => null,
                'long_names' => '{"de": "Mayotte", "en": "Mayotte"}',
                'nationality_names' => null,
                'nato_country_code_2' => 'ME',
                'nato_country_code_3' => 'MYT',
                'short_names' => '{"de": "Mayotte", "en": "Mayotte"}',
                'telephone_country_code' => '+262',
                'telephone_country_code_extended' => '+262',
                'tld' => '.yt',
                'vehicle_registration_code' => null,
            ],
            [
                'id' => 247,
                'active' => 0,
                'area' => 1219090,
                'capital_names' => '{"de": "Pretoria", "en": "Pretoria"}',
                'comments' => null,
                'fips10' => 'SF',
                'ioc' => 'RSA',
                'iso3166_alpha_2' => 'ZA',
                'iso3166_alpha_3' => 'ZAF',
                'iso3166_numeric' => '710',
                'local_name' => 'Suid-Afrika (Afrikaans), South Africa (Englisch)',
                'locales' => null,
                'long_names' => '{"de": "Republik Südafrika", "en": "Republic Of South Africa"}',
                'nationality_names' => '{"de": "südafrikanisch"}',
                'nato_country_code_2' => 'SF',
                'nato_country_code_3' => 'ZAF',
                'short_names' => '{"de": "Südafrika", "en": "South Africa"}',
                'telephone_country_code' => '+27',
                'telephone_country_code_extended' => '+27',
                'tld' => '.za',
                'vehicle_registration_code' => 'ZA',
            ],
            [
                'id' => 248,
                'active' => 0,
                'area' => 752618,
                'capital_names' => '{"de": "Lusaka", "en": "Lusaka"}',
                'comments' => null,
                'fips10' => 'ZA',
                'ioc' => 'ZAM',
                'iso3166_alpha_2' => 'ZM',
                'iso3166_alpha_3' => 'ZMB',
                'iso3166_numeric' => '894',
                'local_name' => 'Zambia',
                'locales' => null,
                'long_names' => '{"de": "Republik Sambia", "en": "Republic Of Zambia"}',
                'nationality_names' => '{"de": "sambisch"}',
                'nato_country_code_2' => 'ZA',
                'nato_country_code_3' => 'ZMB',
                'short_names' => '{"de": "Sambia", "en": "Zambia"}',
                'telephone_country_code' => '+260',
                'telephone_country_code_extended' => '+260',
                'tld' => '.zm',
                'vehicle_registration_code' => 'Z',
            ],
            [
                'id' => 249,
                'active' => 0,
                'area' => 390757,
                'capital_names' => '{"de": "Harare", "en": "Harare"}',
                'comments' => null,
                'fips10' => 'ZI',
                'ioc' => 'ZIM',
                'iso3166_alpha_2' => 'ZW',
                'iso3166_alpha_3' => 'ZWE',
                'iso3166_numeric' => '716',
                'local_name' => 'Zimbabwe',
                'locales' => null,
                'long_names' => '{"de": "Republik Simbabwe", "en": "Republic Of Zimbabwe"}',
                'nationality_names' => '{"de": "simbabwisch"}',
                'nato_country_code_2' => 'ZI',
                'nato_country_code_3' => 'ZWE',
                'short_names' => '{"de": "Simbabwe", "en": "Zimbabwe"}',
                'telephone_country_code' => '+263',
                'telephone_country_code_extended' => '+263',
                'tld' => '.zw',
                'vehicle_registration_code' => 'ZW',
            ],
        ]);
        // /*
        // **  Alle Länder deaktivieren die nicht in den Zonen 3, 4 und 7 liegen und nicht die Türkei sind. */
        // Country::whereNotLike('telephone_country_code', '+3%')  // Europa
        //     ->whereNotLike('telephone_country_code', '+4%')     // Europa
        //     ->where('telephone_country_code', '!=', '+7')       // Russland und russisch besetzte Gebiete
        //     ->where('telephone_country_code', '!=', '+98')      // Türkei
        //     ->update(['active' => 0]);

    } // run()

} // class CountrySeeder extends Seeder {}
