<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base\globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders\Demo;


use App\Models\User;
use BplanBase\Globals\Models\RoleUser;
use BplanBase\Globals\Models\Role;
use BplanBase\Globals\Models\Tenant;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;


/**
 * Seeder Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class RoleUserSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        $Tenant = Tenant::where('identifier', 'System')
            ->first();

        $AdminRole = Role::where('tenant_id', '=', $Tenant->id)
            ->where('identifier', '=', 'Administrator')
            ->first();

        $DemoUser = User::where('tenant_id', '=', $Tenant->id)
            ->where('email', '=', 'demo.user@bplan-solutions.de')
            ->first();

        RoleUser::insert([
            // [
            //     'uuid' => Str::uuid(),
            //     'active' => 1,
            //     'created_at' => $date,
            //     'role_id' => $Tenant->id,
            //     'user_id' => 1,
            // ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'role_id' => $AdminRole->id,
                'user_id' => $DemoUser->id,
            ],
        ]);

    } // run()

} // class RoleUserSeeder extends Seeder {}
