{{--
 *
 * @todo        x-on:click.prevent="$wire.set('selectedTab', '{!! $tab !!}')" funktioniert für den
 *              Austausch der Button im EntityType-Form, verursacht aber aber im EntityType-Grid einen
 *              Reload, wodurch die Label verschwinden.
 *              Dort funktioniert x-on:click.prevent="selectedTab = '{!! $tab !!}'", was aber nur client-seitig
 *              ist, weswegen dann im Form die Buttons nicht getauscht werden.
 *
 *              Mögliche Lösungen:
 *              - Verwendete Variante steuerbar machen.
 *              - Das Switchen der Buttons nur client-seitig durchführen. Vorteil dieser Lösung wäre auch, dass
 *                der Austausch schneller/flüssiger gehen würde.
 *                Bei dieser Lösung könnte dann eventuell auch x-on:change.prevent="selectedTab = this.value;"
 *                beim Select im Form funktionieren.
 *
 * @version     2.0.$Revision: 3223 $
 * @version     SVN: $Id: tab-creator.blade.php 3223 2024-07-06 07:58:54Z wassilios.meletiadis $
 * @package     Core\phpAPI
 * @subpackage  Templates
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2023, 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
--}}

            <div>
              <div class="sm:hidden">
                <select class="block w-full rounded-md border-gray-300 focus:border-indigo-500 focus:ring-indigo-500" id="tabs" name="tabs" x-on:change.prevent="selectedTab = this.value;" wire:model="selectedTab">

@foreach ($tabs as $tab)
    @if ($tab['active'] === false)
        @php
            continue;
        @endphp

    @elseif (!empty($tab['disabled']))
        @php
            $disabled = ' disabled="disabled"';
        @endphp
    @endif

                  <option value="{!! $tab['identifier'] !!}">{{ $tab['label'] }}</option>

@endforeach

                </select>
              </div>
              <div class="hidden sm:block pl-2 pr-2 pt-1 border-b border-gray-200">
                <nav class="-mb-px flex space-x-4 -m-b-1" aria-label="Tabs">

@foreach ($tabs as $tab)
    @php
        $disabled = '';

        if ($tab['active'] === false) {
            continue;

        } elseif (!empty($tab['disabled'])) {
            $disabled = ' pointer-events-none opacity-50 cursor-not-allowed';
        }
    @endphp

                  <a class="border-transparent text-gray-500 hover:border-gray-300 hover:text-gray-700 whitespace-nowrap border-b-2 py-4 px-1 text-sm font-medium{!! $disabled !!}}" href="#" x-on:click.prevent="$wire.set('selectedTab', '{!! $tab['identifier'] !!}')" :class="{ 'border-indigo-500 text-indigo-600' : selectedTab === '{!! $tab['identifier'] !!}', 'border-transparent text-gray-500': selectedTab !== '{!! $tab['identifier'] !!}' }">{{ $tab['label'] }}</a>

@endforeach

                </nav>
              </div>
            </div>
