<?php
/**
 * Admin Controller Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Controllers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Http\Controllers\Core;


use BplanBase\Globals\Foundation\Http\Controllers\CoreController;
use BplanBase\Globals\Livewire\Core\UserRecords\Form as UserRecordForm;
use BplanBase\Globals\Livewire\Core\UserRecords\Grid as UserRecordGrid;
use BplanBase\Globals\Models\UserRecord;
use BplanBase\Globals\Repositories\UserRecordRepository;
use BplanBase\Globals\Services\UserRecordService;
use Illuminate\Http\Request;


/**
 * Admin Controller Class
 *
 * @version     2.0.0 / 2025-06-03
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class UserRecordController extends CoreController
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected string $_formClass = UserRecordForm::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_gridClass = UserRecordGrid::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_modelClass = UserRecord::class;


    /**
     * @var     string $_repositoryClass
     */
    protected string $_repositoryClass = UserRecordRepository::class;


    /**
     * @var     string $_resourceName
     */
    protected string $_resourceName = 'user-records';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Request $Request
     *
     * @param       UserRecordService $Service
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Request $Request, UserRecordService $Service)
    {
        parent::__construct($Request, $Service);

    } // __construct()


    /**
     * Überschreibt die Methode der Base-Klasse
     *
     * Neue UserRecords werden automatisch angelegt wenn ein neuer User angelegt wird. Deshalb
     * leitet diese Methode auf die Neuanlage für Users um.
     *
     * @return      \Illuminate\Http\Response
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function create()
    {
        return redirect()->route('create.user');

    } // create()


    /**
     * Überschreibt die Methode der Base-Klasse
     *
     * UserRecords können nur gelöscht werden indem der zugehörige User gelöscht wird. Deshalb
     * leitet diese Methode auf die Löschung für Users um.
     *
     * @param       int  $id
     *
     * @return      \Illuminate\Http\Response
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function destroy($id)
    {
        return redirect()->route('delete.user', ['id' => $id]);

    } // destroy()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class UserRecordController extends CoreController {}
