<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Locales
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */


use Carbon\WeekDay;


return [

    'iso-3166-1-alpha-2' => 'lt',
    'language' => 'Lietuvių',
    'locale' => 'lt_LT',

    'currency.decimals'        => "2",
    'currency.format.string'   => ':value €',
    'currency.format.negative' => '-:value €',
    'currency.iso4217.alpha'   => 'EUR',
    'currency.iso4217.numeric' => 978,
    'currency.name'            => 'Euras',
    'currency.subunit.divisor' => 100,
    'currency.subunit.name'    => 'Euro centas',
    'currency.subunit.symbol'  => 'ct',
    'currency.symbol'          => '€',

    'date.format'       => 'Y-m-d',
    'datetime.format'   => 'Y-m-d H:i',
    'datetime.format+'  => 'Y-m-d H:i:s',
    'datetime.format-+' => 'Y-m-d H:i',
    'datetime.format++' => 'Y-m-d H:i:s',
    'time.format'       => 'H:i',
    'time.format+'      => 'H:i:s',
    'time.format-+'     => 'H:i',
    'time.format++'     => 'H:i:s',

    'number.decimal-point'       => ',',
    'number.thousands-separator' => ' ',

    'text.direction'    => 'ltr',
    'text.orientation'  => 'sideways',
    'text.writing-mode' => 'vertical-rl',

    // -------------------------------------------------------------------

    'action.activate'      => 'Aktyvuoti',
    'action.add'           => 'Pridėti',
    'action.cancel'        => 'Atšaukti',
    'action.cancel-upload' => 'Atšaukti įkėlimą',
    'action.change'        => 'Keisti',
    'action.close'         => 'Uždaryti',
    'action.confirm'       => 'Patvirtinti',
    'action.deactivate'    => 'Išjungti',
    'action.delete'        => 'Ištrinti',
    'action.edit'          => 'Redaguoti',
    'action.import'        => 'Importuoti',
    'action.print'         => 'Spausdinti',
    'action.save'          => 'Išsaugoti',
    'action.search'        => 'Ieškoti',
    'action.sync'          => 'Sinchronizuoti',
    'action.upload'        => 'Įkelti failą',
    'action.verify'        => 'Patvirtinti',
    'action.view'          => 'Peržiūrėti',

    'languages' => [
        'bg' => 'Bulgarų',
        'de' => 'Vokiečių',
        'en' => 'Anglų',
        'es' => 'Ispanų',
        'fr' => 'Prancūzų',
        'hu' => 'Vengrų',
        'it' => 'Italų',
        'lt' => 'Lietuvių',
        'pl' => 'Lenkų',
        'ro' => 'Rumunų',
        'ru' => 'Rusų',
        'tr' => 'Turkų',
        'uk' => 'Ukrainiečių',
    ],

    'option.yes' => 'Taip',
    'option.no'  => 'Ne',

    'required-hint'   => 'Laukai su žyme (<span class="required-marker">:marker</span>) yra privalomi',
    'required-marker' => '*',

    'select-option.no-options-available' => 'Galimybių nėra',
    'select-option.please-select'        => ' -- Prašome pasirinkti -- ',

    'status.active'   => 'Aktyvus',
    'status.expired'  => 'Pasibaigęs',
    'status.inactive' => 'Neaktyvus',
    'status.invalid'  => 'Negaliojantis',
    'status.loading'  => 'Įkeliama...',
    'status.not-set'  => 'Nenustatyta',
    'status.valid'    => 'Galiojantis',

    'weekdays.'.Weekday::Sunday->name    => 'sekmadienis',
    'weekdays.'.Weekday::Monday->name    => 'pirmadienis',
    'weekdays.'.Weekday::Tuesday->name   => 'antradienis',
    'weekdays.'.Weekday::Wednesday->name => 'trečiadienis',
    'weekdays.'.Weekday::Thursday->name  => 'ketvirtadienis',
    'weekdays.'.Weekday::Friday->name    => 'penktadienis',
    'weekdays.'.Weekday::Saturday->name  => 'šeštadienis',

    'weekdays.'.Weekday::Sunday->value    => 'sekmadienis',
    'weekdays.'.Weekday::Monday->value    => 'pirmadienis',
    'weekdays.'.Weekday::Tuesday->value   => 'antradienis',
    'weekdays.'.Weekday::Wednesday->value => 'trečiadienis',
    'weekdays.'.Weekday::Thursday->value  => 'ketvirtadienis',
    'weekdays.'.Weekday::Friday->value    => 'penktadienis',
    'weekdays.'.Weekday::Saturday->value  => 'šeštadienis',

];
