<?php
/**
 * Service Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-06-15 00:00:00
 * @package     bplan-base/globals
 * @subpackage  Services
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Services;


use BplanBase\Globals\Actions\TenantLocales\Create;
use BplanBase\Globals\Actions\TenantLocales\Delete;
use BplanBase\Globals\Actions\TenantLocales\Update;
use BplanBase\Globals\Actions\TenantLocale\UpdateActiveStatus;
use BplanBase\Globals\Models\TenantLocale;
use Illuminate\Database\Eloquent\Model;


/**
 * Service Class
 *
 * @version     2.1.0 / 2025-06-15
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantLocaleService
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $attributes
     *
     * @return      TenantLocale
     *
     * @version     1.0.0 / 2025-05-14
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function create(array $attributes): Model
    {
        $Action = new Create();

        return $Action->execute($attributes);

    } // create()


    /**
     *
     * @param       int|string|TenantLocale $tenantLocale
     *
     * @return      TenantLocale
     *
     * @version     2.0.0 / 2025-05-14
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function delete(int|string|Model $tenantLocale): Model
    {
        $Action = new Delete();

        return $Action->execute($tenantLocale);

    } // delete()


    /**
     *
     * @param       int|string|TenantLocale $tenantLocale
     *
     * @param       array $attributes
     *
     * @return      TenantLocale
     *
     * @version     2.0.0 / 2025-05-14
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function update(int|string|Model $tenantLocale, array $attributes): Model
    {
        $Action = new Update();

        return $Action->execute($tenantLocale, $attributes);

    } // update()


    /**
     *
     * @param       int|string|TenantLocale|DerivedTenantLocale $tenantLocale
     *
     * @param       bool $status
     *
     * @return      TenantLocale|DerivedTenantLocale
     *
     * @version     1.0.0 / 2025-05-27
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updateActiveStatus(int|string|TenantLocale|DerivedTenantLocale $tenantLocale, bool $status): TenantLocale|DerivedTenantLocale
    {
        $Action = new UpdateActiveStatus();

        return $Action->execute($tenantLocale, $status);

    } // update()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class TenantLocaleService {}
