<?php
/**
 * Service Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-06-15 00:00:00
 * @package     bplan-base/globals
 * @subpackage  Services
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Services;


use App\Models\Tenant as DerivedTenant;
use App\Models\TenantRecord as DerivedTenantRecord;
use BplanBase\Globals\Actions\TenantRecords\Create;
use BplanBase\Globals\Actions\TenantRecords\Delete;
use BplanBase\Globals\Actions\TenantRecords\Update;
use BplanBase\Globals\Actions\TenantRecords\UpdateActiveStatus;
use BplanBase\Globals\Models\Tenant;
use BplanBase\Globals\Models\TenantRecord;
use Illuminate\Database\Eloquent\Model;


/**
 * Service Class
 *
 * @version     2.1.0 / 2025-06-15
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantRecordService
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Model $Tenant
     *
     * @return      Model
     *
     * @version     2.0.0 / 2025-05-27
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function create(Model $Tenant): Model
    {
        $Action = new Create();

        return $Action->execute($Tenant);

    } // create()


    /**
     *
     * @param       int|string|TenantRecord $tenantRecord
     *
     * @return      TenantRecord
     *
     * @version     2.0.0 / 2025-05-14
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function delete(int|string|Model $tenantRecord): Model
    {
        $Action = new Delete();

        return $Action->execute($tenantRecord);

    } // delete()


    /**
     *
     * @param       int|string|TenantRecord $tenantRecord
     *
     * @param       array|Tenant|DerivedTenant $tenant
     *
     * @return      TenantRecord|DerivedTenantRecord
     *
     * @version     3.0.0 / 2025-05-27
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function update(int|string|Model $tenantRecord, array|Model $tenant): Model
    {
        $Action = new Update();

        return $Action->execute($tenantRecord, $tenant);

    } // update()


    /**
     *
     * @param       int|string|TenantRecord|DerivedTenantRecord $tenantRecord
     *
     * @param       bool $status
     *
     * @return      TenantRecord|DerivedTenantRecord
     *
     * @version     1.0.0 / 2025-05-27
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updateActiveStatus(int|string|TenantRecord|DerivedTenantRecord $tenantRecord, bool $status): TenantRecord|DerivedTenantRecord
    {
        $Action = new UpdateActiveStatus();

        return $Action->execute($tenantRecord, $status);

    } // update()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class TenantRecordService {}
