<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders;


use BplanBase\Globals\Enums\LanguageContext;
use BplanBase\Globals\Models\Language;
use Illuminate\Database\Seeder;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class LanguageSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        Language::insert([
            [
                "id" => 1,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "bg",
                "context" => LanguageContext::Terminal->value,
                "labels" => '{"bg":"Български", "de":"Bulgarisch", "en":"Bulgarian", "es":"Búlgaro", "fr":"Bulgare", "it":"Bulgaro", "lt":"Bulgarų", "ro":"Bulgară", "ru":"Болгарский", "tr":"Bulgarca"}',
            ], [
                "id" => 2,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "de",
                "context" => LanguageContext::Both->value,
                "labels" => '{"bg":"Немски", "de":"Deutsch", "en":"German", "es":"Alemán", "fr":"Allemand", "it":"Tedesco", "lt":"Vokiečių", "ro":"Germană", "ru":"Немецкий", "tr":"Almanca"}',
            ], [
                "id" => 3,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "en",
                "context" => LanguageContext::Both->value,
                "labels" => '{"bg":"Английски", "de":"Englisch", "en":"English", "es":"Inglés", "fr":"Anglais", "it":"Inglese", "lt":"Anglų", "ro":"Engleză", "ru":"Английский", "tr":"İngilizce"}',
            ], [
                "id" => 4,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "es",
                "context" => LanguageContext::Terminal->value,
                "labels" => '{"bg":"Испански", "de":"Spanisch", "en":"Spanish", "es":"Español", "fr":"Espagnol", "it":"Spagnolo", "lt":"Ispanų", "ro":"Spaniolă", "ru":"Испанский", "tr":"İspanyolca"}',
            ],[
                "id" => 5,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "fr",
                "context" => LanguageContext::Terminal->value,
                "labels" => '{"bg":"Френски", "de":"Französisch", "en":"French", "es":"Francés", "fr":"Français", "it":"Francese", "lt":"Prancūzų", "ro":"Franceză", "ru":"Французский", "tr":"Fransızca"}',
            ], [
                "id" => 6,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "it",
                "context" => LanguageContext::Terminal->value,
                "labels" => '{"bg":"Италиански", "de":"Italienisch", "en":"Italian", "es":"Italiano", "fr":"Italien", "it":"Italiano", "lt":"Italų", "ro":"Italiană", "ru":"Итальянский", "tr":"İtalyanca"}',
            ],  [
                "id" => 7,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "lt",
                "context" => LanguageContext::Terminal->value,
                "labels" => '{"bg":"Литовски", "de":"Litauisch", "en":"Lithuanian", "es":"Lituano", "fr":"Lituanien", "it":"Lituano", "lt":"Lietuvių", "ro":"Lituaniană", "ru":"Литовский", "tr":"Litvanca"}',
            ], [
                "id" => 8,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "ro",
                "context" => LanguageContext::Terminal->value,
                "labels" => '{"bg":"Румънски", "de":"Rumänisch", "en":"Romanian", "es":"Rumano", "fr":"Roumain", "it":"Rumeno", "lt":"Rumunų", "ro":"Română", "ru":"Румынский", "tr":"Romence"}',
            ], [
                "id" => 9,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "ru",
                "context" => LanguageContext::Terminal->value,
                "labels" => '{"bg":"Руски", "de":"Russisch", "en":"Russian", "es":"Ruso", "fr":"Russe", "it":"Russo", "lt":"Rusų", "ro":"Rusă", "ru":"Русский", "tr":"Rusça"}',
            ], [
                "id" => 10,
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "deleted_at" => null,
                "code" => "tr",
                "context" => LanguageContext::Terminal->value,
                "labels" => '{"bg":"Турски", "de":"Türkisch", "en":"Turkish", "es":"Turco", "fr":"Turc", "it":"Turco", "lt":"Turkų", "ro":"Turcă", "ru":"Турецкий", "tr":"Türkçe"}',
            ],

        ]);

    } // run()

} // class LanguageSeeder extends Seeder {}
