<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders;


use BplanBase\Globals\Models\LocationType;
use BplanBase\Globals\Registries\LocationTypeRegistry;
use Illuminate\Database\Seeder;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class LocationTypeSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        $data = [];

        foreach (LocationTypeRegistry::names() as $name) {
            $data[] = [
                "active" => 1,
                "created_at" => $date,
                "updated_at" => $date,
                "identifier" => $name,
            ];
        }
        LocationType::insert($data);

    } // run()

} // class LocationTypeSeeder extends Seeder {}
