<?php
/**
 * Enum Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Enums
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Enums;


/**
 * Enum Class
 *
 * Statuswerte für die Verwendung der in der Datenbank hinterlegten Sprachen.
 * Beschreibung der Statuswerte:
 *
 * 0 None       Deaktiviert.
 *
 * 1 Terminal   Aktiviert für das Terminal.
 *
 * 2 Web        Aktiviert für das Web-Frontend.
 *
 * 3 Both       Aktiviert für das Terminal und das Web-Frontend.
 *
 * @version     1.0.0 / 2025-01-06
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
enum LanguageContext: int {

    case Both     = 3;

    case None     = 0;

    case Terminal = 1;

    case Web      = 2;

} // enum LanguageContext {}
