<?php
/**
 * Log Helper Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Helpers
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Helpers;


use Illuminate\Support\Facades\Log;
use Throwable;


/**
 * Log Helper Class
 *
 * @version     1.0.0 / 2025-03-05
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
class LogHelper
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Throwable $Throwable
     *
     * @return 	    void
     *
     * @version     1.0.0 / 2025-03-05
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public static function logException(Throwable $Throwable): void
    {
        Log::error("Exception: {$Throwable->getMessage()}. File: {$Throwable->getFile()}. Line: {$Throwable->getLine()}");

    } // logException()


} // class LogHelper
