<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Livewire\Global\Modals;


use BplanBase\Globals\Enums\LanguageContext;
use BplanBase\Globals\Models\Language;
use Illuminate\Database\Eloquent\Collection;
use Livewire\Attributes\On;
use Livewire\Component;


/**
 * Livewire Component
 *
 * @version     1.0.0 / 2025-04-13
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class MultiLanguageJson extends Component
{
    public ?Collection $languages;
    public int|string $languageContext = LanguageContext::Web->value;

    public string $windowTitle = 'Labels';
    public array $labels = [];
    public ?string $target;
    public bool $multiline = false;

    public function mount()
    {
        $this->languages = Language::where('context', '&', $this->languageContext)->get();
    }

    public function rules()
    {
        $rules = [];

        foreach ($this->languages as $key => $language) {
            $rules["labels.{$language->code}"] = 'required';
        }

        return $rules;
    }

    public function render()
    {
        return view('globals::livewire.global.modals.multi-language-json');
    }

    public function resetModal()
    {
        $this->labels = [];
    }

    #[On('show-multi-language-json-modal')]
    public function init(?array $labels, string $target, string $windowTitle = 'Labels')
    {
        if(isset($labels) && !empty($labels)) {
            $this->labels = $labels;
        }

        $this->target = $target;
        $this->windowTitle = $windowTitle;
    }

    public function createMultiLanguageJson()
    {
        $this->validate();

        $this->dispatch('multi-language-json-created', json: $this->labels, target: $this->target);
    }
}
