<?php
/**
 * Enum Getters Trait
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Traits
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Traits;


/**
 * Enum Getters Trait
 *
 * @version     1.0.0 / 2025-05-07
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
trait EnumGetters
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Liefert einen assoziativen Array
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-05-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function array(): array
    {
        return array_combine(self::values(), self::names());

    } // array()


    /**
     * Liefert den Case zum übergebenen Schlüssel
     *
     * @param       string $name
     *
     * @return      State|null
     *
     * @version     1.0.0 / 2025-05-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getByName(string $name): self|null
    {
        if (defined('self::'.$name) === false) {
            return null;
        }
        return constant('self::'.$name);

    } // getByName()


    /**
     * Liefert den Case zum übergebenen Wert
     *
     * @param       int $value
     *
     * @return      State|null
     *
     * @version     1.0.0 / 2025-05-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getByValue(int|string $value): self|null
    {
        if (self::tryFrom($value) === null) {
            return null;
        }
        return self::from($value);

    } // getByValue()


    /**
     * Liefert einen Array mit allen Schlüsseln
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-05-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function names(): array
    {
        return array_column(self::cases(), 'name');

    } // names()


    /**
     * Liefert einen Array mit allen Werten
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-05-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function values(): array
    {
        return array_column(self::cases(), 'value');

    } // values()


} // trait EnumGetters {}
