<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-modules/globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders;


use BplanBase\Globals\Models\Role;
use BplanBase\Globals\Models\Tenant;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;


/**
 * Seeder Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class RoleSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return      void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        if (Role::find(1) === null) {
            $date = date('Y-m-d H:i:s');

            $Tenant = Tenant::where('identifier', 'System')->first();

            Role::insert([
                [
                    'uuid' => Str::uuid(),
                    "active" => 1,
                    "created_at" => $date,
                    "updated_at" => $date,
                    "identifier" => 'Admin',
                    "internal" => 1,
                    "labels" => '{"de": "Administrator", "en": "Administrator"}',
                    'tenant_id' => $Tenant->id,
                ], [
                    'uuid' => Str::uuid(),
                    "active" => 1,
                    "created_at" => $date,
                    "updated_at" => $date,
                    "identifier" => 'Host',
                    "internal" => 0,
                    "labels" => '{"de": "Gastgeber", "en": "Host"}',
                    'tenant_id' => $Tenant->id,
                ], [
                    'uuid' => Str::uuid(),
                    "active" => 1,
                    "created_at" => $date,
                    "updated_at" => $date,
                    "identifier" => 'Logistics',
                    "internal" => 0,
                    "labels" => '{"de": "Logistik", "en": "Logistics"}',
                    'tenant_id' => $Tenant->id,
                ], [
                    'uuid' => Str::uuid(),
                    "active" => 1,
                    "created_at" => $date,
                    "updated_at" => $date,
                    "identifier" => 'Report',
                    "internal" => 0,
                    "labels" => '{"de": "Report", "en": "Report"}',
                    'tenant_id' => $Tenant->id,
                ],

            ]);

        }
    } // run()

} // class RoleSeeder extends Seeder {}
