<?php
/**
 * Admin Controller Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Controllers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Http\Controllers\Core;


use BplanBase\Globals\Foundation\Http\Controllers\CoreController;
use BplanBase\Globals\Livewire\Core\ModuleTenants\Form as ModuleTenantForm;
use BplanBase\Globals\Livewire\Core\ModuleTenants\Grid as ModuleTenantGrid;
use BplanBase\Globals\Models\ModuleTenant;
use BplanBase\Globals\Repositories\ModuleTenantRepository;
use BplanBase\Globals\Services\ModuleTenantService;
use Illuminate\Http\Request;


/**
 * Admin Controller Class
 *
 * @version     1.0.0 / 2025-05-25
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ModuleTenantController extends CoreController
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected string $_formClass = ModuleTenantForm::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_gridClass = ModuleTenantGrid::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_modelClass = ModuleTenant::class;


    /**
     * @var     string $_repositoryClass
     */
    protected string $_repositoryClass = ModuleTenantRepository::class;


    /**
     * @var     string $_resourceName
     */
    protected string $_resourceName = 'tenant-modules';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Request $Request
     *
     * @param       ModuleTenantService $Service
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Request $Request, ModuleTenantService $Service)
    {
        parent::__construct($Request, $Service);

    } // __construct()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class ModuleTenantController extends CoreController {}
