<?php
/**
 * ValueObject Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  ValueObjects
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\ValueObjects;


use Closure;


/**
 * ValueObject Class
 *
 * @version     1.0.0 / 2025-06-04
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
readonly class PaginateArgs
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       int|null|Closure $perPage
     *
     * @param       array|string $columns
     *
     * @param       string $pageName
     *
     * @param       int|null $page
     *
     * @param       Closure|int|null $total
     *
     * @version     1.0.0 / 2025-06-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(
        public int|null|Closure $perPage = 15,
        public array|string $columns = ['*'],
        public string $pageName = 'page',
        public int|null $page = null,
        public Closure|int|null $total = null

    ) {} // __construct()


    /**
     *
     * @version     1.0.0 / 2025-06-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function toArray(): array
    {
        return [
            $this->perPage,
            $this->columns,
            $this->pageName,
            $this->page,
            $this->total
        ];
    } // toArray()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array|boolean|integer|null $input
     *
     * @return      self
     *
     * @version     1.0.0 / 2025-06-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function from(array|bool|int|null $input): self
    {
        if ($input === false || $input === null) {
            return new self();
        }
        if ($input === true) {
            return new self(perPage: config('globals.paginate.per-page'));
        }
        if (is_int($input)) {
            return new self(perPage: $input);
        }
        if (is_array($input)) {
            return new self(
                perPage:  $input['perPage']  ?? config('globals.paginate.per-page'),
                columns:  $input['columns']  ?? ['*'],
                pageName: $input['pageName'] ?? 'page',
                page:     $input['page']     ?? null,
                total:    $input['total']    ?? null
            );
        }
        throw new \InvalidArgumentException('Invalid pagination input');

    } // from()


} // readonly class PaginateArgs {}
