<?php
/**
 * Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base\globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders;


use BplanBase\Globals\Models\RoleUser;
use BplanBase\Globals\Models\Role;
use BplanBase\Globals\Models\Tenant;
use BplanBase\Globals\Models\User;
use BplanBase\Globals\Repositories\RoleRepository;
use BplanBase\Globals\Repositories\UserRepository;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;


/**
 * Seeder Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class RoleUserSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        if (RoleUser::find(1) === null) {
            $date = date('Y-m-d H:i:s');

            $userRoles = [];

            $Roles = RoleRepository::getAll();

            foreach (UserRepository::getAll(withInternal: true) as $User) {
                foreach ($Roles as $Role) {
                    $userRoles[] = [
                        'uuid' => Str::uuid(),
                        'created_at' => $date,
                        'active' => 1,
                        'role_id' => $Role->id,
                        'user_id' => $User->id,
                    ];
                }
            }
            RoleUser::insert($userRoles);
        }
    } // run()

} // class RoleUserSeeder extends Seeder {}
