<?php
/**
 * Main Seeder Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Seeders
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Database\Seeders;


use BplanBase\Globals\Models\Tenant;
use BplanBase\Globals\Registries\SeederRegistry;
use Illuminate\Database\Seeder;


/**
 * Main Seeder Class
 *
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class DatabaseSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return void
     *
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run(): void
    {
        $Tenant = Tenant::where('identifier', 'System')->first();

        if ($Tenant === null) {
            /*
            **  Register the project seeder in the seeder registry so that it is
            **  executed after the global seeders. */
            SeederRegistry::register(date('Y'), 'Project', self::class);
            SeederRegistry::run($this);

            return;
        }
        if (config('app.env') === 'production') {
            $seeds = [
                //
            ];

        } elseif (config('app.env') === 'demo') {
            $seeds = [
                //
            ];

        } else {
            $seeds = [
                //
            ];
            if (file_exists(__DIR__.'/Dev/DevEnvSeeder.php')) {
                $seeds[] = Dev\DevEnvSeeder::class;
            }
        }
        if (!empty($seeds)) {
            $this->call($seeds);
        }
    } // run()

} // class DatabaseSeeder extends Seeder {}
