<div x-data="createIndividual" x-cloak x-show="show" id="createIndividualModal" tabindex="-1"
    x-on:show-create-individual-modal.window="showCreateIndividualModal()"
    x-on:individual-created.window="onIndividualCreated($event)"
    class="fixed top-0 left-0 right-0 z-50 flex items-center justify-center w-full h-screen overflow-x-hidden overflow-y-auto md:inset-0 md:h-full">
    <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75"></div>
    <div class="relative w-full h-full max-w-2xl p-4 md:h-auto">
        <!-- Modal content -->
        <div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
            <!-- Modal header -->
            <div class="flex items-center justify-between pb-4 mb-4 border-b rounded-t sm:mb-5 dark:border-gray-600">

                <div class="flex items-center space-x-2 text-gray-900 dark:text-white">
                    {{-- <x-fkb-font.piktos-normal.individual class="text-3xl" /> --}}
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        @lang('globals::global.action.create')
                    </h3>
                </div>
                <button x-on:click="hideCreateIndividualModal" type="button"
                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <span class="sr-only">
                        @lang('globals::global.action.close')
                    </span>
                </button>
            </div>
            <!-- Modal body -->
            <div>
                <x-global-components::global.tabs.standard-container>
                    <x-global-components::global.tabs.standard-list-item id="main_data">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                            class="size-6 me-2">
                            <path fill-rule="evenodd"
                                d="M7.5 6a4.5 4.5 0 1 1 9 0 4.5 4.5 0 0 1-9 0ZM3.751 20.105a8.25 8.25 0 0 1 16.498 0 .75.75 0 0 1-.437.695A18.683 18.683 0 0 1 12 22.5c-2.786 0-5.433-.608-7.812-1.7a.75.75 0 0 1-.437-.695Z"
                                clip-rule="evenodd" />
                        </svg>
                        @lang('globals::individuals.tab.main')

                        {{-- @if (!empty(array_intersect(['formOfAddress', 'firstName', 'lastName', 'dateOfBirth', 'street', 'houseNumber', 'zipCode', 'city', 'email', 'phoneNumberCountryCode', 'phoneNumber', 'mobilePhoneNumberCountryCode', 'mobilePhoneNumber'], array_keys($errors->toArray()))))
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                            stroke="currentColor" class="size-6 ms-2 text-red-500">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M12 9v3.75m9-.75a9 9 0 1 1-18 0 9 9 0 0 1 18 0Zm-9 3.75h.008v.008H12v-.008Z" />
                        </svg>
                    @endif --}}
                    </x-global-components::global.tabs.standard-list-item>
                    <x-global-components::global.tabs.standard-list-item id="company">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"
                            class="size-6 me-2">
                            <path fill-rule="evenodd"
                                d="M4.5 2.25a.75.75 0 0 0 0 1.5v16.5h-.75a.75.75 0 0 0 0 1.5h16.5a.75.75 0 0 0 0-1.5h-.75V3.75a.75.75 0 0 0 0-1.5h-15ZM9 6a.75.75 0 0 0 0 1.5h1.5a.75.75 0 0 0 0-1.5H9Zm-.75 3.75A.75.75 0 0 1 9 9h1.5a.75.75 0 0 1 0 1.5H9a.75.75 0 0 1-.75-.75ZM9 12a.75.75 0 0 0 0 1.5h1.5a.75.75 0 0 0 0-1.5H9Zm3.75-5.25A.75.75 0 0 1 13.5 6H15a.75.75 0 0 1 0 1.5h-1.5a.75.75 0 0 1-.75-.75ZM13.5 9a.75.75 0 0 0 0 1.5H15A.75.75 0 0 0 15 9h-1.5Zm-.75 3.75a.75.75 0 0 1 .75-.75H15a.75.75 0 0 1 0 1.5h-1.5a.75.75 0 0 1-.75-.75ZM9 19.5v-2.25a.75.75 0 0 1 .75-.75h4.5a.75.75 0 0 1 .75.75v2.25a.75.75 0 0 1-.75.75h-4.5A.75.75 0 0 1 9 19.5Z"
                                clip-rule="evenodd" />
                        </svg>

                        @lang('globals::individuals.tab.company')

                        {{-- @if (!empty(array_intersect(['company', 'companyCity', 'companyHouseNumber', 'companyStreet', 'companyZipCode', 'dateOfEntry', 'department', 'function', 'identificationNumber', 'location', 'personnelNumber'], array_keys($errors->toArray()))))
                        <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                            stroke="currentColor" class="size-6 ms-2 text-red-500">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M12 9v3.75m9-.75a9 9 0 1 1-18 0 9 9 0 0 1 18 0Zm-9 3.75h.008v.008H12v-.008Z" />
                        </svg>
                    @endif --}}
                    </x-global-components::global.tabs.standard-list-item>
                </x-global-components::global.tabs.standard-container>

                <div x-show="currentTab == 'main_data'">
                    <div class="grid gap-4 mb-4 sm:grid-cols-2">
                        <x-global-components::inputs.select wire:model="form.gender" :active="$fieldDefinition['gender']->active" :mandatory="$fieldDefinition['gender']->mandatory"
                            :readonly="$fieldDefinition['gender']->readonly" label="{{ __('globals::individuals.field.gender') }}" :items="[
                                [
                                    'label' => 'Männlich',
                                    'value' => 'm',
                                ],
                                [
                                    'label' => 'Weiblich',
                                    'value' => 'w',
                                ],
                            ]" />
                        <x-global-components::inputs.select wire:model="form.form_of_address" :active="$fieldDefinition['form_of_address']->active"
                            :mandatory="$fieldDefinition['form_of_address']->mandatory" :readonly="$fieldDefinition['form_of_address']->readonly"
                            label="{{ __('globals::individuals.field.form_of_address') }}" :items="[
                                [
                                    'label' => 'Herr',
                                    'value' => 'mr',
                                ],
                                [
                                    'label' => 'Frau',
                                    'value' => 'mrs',
                                ],
                            ]" />
                        <x-global-components::inputs.input wire:model="form.first_name" :active="$fieldDefinition['first_name']->active"
                            :mandatory="$fieldDefinition['first_name']->mandatory" :readonly="$fieldDefinition['first_name']->readonly"
                            label="{{ __('globals::individuals.field.first_name') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                        <x-global-components::inputs.input wire:model="form.last_name" :active="$fieldDefinition['last_name']->active"
                            :mandatory="$fieldDefinition['last_name']->mandatory" :readonly="$fieldDefinition['last_name']->readonly"
                            label="{{ __('globals::individuals.field.last_name') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />

                        <x-global-components::inputs.input wire:model="form.date_of_birth" :active="$fieldDefinition['date_of_birth']->active"
                            :mandatory="$fieldDefinition['date_of_birth']->mandatory" :readonly="$fieldDefinition['date_of_birth']->readonly" type="date"
                            label="{{ __('globals::individuals.field.date_of_birth') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />

                        <x-global-components::inputs.input wire:model="form.email" :active="$fieldDefinition['email']->active" :mandatory="$fieldDefinition['email']->mandatory"
                            :readonly="$fieldDefinition['email']->readonly" type="text" label="{{ __('globals::individuals.field.email') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />

                        <x-global-components::inputs.input wire:model="form.mobile_phone_number" :active="$fieldDefinition['mobile_phone_number']->active"
                            :mandatory="$fieldDefinition['mobile_phone_number']->mandatory" :readonly="$fieldDefinition['mobile_phone_number']->readonly" type="text"
                            label="{{ __('globals::individuals.field.mobile_phone_number') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                        <x-global-components::inputs.input wire:model="form.mobile_phone_number_country_code"
                            :active="$fieldDefinition['mobile_phone_number_country_code']->active" :mandatory="$fieldDefinition['mobile_phone_number_country_code']->mandatory" :readonly="$fieldDefinition['mobile_phone_number_country_code']->readonly" type="text"
                            label="{{ __('globals::individuals.field.mobile_phone_number_country_code') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                        {{-- <x-global-components::inputs.input wire:model="form.mobile_phone_number_full" :active="$fieldDefinition['mobile_phone_number_full']->active"
                            :mandatory="$fieldDefinition['mobile_phone_number_full']->mandatory" :readonly="$fieldDefinition['mobile_phone_number_full']->readonly" type="text"
                            label="{{ __('globals::individuals.field.mobile_phone_number_full') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" /> --}}
                        <x-global-components::inputs.input wire:model="form.phone_number" :active="$fieldDefinition['phone_number']->active"
                            :mandatory="$fieldDefinition['phone_number']->mandatory" :readonly="$fieldDefinition['phone_number']->readonly" type="text"
                            label="{{ __('globals::individuals.field.phone_number') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                        <x-global-components::inputs.input wire:model="form.phone_number_country_code"
                            :active="$fieldDefinition['phone_number_country_code']->active" :mandatory="$fieldDefinition['phone_number_country_code']->mandatory" :readonly="$fieldDefinition['phone_number_country_code']->readonly" type="text"
                            label="{{ __('globals::individuals.field.phone_number_country_code') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                        {{-- <x-global-components::inputs.input wire:model="form.phone_number_full" :active="$fieldDefinition['phone_number_full']->active"
                            :mandatory="$fieldDefinition['phone_number_full']->mandatory" :readonly="$fieldDefinition['phone_number_full']->readonly" type="text"
                            label="{{ __('globals::individuals.field.phone_number_full') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" /> --}}

                        {{-- <x-global-components::inputs.input wire:model="form.companyCity" :active="$fieldDefinition['CompanyCity']->active" :mandatory="$fieldDefinition['CompanyCity']->mandatory" :readonly="$fieldDefinition['CompanyCity']->readonly"
                        label="{{ __('globals::individuals.field.company_city') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" /> --}}
                        {{-- <x-global-components::inputs.input wire:model="form.companyHouseNumber" :active="$fieldDefinition['CompanyHouseNumber']->active" :mandatory="$fieldDefinition['CompanyHouseNumber']->mandatory"
                        :readonly="$fieldDefinition['CompanyHouseNumber']->readonly" label="{{ __('globals::individuals.field.company_house_number') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" /> --}}
                        {{-- <x-global-components::inputs.input wire:model="form.companyStreet" :active="$fieldDefinition['CompanyStreet']->active" :mandatory="$fieldDefinition['CompanyStreet']->mandatory" :readonly="$fieldDefinition['CompanyStreet']->readonly"
                        label="{{ __('globals::individuals.field.company_street') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" /> --}}
                        {{-- <x-global-components::inputs.input wire:model="form.companyZipCode" :active="$fieldDefinition['CompanyZipCode']->active" :mandatory="$fieldDefinition['CompanyZipCode']->mandatory"
                        :readonly="$fieldDefinition['CompanyZipCode']->readonly" label="{{ __('globals::individuals.field.company_zip_code') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" /> --}}

                        {{-- <x-global-components::inputs.input wire:model="form.identificationNumber" :active="$fieldDefinition['IdentificationNumber']->active" :mandatory="$fieldDefinition['IdentificationNumber']->mandatory"
                        :readonly="$fieldDefinition['IdentificationNumber']->readonly" label="{{ __('globals::individuals.field.identification_number') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" /> --}}
                        {{-- <x-global-components::inputs.input wire:model="form.location" :active="$fieldDefinition['Location']->active" :mandatory="$fieldDefinition['Location']->mandatory" :readonly="$fieldDefinition['Location']->readonly"
                        label="{{ __('globals::individuals.field.location') }}"
                        class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" /> --}}
                    </div>
                </div>
                <div x-show="currentTab == 'company'">
                    <div class="grid gap-4 mb-4 sm:grid-cols-2">
                        <x-global-components::inputs.input wire:model="form.company" :active="$fieldDefinition['company']->active"
                            :mandatory="$fieldDefinition['company']->mandatory" :readonly="$fieldDefinition['company']->readonly"
                            label="{{ __('globals::individuals.field.company') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                        <div class="flex items-center">
                            <x-global-components::inputs.toggle wire:model="form.contact" :active="$fieldDefinition['contact']->active"
                                :mandatory="$fieldDefinition['contact']->mandatory" :readonly="$fieldDefinition['contact']->readonly"
                                label="{{ __('globals::individuals.field.contact') }}" />
                        </div>
                        <x-global-components::inputs.input wire:model="form.contact_group" :active="$fieldDefinition['contact_group']->active"
                            :mandatory="$fieldDefinition['contact_group']->mandatory" :readonly="$fieldDefinition['contact_group']->readonly" type="text"
                            label="{{ __('globals::individuals.field.contact_group') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                        <x-global-components::inputs.input wire:model="form.cost_center" :active="$fieldDefinition['cost_center']->active"
                            :mandatory="$fieldDefinition['cost_center']->mandatory" :readonly="$fieldDefinition['cost_center']->readonly" type="text"
                            label="{{ __('globals::individuals.field.cost_center') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                        <div class="flex items-center">
                            <x-global-components::inputs.toggle wire:model="form.emergency_contact" :active="$fieldDefinition['emergency_contact']->active"
                                :mandatory="$fieldDefinition['emergency_contact']->mandatory" :readonly="$fieldDefinition['emergency_contact']->readonly"
                                label="{{ __('globals::individuals.field.emergency_contact') }}" />
                        </div>
                        <div class="flex items-center">
                            <x-global-components::inputs.toggle wire:model="form.global_contact" :active="$fieldDefinition['global_contact']->active"
                                :mandatory="$fieldDefinition['global_contact']->mandatory" :readonly="$fieldDefinition['global_contact']->readonly"
                                label="{{ __('globals::individuals.field.global_contact') }}" />
                        </div>
                        <x-global-components::inputs.input wire:model="form.id_number" :active="$fieldDefinition['id_number']->active"
                            :mandatory="$fieldDefinition['id_number']->mandatory" :readonly="$fieldDefinition['id_number']->readonly" type="text"
                            label="{{ __('globals::individuals.field.id_number') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                        <x-global-components::inputs.input wire:model="form.job_title" :active="$fieldDefinition['job_title']->active"
                            :mandatory="$fieldDefinition['job_title']->mandatory" :readonly="$fieldDefinition['job_title']->readonly" type="text"
                            label="{{ __('globals::individuals.field.job_title') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                        <x-global-components::inputs.input wire:model="form.organizational_unit" :active="$fieldDefinition['organizational_unit']->active"
                            :mandatory="$fieldDefinition['organizational_unit']->mandatory" :readonly="$fieldDefinition['organizational_unit']->readonly" type="text"
                            label="{{ __('globals::individuals.field.organizational_unit') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                        <x-global-components::inputs.input wire:model="form.date_of_entry" :active="$fieldDefinition['date_of_entry']->active"
                            :mandatory="$fieldDefinition['date_of_entry']->mandatory" :readonly="$fieldDefinition['date_of_entry']->readonly" type="date"
                            label="{{ __('globals::individuals.field.date_of_entry') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                        <x-global-components::inputs.input wire:model="form.department" :active="$fieldDefinition['department']->active"
                            :mandatory="$fieldDefinition['department']->mandatory" :readonly="$fieldDefinition['department']->readonly"
                            label="{{ __('globals::individuals.field.department') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                        <x-global-components::inputs.input wire:model="form.function" :active="$fieldDefinition['function']->active"
                            :mandatory="$fieldDefinition['function']->mandatory" :readonly="$fieldDefinition['function']->readonly"
                            label="{{ __('globals::individuals.field.function') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                        <x-global-components::inputs.input wire:model="form.personnel_number" :active="$fieldDefinition['personnel_number']->active"
                            :mandatory="$fieldDefinition['personnel_number']->mandatory" :readonly="$fieldDefinition['personnel_number']->readonly"
                            label="{{ __('globals::individuals.field.personnel_number') }}"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500" />
                    </div>
                </div>

                <div x-cloak x-show="createSucceeded"
                    class="p-4 mb-4 text-primary-800 border border-primary-300 rounded-lg bg-primary-50 dark:bg-gray-800 dark:text-primary-400 dark:border-primary-800"
                    role="alert">
                    <div class="flex items-center">
                        <svg class="flex-shrink-0 w-4 h-4 me-2" aria-hidden="true" xmlns="http://www.w3.org/2000/svg"
                            fill="currentColor" viewBox="0 0 20 20">
                            <path
                                d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z" />
                        </svg>
                        <span class="sr-only">
                            @lang('globals::individuals.info.heading')
                        </span>
                        <h3 class="text-lg font-medium">
                            @lang('globals::individuals.info.heading')
                        </h3>
                    </div>
                    <div class="mt-2 mb-4 text-sm">
                        @lang('globals::individuals.info.individual-recives-login-details')
                    </div>
                </div>
                <div x-cloak x-show="!createSucceeded" class="flex justify-end">
                    <button wire:loading.remove wire:target="create" wire:click="create" type="button"
                        class="text-white inline-flex items-center bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                        <svg class="w-6 h-6 mr-1 -ml-1" fill="currentColor" viewBox="0 0 20 20"
                            xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M10 5a1 1 0 011 1v3h3a1 1 0 110 2h-3v3a1 1 0 11-2 0v-3H6a1 1 0 110-2h3V6a1 1 0 011-1z"
                                clip-rule="evenodd"></path>
                        </svg>
                        @lang('globals::global.action.create')
                    </button>
                    <x-global-components::global.loading-spinner wire:loading wire:target="create" />
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('alpine:init', () => {
            Alpine.data('createIndividual', () => ({
                show: false,
                createSucceeded: false,
                currentTab: 'main_data',

                // CREATE
                onIndividualCreated(event) {
                    this.createSucceeded = true;
                },
                resetIndividualCreated() {
                    this.createSucceeded = false;

                    @this.name = null;
                    @this.email = null;
                },
                hideCreateIndividualModal() {
                    this.show = false;
                    this.resetIndividualCreated();
                },
                showCreateIndividualModal(id) {
                    this.show = true;

                    setTimeout(() => {
                        document.getElementById('name').focus();
                    }, 100);
                }
            }));
        });
    </script>
</div>
