<?php
/**
 * Admin Controller Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Controllers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Http\Controllers\Core;


use BplanBase\Globals\Foundation\Http\Controllers\CoreController;
use BplanBase\Globals\Livewire\Core\TenantExternalSystems\Form as TenantExternalSystemForm;
use BplanBase\Globals\Livewire\Core\TenantExternalSystems\Grid as TenantExternalSystemGrid;
use BplanBase\Globals\Models\TenantExternalSystem;
use BplanBase\Globals\Repositories\TenantExternalSystemRepository;
use BplanBase\Globals\Services\TenantExternalSystemService;
use Illuminate\Http\Request;


/**
 * Admin Controller Class
 *
 * @version     2.0.0 / 2025-06-03
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantExternalSystemController extends CoreController
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_modelClass
     */
    protected string $_formClass = TenantExternalSystemForm::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_gridClass = TenantExternalSystemGrid::class;


    /**
     * @var     string $_modelClass
     */
    protected string $_modelClass = TenantExternalSystem::class;


    /**
     * @var     string $_repositoryClass
     */
    protected string $_repositoryClass = TenantExternalSystemRepository::class;


    /**
     * @var     string $_resourceName
     */
    protected string $_resourceName = 'tenant-external-systems';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Request $Request
     *
     * @param       TenantExternalSystemService $Service
     *
     * @version     1.0.0 / 2025-05-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Request $Request, TenantExternalSystemService $Service)
    {
        parent::__construct($Request, $Service);

    } // __construct()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class TenantExternalSystemController extends CoreController {}
