<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Migrations
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('entity_type_fields');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('entity_type_fields', function (Blueprint $Table) {
            $Table->id();
            $Table->uuid('uuid');
            $Table->boolean('active')->default(1);

            $Table->timestamp('created_at');
            $Table->softDeletes('deleted_at');
            $Table->timestamp('updated_at');

            $Table->string('api_field_name', 50)->nullable();
            $Table->string('db_field_name', 50);
            $Table->foreignId('entity_type_id')->constrained(table: 'entity_types', indexName: 'entity_type_fields_FK_entity_type_id');
            $Table->unsignedTinyInteger('grid_order')->nullable()->comment('Grid-Spalten haben einen von NULL abweichenden Wert.');
            $Table->string('identifier', 30);
            $Table->json('infos')->nullable();
            $Table->json('labels')->nullable();
            $Table->boolean('mandatory')->default(0);

            $Table->index('entity_type_id', 'entity_type_fields_FKI_entity_type_id');
            $Table->unique('uuid',          'entity_type_fields_UKI_uuid');

            new CodeGenerator($Table, [
                'appends' => [
                    'info' => [
                        'type' => 'locale',
                    ],
                    'label' => [
                        'default' => '$this->identifier',
                        'type' => 'locale',
                    ],
                ],
                'columns' => [
                    'active' => [
                        'sortable' => true,
                    ],
                    'db_field_name' => [
                        'sortable' => true,
                    ],
                    'entity_type_id' => [
                        'sortable' => true,
                        'reverseRelationName' => 'fields',
                    ],
                    'identifier' => [
                        'sortable' => true,
                    ],
                    'infos' => [
                        'jsonType' => CodeGenerator::JSON_TYPE_OBJECT,
                    ],
                    'labels' => [
                        'jsonType' => CodeGenerator::JSON_TYPE_OBJECT,
                        'sortable' => true,
                    ],
                ],
                'exclude' => [
                    'livewire.index',
                    'livewire.modal.create',
                    'livewire.modal.edit',
                ],
                'indexQueries' => [
                    'terminal' => '$Query->where(\'active\', \'=\', 1)',
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],
//                'traits' => [
//                    'laravel.model' => [
//                        'BplanBase\\Globals\Traits\\HasActiveScope',
//                        'BplanBase\\Globals\Traits\\HasOrderedScope',
//                    ],
//                ],

            ]);

        });
    } // up()


};
