<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders\Dev\EntityTypes;


use BplanBase\Globals\Models\EntityType;
use BplanBase\Globals\Models\Individual;
use BplanBase\Globals\Models\Tenant;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class IndividualEmployeeDataSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return      void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        $Tenant = Tenant::where('identifier', '=', 'System')->first();
        $EntityType = EntityType::where('identifier', '=', 'Individual.Employee')->first();

        Individual::insert([
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'deleted_at' => null,
                'updated_at' => $date,
                'contact' => 0,
                'contact_group' => null,
                'date_of_birth' => null,
                'date_of_entry' => null,
                'department' => null,
                'email' => 'hubert.meyer@example.com',
                'emergency_contact' => 0,
                'entity_type_id' => $EntityType->id,
                'first_name' => 'Hubert',
                'form_of_address' => null,
                'function' => null,
                'global_contact' => 0,
                'last_name' => 'Meyer',
                'mobile_phone_number' => '1638441315',
                'mobile_phone_number_country_code' => '+49',
                'mobile_phone_number_full' => '+491638441315',
                'personnel_number' => null,
                'phone_number' => '22039898983',
                'phone_number_country_code' => null,
                'phone_number_full' => '+4922039898983',
                // 'tenant_id' => $Tenant->id,
                'user_id' => null,
            ],


        ]);

    } // run()

} // class IndividualEmployeeDataSeeder extends Seeder {}
