<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Bootstrap
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

use BplanBase\Globals\PackageServiceProvider as GlobalsServiceProvider;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;


return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->api(
            append: GlobalsServiceProvider::getMiddlewares('api', 'append'),
            prepend: GlobalsServiceProvider::getMiddlewares('api', 'prepend')
        );
        $middleware->web(
            append: GlobalsServiceProvider::getMiddlewares('web', 'append'),
            prepend: GlobalsServiceProvider::getMiddlewares('web', 'prepend')
        );
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
