<?php
/**
 * Repository Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Repositories
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Repositories\Core;


use App\Models\TenantUser as DerivedTenantUser;
use BplanBase\Globals\Models\User;
use BplanBase\Globals\Repositories\TenantUserRepository as BaseRepository;
use Illuminate\Database\Eloquent\Collection;


/**
 * Repository Class
 *
 * @version     1.0.0 / 2025-06-03
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantUserRepository extends BaseRepository
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Liefert eine Collection mit den Tenant-Verknüpfungen des Users
     *
     * @param       int|string|User|DerivedTenantUser $user
     *
     * @return      Collection
     *
     * @version     1.0.0 / 2025-06-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getUserTenants(int|string|User|DerivedTenantUser $user): Collection
    {
        if ($user instanceof User) {
            $userId = $user->id;
        } else {
            $userId = $user;
        }
        $Query = static::$_modelClass::where('user_id', '=', $userId);

        return $Query->get();

    } // getUserTenants()


} // class TenantUserRepository extends BaseRepository {}
