<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Migrations
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('module_tenant');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('module_tenant', function (Blueprint $Table) {
            $Table->id();
            $Table->uuid('uuid');
            $Table->boolean('active')->default(1);

            $Table->timestamp('created_at');
            $Table->timestamp('updated_at');

            $Table->foreignId('module_id')->nullable()->constrained(table: 'modules', indexName: 'module_tenant_FK_module_id');
            $Table->foreignId('tenant_id')->nullable()->constrained(table: 'tenants', indexName: 'module_tenant_FK_tenant_id');

            $Table->index('module_id', 'module_tenant_FKI_module_id');
            $Table->index('tenant_id', 'module_tenant_FKI_tenant_id');
            $Table->unique('uuid',     'module_tenant_UKI_uuid');

            new CodeGenerator($Table, [
                'columns' => [
                    'uuid' => [
                        'guarded' => true,
                    ],
                    'active' => [
                        'sortable' => true,
                    ],
                    'tenant_id' => [
                        // 'reverseRelationName' => 'modules',
                    ],
                ],
                'indexQueries' => [
                    'terminal' => '$Query->where(\'active\', \'=\', 1)',
                ],
                'exclude' => [
                    'livewire.index',
                    'livewire.modal.create',
                    'livewire.modal.edit',
                ],
                'pivot' => [
                    'relations' => [
                        'module_id' => 'modules',
                        'tenant_id' => 'tenants',
                    ],
                ],
                'routing' => [
                    'terminal' => 'readOnly',
                ],
//                'traits' => [
//                    'laravel.model' => [
//                        'BplanBase\\Globals\Traits\\HasActiveScope',
//                        'BplanBase\\Globals\Traits\\HasOrderedScope',
//                    ],
//                ],
                'uses' => [
                    'laravel.model' => [
                        'BplanBase\\Globals\\Scopes\\TenantScope',
                    ]
                ],

            ]);

        });
    } // up()

};
