<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Seeders
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Database\Seeders\EntityTypes;


use BplanBase\Globals\Models\EntityType;
use BplanBase\Globals\Models\EntityTypeField;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;


/**
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class IndividualEmployeeFieldSeeder extends Seeder
{

    /**
     * Run the database seeds.
     *
     * @return      void
     *
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function run()
    {
        $date = date('Y-m-d H:i:s');

        $EntityType = EntityType::where('identifier', '=', 'Individual.Employee')->first();

        EntityTypeField::insert([
            /*
                Technical Fields:
                - uuid
                - created_at
                - deleted_at
                - updated_at
                - entity_type_id
            */
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'company',
                'entity_type_id' => $EntityType->id,
                'grid_order' => 3,
                'identifier' => 'Company',
                'labels' => '{"de": "Firma", "en": "Company"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'contact',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'Contact',
                'labels' => '{"de": "Kontaktperson", "en": "Contact person"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'contact_group',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'ContactGroup',
                'labels' => '{"de": "Kontaktgruppe", "en": "Contact group"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'cost_center',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'CostCenter',
                'labels' => '{"de": "Kostenstelle", "en": "Cost center"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'date_of_birth',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'DateOfBirth',
                'labels' => '{"de": "Geburtsdatum", "en": "Date of birth"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'date_of_entry',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'DateOfEntry',
                'labels' => '{"de": "Eintrittsdatum", "en": "Date of entry"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'department',
                'entity_type_id' => $EntityType->id,
                'grid_order' => 4,
                'identifier' => 'Department',
                'labels' => '{"de": "Abteilung", "en": "Department"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'email',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'Email',
                'labels' => '{"de": "E-Mail", "en": "Email"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'emergency_contact',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'EmergencyContact',
                'labels' => '{"de": "Notfallkontakt", "en": "Emergency contact"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'first_name',
                'entity_type_id' => $EntityType->id,
                'grid_order' => 2,
                'identifier' => 'FirstName',
                'labels' => '{"de": "Vorname", "en": "First name"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'form_of_address',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'FormOfAddress',
                'labels' => '{"de": "Anrede", "en": "Form of address"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'function',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'Function',
                'labels' => '{"de": "Funktion", "en": "Function"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'gender',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'Gender',
                'labels' => '{"de": "Geschlecht", "en": "Gender"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'global_contact',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'GlobalContact',
                'labels' => '{"de": "Globaler Kontakt", "en": "Global contact"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'id_number',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'IdNumber',
                'labels' => '{"de": "ID-Nummer", "en": "ID number"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'job_title',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'JobTitle',
                'labels' => '{"de": "Berufsbezeichnung", "en": "Job title"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'last_name',
                'entity_type_id' => $EntityType->id,
                'grid_order' => 1,
                'identifier' => 'LastName',
                'labels' => '{"de": "Nachname", "en": "Last name"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'license_plate',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'LicensePlate',
                'labels' => '{"de": "Kfz-Kennzeichen", "en": "License plate"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'mobile_phone_number',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'MobilePhoneNumber',
                'labels' => '{"de": "Telefonnummer (mobil)", "en": "Mobile phone number"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'mobile_phone_number_country_code',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'MobilePhoneNumberCountryCode',
                'labels' => '{"de": "Ländervorwahl (mobil)", "en": "Mobile phone number country code"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'mobile_phone_number_full',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'MobilePhoneNumberFull',
                'labels' => '{"de": "Telefonnummer (mobil, vollständig)", "en": "Mobile phone number (full)"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'organizational_unit',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'OrganizationalUnit',
                'labels' => '{"de": "Organisationseinheit", "en": "Organizational unit"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'personnel_number',
                'entity_type_id' => $EntityType->id,
                'grid_order' => 5,
                'identifier' => 'PersonnelNumber',
                'labels' => '{"de": "Personalnummer", "en": "Personnel number"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'phone_number',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'PhoneNumber',
                'labels' => '{"de": "Telefonnummer", "en": "Phone number"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'phone_number_country_code',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'PhoneNumberCountryCode',
                'labels' => '{"de": "Ländervorwahl", "en": "Phone number country code"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'phone_number_full',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'PhoneNumberFull',
                'labels' => '{"de": "Telefonnummer (komplett)", "en": "Phone number (full)"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'user_id',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'UserId',
                'labels' => '{"de": "User-ID", "en": "User-ID"}',
            ],
            [
                'uuid' => Str::uuid(),
                'active' => 1,
                'created_at' => $date,
                'updated_at' => $date,
                'api_field_name' => null,
                'db_field_name' => 'var_001',
                'entity_type_id' => $EntityType->id,
                'grid_order' => null,
                'identifier' => 'Var001',
                'labels' => '{"de": "Var001", "en": "Var001"}',
            ],

        ]);

    } // run()

} // class IndividualEmployeeFieldSeeder extends Seeder {}
