<?php
/**
 * Historize Trait
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Traits
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Traits;


use App\Models\User;
use BplanBase\Globals\Enums\HistoryAction;
use Illuminate\Database\Eloquent\Model;


/**
 * Historize Trait
 *
 * @version     1.0.0 / 2025-03-18
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
trait ModelIsHistorizable
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-03-18
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     */
    public function getHistoriezableArray(Model $Model, HistoryAction $HistoryAction, string $idColumnName = 'model_id'): array
    {
        $HistoryModel = $Model->replicate(['deleted_at']);

        $HistoryModel->{$idColumnName} = $Model->id;
        $HistoryModel->action = $HistoryAction->value;

        if(auth()->user() instanceof User) {
            $HistoryModel->user_id = auth()->id() ?? 1;

        } else {
            // Seed or instanceof Terminal
            $HistoryModel->user_id = 1;
        }
        return  $HistoryModel->getAttributes();

    } // getHistoriezableArray()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // trait ModelIsHistorizable {}
