@props(['disabled' => false, 'label' => null, 'active' => true, 'mandatory' => false, 'readonly' => false, 'items' => []])

<div x-show="{{ $active ? 'true' : 'false' }}">
    @if (!empty($label))
        <div class="flex items-center">
            <x-label :for="$attributes['id']" :value="$label" />
            @if ($mandatory)
                <span class="text-red-500">*</span>
            @endif
        </div>
    @endif

    <select {{ $disabled ? 'disabled' : '' }} {!! $attributes->merge([
        'class' =>
            'bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500',
    ]) !!}>
        <option selected>
            {{ __('globals::global.select-option.please-select') }}
        </option>
        @foreach ($items as $item)
            <option value="{{ $item['value'] }}">{{ $item['label'] }}</option>
        @endforeach
    </select>

    <x-input-error :for="$attributes['wire:model']" />
</div>
