<?php
/**
 * LogLevel Enum Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Enums
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Enums;


/**
 * LogLevel Enum Class
 *
 * @version     1.0.0 / 2025-04-18
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 */
enum LogLevel: string
{


/* +++ CASES +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    case Alert     = 'alert';

    case Critical  = 'critical';

    case Debug     = 'debug';

    case Emergency = 'emergency';

    case Error     = 'error';

    case Info      = 'info';

    case Notice    = 'notice';

    case Warning   = 'warning';


/* +++ STATIC METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // enum LogLevel {}
