<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Locales
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */


use Carbon\WeekDay;


return [

    'iso-3166-1-alpha-2' => 'gb',
    'language' => 'English',
    'locale' => 'en_GB',

    'currency.decimals'        => "2",
    'currency.format.string'   => '£:value',
    'currency.format.negative' => '-£:value',
    'currency.iso4217.alpha'   => 'GBP',
    'currency.iso4217.numeric' => 826,
    'currency.name'            => 'British Pound',
    'currency.subunit.divisor' => 100,
    'currency.subunit.name'    => 'Penny',
    'currency.subunit.symbol'  => 'p',
    'currency.symbol'          => '£',

    'date.format'       => 'd/m/Y',
    'datetime.format'   => 'd/m/Y H:i',
    'datetime.format+'  => 'd/m/Y H:i:s',
    'datetime.format-+' => 'd/m/Y H:i',
    'datetime.format++' => 'd/m/Y H:i:s',
    'time.format'       => 'H:i',
    'time.format+'      => 'H:i:s',
    'time.format-+'     => 'H:i',
    'time.format++'     => 'H:i:s',

    'number.decimal-point'       => '.',
    'number.thousands-separator' => ',',

    'text.direction'    => 'ltr',
    'text.orientation'  => 'sideways',
    'text.writing-mode' => 'vertical-rl',

    // -------------------------------------------------------------------

    'action.activate'      => 'Activate',
    'action.add'           => 'Add',
    'action.cancel'        => 'Cancel',
    'action.cancel-upload' => 'Cancel Upload',
    'action.change'        => 'Change',
    'action.close'         => 'Close',
    'action.confirm'       => 'Confirm',
    'action.deactivate'    => 'Deactivate',
    'action.delete'        => 'Delete',
    'action.edit'          => 'Edit',
    'action.import'        => 'Import',
    'action.print'         => 'Print',
    'action.save'          => 'Save',
    'action.search'        => 'Search',
    'action.sync'          => 'Sync',
    'action.upload'        => 'Upload File',
    'action.verify'        => 'Verify',
    'action.view'          => 'View',

    'languages' => [
        'bg' => 'Bulgarian',
        'de' => 'German',
        'en' => 'English',
        'es' => 'Spanish',
        'fr' => 'French',
        'hu' => 'Hungarian',
        'it' => 'Italian',
        'lt' => 'Lithuanian',
        'lv' => '',
        'pl' => 'Polish',
        'ro' => 'Romanian',
        'ru' => 'Russian',
        'tr' => 'Turkish',
        'uk' => 'Ukrainian',
    ],

    'option.yes' => 'Yes',
    'option.no'  => 'No',

    'required-hint'   => 'Fields marked (<span class="required-marker">:marker</span>) are required',
    'required-marker' => '*',

    'select-option.no-options-available' => 'No options available',
    'select-option.please-select'        => ' -- Please select -- ',

    'status.active'   => 'Active',
    'status.expired'  => 'Expired',
    'status.inactive' => 'Inactive',
    'status.invalid'  => 'Invalid',
    'status.loading'  => 'Loading...',
    'status.not-set'  => 'Not set',
    'status.valid'    => 'Valid',

    'weekdays.'.Weekday::Sunday->name    => 'Sunday',
    'weekdays.'.Weekday::Monday->name    => 'Monday',
    'weekdays.'.Weekday::Tuesday->name   => 'Tuesday',
    'weekdays.'.Weekday::Wednesday->name => 'Wednesday',
    'weekdays.'.Weekday::Thursday->name  => 'Thursday',
    'weekdays.'.Weekday::Friday->name    => 'Friday',
    'weekdays.'.Weekday::Saturday->name  => 'Saturday',

    'weekdays.'.Weekday::Sunday->value    => 'Sunday',
    'weekdays.'.Weekday::Monday->value    => 'Monday',
    'weekdays.'.Weekday::Tuesday->value   => 'Tuesday',
    'weekdays.'.Weekday::Wednesday->value => 'Wednesday',
    'weekdays.'.Weekday::Thursday->value  => 'Thursday',
    'weekdays.'.Weekday::Friday->value    => 'Friday',
    'weekdays.'.Weekday::Saturday->value  => 'Saturday',

];
