<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use BplanBase\Globals\Registries\LocationTypeRegistry;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('location_types');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        $tableName = 'location_types';

        if (Schema::hasTable($tableName) === false) {
            Schema::create($tableName, function (Blueprint $Table) {
                $Table->id();
                $Table->boolean('active')->default(1);

                $Table->timestamps();
                $Table->softDeletes('deleted_at');

                $Table->enum('identifier', LocationTypeRegistry::names());

                $Table->unique('identifier', 'location_types_UKI_identifier');

                $Table->comment('Technische Daten. Es dürfen weder neue Datensätze hinzugefügt noch vorhandene Datensätze verändert oder entfernt werden.');

                new CodeGenerator($Table, [
                    'columns' => [
                        'active' => [
                            'sortable' => true,
                        ],
                        'identifier' => [
                            'rules' => [
                                'Rule::in(LocationTypeRegistry::names())',
                            ],
                            'sortable' => true,
                        ],
                    ],
                    'routing' => [
                        'terminal' => 'readOnly',
                    ],
                    'uses' => [
                        'jsonapi.request' => [
                            // 'BplanBase\\Globals\\Enums\\LocationType',
                            'Illuminate\\Validation\\Rule',
                        ],
                    ],
                ]);

            });

        }
    } // up()


};
