<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  Migrations
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */


use BplanBase\Globals\Enums\ImportContext;
use BplanBase\Globals\Enums\ImportType;
use BplanBase\CodeGenerator\Loaders\CodeGenerator;
use BplanBase\Globals\Enums\ImportStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('import_log_records');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('import_log_records', function (Blueprint $Table) {
            $Table->id();

            $Table->timestamp('created_at');
            $Table->timestamp('updated_at');

            $Table->json('failures')->nullable();
            $Table->foreignId('import_log_id')->constrained(table: 'import_logs', indexName: 'import_log_records_FK_import_log_id');
            $Table->json('row_data')->nullable();
            $Table->enum('status', [array_column(ImportStatus::cases(), 'name')]);

            $Table->index('import_log_id', 'import_log_records_FKI_import_log_id');

            new CodeGenerator($Table, [
                'columns' => [
                    'failures' => [
                        'jsonType' => CodeGenerator::JSON_TYPE_ARRAY,
                    ],
                    'row_data' => [
                        'jsonType' => CodeGenerator::JSON_TYPE_OBJECT,
                    ],
                    'status' => [
                        'rules' => [
                            'required',
                            'Rule::enum(ImportStatus::class)',
                        ],
                        'sortable' => true,
                    ],
                ],
                'exclude' => [
                    'laravel.action.update',
                    'livewire.modal.create',
                    'livewire.modal.edit',
                ],
                'routing' => [
                    'data' => 'readOnly',
                    'terminal' => 'readOnly',
                ],
                'uses' => [
                    'jsonapi.request' => [
                        'BplanBase\\Globals\\Enums\\ImportStatus',
                        'Illuminate\\Validation\\Rule',
                    ],
                    'laravel.form-request.store' => [
                        'BplanBase\\Globals\\Enums\\ImportStatus',
                        'Illuminate\\Validation\\Rule',
                    ],
                    'laravel.form-request.update' => [
                        'BplanBase\\Globals\\Enums\\ImportStatus',
                        'Illuminate\\Validation\\Rule',
                    ],
                ],
            ]);

        });
    } // up()


};
