<div x-data="editUser" x-cloak x-show="show" id="editUserModal" tabindex="-1"
    x-on:show-edit-user-modal.window="showEditUserModal($event)" x-on:user-edited.window="onUserEdited($event)"
    x-on:user-deleted.window="onUserDeleted($event)" x-on:user-password-reset.window="onUserPasswordReset($event)"
    class="fixed top-0 left-0 right-0 z-50 flex items-center justify-center w-full h-screen overflow-x-hidden overflow-y-auto md:inset-0 md:h-full">
    <div class="fixed inset-0 transition-opacity bg-gray-500 bg-opacity-75"></div>
    <div class="relative w-full h-full max-w-2xl p-4 md:h-auto">
        <!-- Modal content -->
        <div class="relative p-4 bg-white rounded-lg shadow dark:bg-gray-800 sm:p-5">
            <!-- Modal header -->
            <div class="flex items-center justify-between pb-4 mb-4 border-b rounded-t sm:mb-5 dark:border-gray-600">

                <div class="flex items-center space-x-2 text-gray-900 dark:text-white">
                    {{-- <x-fkb-font.piktos-normal.user class="text-3xl" /> --}}
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-white">
                        @lang('globals::users.action.edit')
                    </h3>
                </div>
                <button x-on:click="hideEditUserModal" type="button"
                    class="text-gray-400 bg-transparent hover:bg-gray-200 hover:text-gray-900 rounded-lg text-sm p-1.5 ml-auto inline-flex items-center dark:hover:bg-gray-600 dark:hover:text-white">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                    <span class="sr-only">
                        @lang('globals::global.action.close')
                    </span>
                </button>
            </div>
            <!-- Modal body -->
            <div>
                <div class="grid gap-4 mb-4 sm:grid-cols-2">
                    <div>
                        <label for="name" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                            @lang('globals::users.field.name')
                            <x-globals::global.input-required-hint />
                        </label>
                        <input :disabled="editSucceeded" @keyup.enter="$wire.editUser" type="text" wire:model="name"
                            id="name"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('globals::users.field.name')" required=""> <x-input-error for="name" />
                    </div>
                    <div>
                        <label for="email" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
                            @lang('globals::users.field.email')
                            <x-globals::global.input-required-hint />
                        </label>
                        <input :disabled="editSucceeded" @keyup.enter="$wire.editUser" type="email" wire:model="email"
                            id="email"
                            class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-primary-600 focus:border-primary-600 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-primary-500 dark:focus:border-primary-500"
                            placeholder="@lang('globals::users.field.email')" required=""> <x-input-error for="email" />
                    </div>
                </div>

                <div class="inline-flex items-center justify-center w-full">
                    <hr class="w-64 h-px my-8 bg-gray-200 border-0 dark:bg-gray-700">
                    <span
                        class="absolute px-3 font-medium text-gray-900 -translate-x-1/2 bg-white left-1/2 dark:text-white dark:bg-gray-900">
                        {{ __('globals::users.section-heading.roles') }}
                    </span>
                </div>

                <div class="flex justify-around mb-4">
                    @foreach ($roles as $id => $role)
                        <label class="inline-flex items-center cursor-pointer">
                            <input type="checkbox" wire:model="selectedRoles.{{ $id }}"
                                value="{{ $id }}" class="sr-only peer">
                            <div
                                class="relative w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-primary-300 dark:peer-focus:ring-primary-800 rounded-full peer dark:bg-gray-700 peer-checked:after:translate-x-full rtl:peer-checked:after:-translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:start-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all dark:border-gray-600 peer-checked:bg-primary-600">
                            </div>
                            <span class="ms-3 text-sm font-medium text-gray-900 dark:text-gray-300">
                                {{ $role->labels->{app()->getLocale()} ?? 'N/A' }}
                            </span>
                        </label>
                    @endforeach
                </div>
                <div class="flex justify-center">
                    <x-input-error for="selectedRoles" />
                </div>


                <button
                    class="my-4 text-white bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 me-2 mb-2 dark:bg-primary-600 dark:hover:bg-primary-700 focus:outline-none dark:focus:ring-primary-800"
                    x-show="passwordResetVisible" wire:click="resetPassword">
                    @lang('globals::users.action.reset-password')
                </button>
                <p x-show="passwordResettedSuccefully" class="text-sm text-green-500">@lang('globals::users.info.password-reset')</p>

                <div x-cloak x-show="!editSucceeded" class="flex justify-between">
                    <div class="flex items-center space-x-2">
                        <button x-show="!showRemove" class="text-red-600 dark:text-red-500 hover:underline"
                            x-on:click="showRemove = true">
                            @lang('globals::global.action.delete')
                        </button>
                        <div x-cloak x-show="showRemove" wire:loading.remove wire:target="deleteUser">
                            <p class="text-xs text-gray-900 dark:text-white">
                                @lang('global.are_you_sure')</p>
                            <div>
                                <button x-on:click="showRemove = false"
                                    class="font-medium text-fkbgreen-700 dark:text-fkbgreen-600 hover:underline">
                                    @lang('globals::global.action.cancel')
                                </button>
                                <button x-on:click="showRemove = false" wire:click="deleteUser"
                                    class="font-medium text-red-600 dark:text-red-500 hover:underline">
                                    @lang('globals::global.action.delete')
                                </button>
                            </div>
                        </div>
                    </div>

                    <button wire:loading.remove wire:target="editUser" wire:click="editUser" type="button"
                        class="text-white inline-flex items-center bg-primary-700 hover:bg-primary-800 focus:ring-4 focus:outline-none focus:ring-primary-300 font-medium rounded-lg text-sm px-5 py-2.5 text-center dark:bg-primary-600 dark:hover:bg-primary-700 dark:focus:ring-primary-800">
                        <svg class="w-6 h-6 mr-1 -ml-1" fill="currentColor" viewBox="0 0 20 20"
                            xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd"
                                d="M10 5a1 1 0 011 1v3h3a1 1 0 110 2h-3v3a1 1 0 11-2 0v-3H6a1 1 0 110-2h3V6a1 1 0 011-1z"
                                clip-rule="evenodd"></path>
                        </svg>
                        @lang('globals::global.action.save')
                    </button>
                    <x-globals::global.loading-spinner wire:loading wire:target="editUser" />
                </div>
                <div x-show="editSucceeded" class="flex justify-end">
                    <p x-cloak class="mt-2 text-xs text-green-600 dark:text-green-400">
                        @lang('globals::users.info.user-updated')
                    </p>
                </div>
            </div>
        </div>
    </div>

    @script
        <script>
            Alpine.data('editUser', () => ({
                show: false,
                editSucceeded: false,
                showRemove: false,
                passwordResetVisible: true,
                passwordResettedSuccefully: false,

                onUserEdited(event) {
                    this.editSucceeded = true;

                    setTimeout(() => {
                        this.hideEditUserModal();
                        this.resetUserEdited();
                    }, 2000);
                },
                onUserPasswordReset(event) {
                    this.passwordResetVisible = false;
                    this.passwordResettedSuccefully = true;
                },
                onUserDeleted(event) {
                    this.show = false;
                    this.resetUserEdited();
                },
                resetUserEdited() {
                    this.editSucceeded = false;
                    this.showRemove = false;
                    this.passwordResetVisible = true;
                    this.passwordResettedSuccefully = false;

                    @this.name = null;
                    @this.email = null;
                },
                hideEditUserModal() {
                    this.show = false;
                    this.resetUserEdited();
                },
                showEditUserModal(event) {
                    this.show = true;

                    setTimeout(() => {
                        document.getElementById('name').focus();
                    }, 100);
                }
            }));
        </script>
    @endscript
</div>
